/*
 * Decompiled with CFR 0.152.
 */
package cf.terminator.laggoggles.client.gui;

import cf.terminator.laggoggles.client.gui.GuiScanResultsWorld;
import cf.terminator.laggoggles.packet.ObjectData;
import cf.terminator.laggoggles.profiler.ProfileResult;
import cf.terminator.laggoggles.profiler.ScanType;
import cf.terminator.laggoggles.util.Calculations;
import cf.terminator.laggoggles.util.Graphical;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraftforge.fml.client.GuiScrollingList;

public class GuiEntityTypes
extends GuiScrollingList {
    private TreeMap<Long, String> DATA;
    private final FontRenderer FONTRENDERER;
    private static final int slotHeight = 12;
    private int COLUMN_WIDTH_NANOS;
    private int COLUMN_WIDTH_PERCENTAGES;
    private ProfileResult result;

    public GuiEntityTypes(Minecraft client, int width, int height, int top, int bottom, int left, int screenWidth, int screenHeight, ProfileResult result) {
        block15: {
            HashMap<String, Long> totals;
            ScanType type;
            block14: {
                super(client, width, height, top, bottom, left, 12, screenWidth, screenHeight);
                this.DATA = new TreeMap();
                this.COLUMN_WIDTH_NANOS = 0;
                this.COLUMN_WIDTH_PERCENTAGES = 0;
                this.FONTRENDERER = client.field_71466_p;
                this.result = result;
                type = result.getType();
                totals = new HashMap<String, Long>();
                block8: for (GuiScanResultsWorld.LagSource lagSource : result.getLagSources()) {
                    String className;
                    block13: {
                        block12: {
                            if (type != ScanType.WORLD) break block12;
                            switch (lagSource.data.type) {
                                case ENTITY: {
                                    className = (String)lagSource.data.getValue(ObjectData.Entry.ENTITY_CLASS_NAME);
                                    break block13;
                                }
                                case BLOCK: 
                                case TILE_ENTITY: {
                                    className = (String)lagSource.data.getValue(ObjectData.Entry.BLOCK_CLASS_NAME);
                                    break block13;
                                }
                            }
                            continue;
                        }
                        if (type != ScanType.FPS) continue;
                        switch (lagSource.data.type) {
                            case GUI_ENTITY: {
                                className = (String)lagSource.data.getValue(ObjectData.Entry.ENTITY_CLASS_NAME);
                                break;
                            }
                            case GUI_BLOCK: {
                                className = (String)lagSource.data.getValue(ObjectData.Entry.BLOCK_CLASS_NAME);
                                break;
                            }
                            default: {
                                continue block8;
                            }
                        }
                    }
                    if (!totals.containsKey(className)) {
                        totals.put(className, lagSource.nanos);
                        continue;
                    }
                    totals.put(className, lagSource.nanos + (Long)totals.get(className));
                }
                if (type != ScanType.WORLD) break block14;
                for (Map.Entry entry : totals.entrySet()) {
                    this.DATA.put((Long)entry.getValue(), (String)entry.getKey());
                    this.COLUMN_WIDTH_NANOS = Math.max(this.COLUMN_WIDTH_NANOS, this.FONTRENDERER.func_78256_a(Calculations.muPerTickString((Long)entry.getValue(), result)));
                    this.COLUMN_WIDTH_PERCENTAGES = Math.max(this.COLUMN_WIDTH_PERCENTAGES, this.FONTRENDERER.func_78256_a(Calculations.tickPercent((Long)entry.getValue(), result)));
                }
                break block15;
            }
            if (type != ScanType.FPS) break block15;
            for (Map.Entry entry : totals.entrySet()) {
                this.DATA.put((Long)entry.getValue(), (String)entry.getKey());
                this.COLUMN_WIDTH_NANOS = Math.max(this.COLUMN_WIDTH_NANOS, this.FONTRENDERER.func_78256_a(Calculations.NFStringSimple((Long)entry.getValue(), result.getTotalFrames())));
                this.COLUMN_WIDTH_PERCENTAGES = Math.max(this.COLUMN_WIDTH_PERCENTAGES, this.FONTRENDERER.func_78256_a(Calculations.nfPercent((Long)entry.getValue(), result)));
            }
        }
    }

    protected int getSize() {
        return this.DATA.size();
    }

    protected void elementClicked(int slot, boolean doubleClick) {
    }

    public void drawScreen(int mouseX, int mouseY, float partialTicks) {
        super.drawScreen(mouseX, mouseY, partialTicks);
    }

    protected boolean isSelected(int index) {
        return false;
    }

    protected void drawBackground() {
    }

    public void handleMouseInput() throws IOException {
        super.handleMouseInput(this.left, this.top);
    }

    protected void drawSlot(int slot, int entryRight, int slotTop, int slotBuffer, Tessellator tess) {
        int offSet;
        if (slot == -1) {
            return;
        }
        Long nanos = this.DATA.descendingKeySet().toArray(new Long[0])[slot];
        String name = this.DATA.get(nanos);
        double heat = this.result.getType() == ScanType.WORLD ? Calculations.heat(nanos, this.result) : Calculations.heatNF(nanos, this.result);
        double[] RGB = Graphical.heatToColor(heat);
        int color = Graphical.RGBtoInt(RGB);
        if (this.result.getType() == ScanType.WORLD) {
            this.drawStringToLeftOf(Calculations.muPerTickString(nanos, this.result), this.left + this.COLUMN_WIDTH_NANOS + 5, slotTop, color);
            this.drawString(Calculations.tickPercent(nanos, this.result), this.left + this.COLUMN_WIDTH_NANOS + 10, slotTop, color);
            offSet = this.FONTRENDERER.func_78256_a(Calculations.tickPercent(nanos, this.result));
        } else {
            this.drawStringToLeftOf(Calculations.NFStringSimple(nanos, this.result.getTotalFrames()), this.left + this.COLUMN_WIDTH_NANOS + 5, slotTop, color);
            this.drawString(Calculations.nfPercent(nanos, this.result), this.left + this.COLUMN_WIDTH_NANOS + 10, slotTop, color);
            offSet = this.FONTRENDERER.func_78256_a(Calculations.nfPercent(nanos, this.result));
        }
        this.drawString(name, this.left + this.COLUMN_WIDTH_NANOS + 15 + offSet, slotTop, 0x4C4C4C);
    }

    private void drawString(String text, int x, int y, int color) {
        this.FONTRENDERER.func_175063_a(text, (float)x, (float)y, color);
    }

    private void drawStringToLeftOf(String text, int right, int y, int color) {
        this.FONTRENDERER.func_175063_a(text, (float)(right - this.FONTRENDERER.func_78256_a(text)), (float)y, color);
    }
}

