/*
 * Decompiled with CFR 0.152.
 */
package cf.terminator.laggoggles.mixin;

import cf.terminator.laggoggles.profiler.ProfileManager;
import java.util.Iterator;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={World.class}, priority=1001)
public abstract class MixinWorld {
    private Long LAGGOGGLES_START = null;

    @Inject(method={"updateEntities()V"}, at={@At(value="INVOKE", target="net/minecraft/util/ITickable.update()V", shift=At.Shift.BEFORE)}, locals=LocalCapture.CAPTURE_FAILHARD)
    public void beforeTick(CallbackInfo ci, Iterator iterator, TileEntity tileentity, BlockPos blockpos) {
        this.LAGGOGGLES_START = System.nanoTime();
    }

    @Inject(method={"updateEntities()V"}, at={@At(value="INVOKE", target="net/minecraft/util/ITickable.update()V", shift=At.Shift.AFTER)}, locals=LocalCapture.CAPTURE_FAILHARD)
    public void afterTick(CallbackInfo ci, Iterator iterator, TileEntity tileentity, BlockPos pos) {
        if (ProfileManager.PROFILE_ENABLED.get() && this.LAGGOGGLES_START != null) {
            ProfileManager.timingManager.addBlockTime(tileentity.func_145831_w().field_73011_w.getDimension(), pos, System.nanoTime() - this.LAGGOGGLES_START);
        }
    }
}

