/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.network.packets.chunkRequest;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pregenerator.base.api.network.IReadableBuffer;
import pregenerator.base.api.network.IWriteableBuffer;
import pregenerator.base.api.network.PregenPacket;
import pregenerator.impl.client.gui.GuiWorldView;
import pregenerator.impl.tracking.ChunkEntry;

public class EntityAnswerPacket
extends PregenPacket {
    int dataType;
    boolean target;
    Map<String, Integer> counts = new HashMap<String, Integer>();

    public EntityAnswerPacket() {
    }

    public EntityAnswerPacket(boolean target) {
        this.target = target;
    }

    public void addEntry(String s, int type) {
        this.counts.put(s, type);
    }

    public void setType(int type) {
        this.dataType = type;
    }

    public boolean hasData() {
        return this.counts.size() > 0;
    }

    @Override
    public void read(IReadableBuffer buffer) {
        this.target = buffer.readBoolean();
        this.dataType = buffer.readInt();
        if (this.dataType == -1) {
            return;
        }
        int expected = buffer.readInt();
        for (int i = 0; i < expected; ++i) {
            String s = ChunkEntry.readString(buffer);
            int data = buffer.readInt();
            this.counts.put(s, data);
        }
    }

    @Override
    public void write(IWriteableBuffer buffer) {
        buffer.writeBoolean(this.target);
        buffer.writeInt(this.dataType);
        if (this.dataType == -1) {
            return;
        }
        buffer.writeInt(this.counts.size());
        for (Map.Entry<String, Integer> entry : this.counts.entrySet()) {
            ChunkEntry.writeString(entry.getKey(), buffer);
            buffer.writeInt(entry.getValue());
        }
    }

    @Override
    public void handle(EntityPlayer player) {
        this.onClient();
    }

    @SideOnly(value=Side.CLIENT)
    public void onClient() {
        GuiWorldView view;
        GuiWorldView guiWorldView = view = this.target ? GuiWorldView.TILE_ENTITIES : GuiWorldView.ENTITIES;
        if (this.dataType == -1) {
            view.noDataFound();
        } else {
            view.addStuff(this.counts, this.dataType);
        }
    }
}

