/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.client;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import net.minecraftforge.fml.client.IModGuiFactory;
import net.minecraftforge.fml.client.config.ConfigGuiType;
import net.minecraftforge.fml.client.config.DummyConfigElement;
import net.minecraftforge.fml.client.config.GuiConfig;
import net.minecraftforge.fml.client.config.GuiConfigEntries;
import net.minecraftforge.fml.client.config.GuiEditArray;
import net.minecraftforge.fml.client.config.GuiEditArrayEntries;
import net.minecraftforge.fml.client.config.IConfigElement;

public class FMLConfigGuiFactory
implements IModGuiFactory {
    private static final Set<IModGuiFactory.RuntimeOptionCategoryElement> fmlCategories = ImmutableSet.of((Object)new IModGuiFactory.RuntimeOptionCategoryElement("HELP", "FML"));

    @Override
    public boolean hasConfigGui() {
        return true;
    }

    @Override
    public void initialize(bib minecraftInstance) {
    }

    @Override
    public blk createConfigGui(blk parentScreen) {
        return new FMLConfigGuiScreen(parentScreen);
    }

    @Override
    public Set<IModGuiFactory.RuntimeOptionCategoryElement> runtimeGuiCategories() {
        return fmlCategories;
    }

    public static class CustomArrayEntry
    extends GuiEditArrayEntries.StringEntry {
        public CustomArrayEntry(GuiEditArray owningScreen, GuiEditArrayEntries owningEntryList, IConfigElement configElement, Object value) {
            super(owningScreen, owningEntryList, configElement, value);
        }

        @Override
        public void a(int slotIndex, int x, int y, int listWidth, int slotHeight, int mouseX, int mouseY, boolean isSelected, float partial) {
            this.textFieldValue.g((int)(Math.random() * 1.6777215E7));
            super.a(slotIndex, x, y, listWidth, slotHeight, mouseX, mouseY, isSelected, partial);
        }
    }

    public static class FMLConfigGuiScreen
    extends GuiConfig {
        public FMLConfigGuiScreen(blk parent) {
            super(parent, FMLConfigGuiScreen.getConfigElements(), "FML", false, false, cey.a((String)"fml.config.sample.title", (Object[])new Object[0]));
        }

        private static List<IConfigElement> getConfigElements() {
            ArrayList<IConfigElement> list = new ArrayList<IConfigElement>();
            ArrayList<IConfigElement> listsList = new ArrayList<IConfigElement>();
            ArrayList<IConfigElement> stringsList = new ArrayList<IConfigElement>();
            ArrayList<IConfigElement> numbersList = new ArrayList<IConfigElement>();
            Pattern commaDelimitedPattern = Pattern.compile("([A-Za-z]+((,){1}( )*|$))+?");
            list.add(new DummyConfigElement("imABoolean", true, ConfigGuiType.BOOLEAN, "fml.config.sample.imABoolean").setRequiresMcRestart(true));
            list.add(new DummyConfigElement("imAnInteger", (Object)42, ConfigGuiType.INTEGER, "fml.config.sample.imAnInteger", -1, 256).setRequiresMcRestart(true));
            list.add(new DummyConfigElement("imADouble", (Object)42.4242, ConfigGuiType.DOUBLE, "fml.config.sample.imADouble", -1.0, 256.256).setRequiresMcRestart(true));
            list.add(new DummyConfigElement("imAString", "http://www.montypython.net/scripts/string.php", ConfigGuiType.STRING, "fml.config.sample.imAString").setRequiresMcRestart(true));
            listsList.add(new DummyConfigElement.DummyListElement("booleanList", new Boolean[]{true, false, true, false, true, false, true, false}, ConfigGuiType.BOOLEAN, "fml.config.sample.booleanList"));
            listsList.add(new DummyConfigElement.DummyListElement("booleanListFixed", (Object[])new Boolean[]{true, false, true, false, true, false, true, false}, ConfigGuiType.BOOLEAN, "fml.config.sample.booleanListFixed", true));
            listsList.add(new DummyConfigElement.DummyListElement("booleanListMax", (Object[])new Boolean[]{true, false, true, false, true, false, true, false}, ConfigGuiType.BOOLEAN, "fml.config.sample.booleanListMax", 10));
            listsList.add(new DummyConfigElement.DummyListElement("doubleList", new Double[]{0.0, 1.1, 2.2, 3.3, 4.4, 5.5, 6.6, 7.7, 8.8, 9.9}, ConfigGuiType.DOUBLE, "fml.config.sample.doubleList"));
            listsList.add(new DummyConfigElement.DummyListElement("doubleListFixed", (Object[])new Double[]{0.0, 1.1, 2.2, 3.3, 4.4, 5.5, 6.6, 7.7, 8.8, 9.9}, ConfigGuiType.DOUBLE, "fml.config.sample.doubleListFixed", true));
            listsList.add(new DummyConfigElement.DummyListElement("doubleListMax", (Object[])new Double[]{0.0, 1.1, 2.2, 3.3, 4.4, 5.5, 6.6, 7.7, 8.8, 9.9}, ConfigGuiType.DOUBLE, "fml.config.sample.doubleListMax", 15));
            listsList.add(new DummyConfigElement.DummyListElement("doubleListBounded", (Object[])new Double[]{0.0, 1.1, 2.2, 3.3, 4.4, 5.5, 6.6, 7.7, 8.8, 9.9}, ConfigGuiType.DOUBLE, "fml.config.sample.doubleListBounded", (Object)-1.0, (Object)10.0));
            listsList.add(new DummyConfigElement.DummyListElement("integerList", new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9}, ConfigGuiType.INTEGER, "fml.config.sample.integerList"));
            listsList.add(new DummyConfigElement.DummyListElement("integerListFixed", (Object[])new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9}, ConfigGuiType.INTEGER, "fml.config.sample.integerListFixed", true));
            listsList.add(new DummyConfigElement.DummyListElement("integerListMax", (Object[])new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9}, ConfigGuiType.INTEGER, "fml.config.sample.integerListMax", 15));
            listsList.add(new DummyConfigElement.DummyListElement("integerListBounded", (Object[])new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9}, ConfigGuiType.INTEGER, "fml.config.sample.integerListBounded", (Object)-1, (Object)10));
            listsList.add(new DummyConfigElement.DummyListElement("stringList", new String[]{"An", "array", "of", "string", "values"}, ConfigGuiType.STRING, "fml.config.sample.stringList"));
            listsList.add(new DummyConfigElement.DummyListElement("stringListFixed", (Object[])new String[]{"A", "fixed", "length", "array", "of", "string", "values"}, ConfigGuiType.STRING, "fml.config.sample.stringListFixed", true));
            listsList.add(new DummyConfigElement.DummyListElement("stringListMax", (Object[])new String[]{"An", "array", "of", "string", "values", "with", "a", "max", "length", "of", "15"}, ConfigGuiType.STRING, "fml.config.sample.stringListMax", 15));
            listsList.add(new DummyConfigElement.DummyListElement("stringListPattern", (Object[])new String[]{"Valid", "Not Valid", "Is, Valid", "Comma, Separated, Value"}, ConfigGuiType.STRING, "fml.config.sample.stringListPattern", commaDelimitedPattern));
            listsList.add(new DummyConfigElement.DummyListElement("stringListCustom", new Object[0], ConfigGuiType.STRING, "fml.config.sample.stringListCustom").setArrayEntryClass(CustomArrayEntry.class));
            list.add(new DummyConfigElement.DummyCategoryElement("lists", "fml.config.sample.ctgy.lists", listsList));
            stringsList.add(new DummyConfigElement("basicString", "Just a regular String value, anything goes.", ConfigGuiType.STRING, "fml.config.sample.basicString"));
            stringsList.add(new DummyConfigElement("cycleString", (Object)"this", ConfigGuiType.STRING, "fml.config.sample.cycleString", new String[]{"this", "property", "cycles", "through", "a", "list", "of", "valid", "choices"}));
            stringsList.add(new DummyConfigElement("patternString", (Object)"only, comma, separated, words, can, be, entered, in, this, box", ConfigGuiType.STRING, "fml.config.sample.patternString", commaDelimitedPattern));
            stringsList.add(new DummyConfigElement("chatColorPicker", (Object)"c", ConfigGuiType.COLOR, "fml.config.sample.chatColorPicker", new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"}));
            stringsList.add(new DummyConfigElement("modIDSelector", "FML", ConfigGuiType.MOD_ID, "fml.config.sample.modIDSelector"));
            list.add(new DummyConfigElement.DummyCategoryElement("strings", "fml.config.sample.ctgy.strings", stringsList));
            numbersList.add(new DummyConfigElement("basicInteger", 42, ConfigGuiType.INTEGER, "fml.config.sample.basicInteger"));
            numbersList.add(new DummyConfigElement("boundedInteger", (Object)42, ConfigGuiType.INTEGER, "fml.config.sample.boundedInteger", -1, 256));
            numbersList.add(new DummyConfigElement("sliderInteger", (Object)2000, ConfigGuiType.INTEGER, "fml.config.sample.sliderInteger", 100, 10000).setCustomListEntryClass(GuiConfigEntries.NumberSliderEntry.class));
            numbersList.add(new DummyConfigElement("basicDouble", 42.4242, ConfigGuiType.DOUBLE, "fml.config.sample.basicDouble"));
            numbersList.add(new DummyConfigElement("boundedDouble", (Object)42.4242, ConfigGuiType.DOUBLE, "fml.config.sample.boundedDouble", -1.0, 256.256));
            numbersList.add(new DummyConfigElement("sliderDouble", (Object)42.4242, ConfigGuiType.DOUBLE, "fml.config.sample.sliderDouble", -1.0, 256.256).setCustomListEntryClass(GuiConfigEntries.NumberSliderEntry.class));
            list.add(new DummyConfigElement.DummyCategoryElement("numbers", "fml.config.sample.ctgy.numbers", numbersList));
            return list;
        }
    }
}

