/*
 * Decompiled with CFR 0.152.
 */
package tinker_io.fluids;

import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import tinker_io.helper.CrushedOreColorHelper;

public class FluidPureMetal
extends Fluid {
    private static String tinkersDomain = "tconstruct:";

    public FluidPureMetal(String fluidName) {
        super(fluidName, new ResourceLocation(tinkersDomain + "blocks/fluids/molten_metal"), new ResourceLocation(tinkersDomain + "blocks/fluids/molten_metal_flow"));
        this.setLuminosity(10).setDensity(1600).setViscosity(1500).setTemperature(600);
    }

    public int getColor(FluidStack stack) {
        return CrushedOreColorHelper.getColor(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public String getLocalizedName(FluidStack stack) {
        String oreDicName;
        NonNullList oreList;
        String s = this.getUnlocalizedName();
        String name = s == null ? "" : I18n.func_135052_a((String)s, (Object[])new Object[0]);
        NBTTagCompound nbt = stack.tag;
        if (nbt != null && !(oreList = OreDictionary.getOres((String)(oreDicName = nbt.func_74779_i("oreDict")))).isEmpty()) {
            ItemStack oreItem = (ItemStack)oreList.get(0);
            String oreName = oreItem.func_82833_r();
            name = name + " (" + oreName + ")";
        }
        return name;
    }
}

