/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.events;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.Cancelable;
import net.minecraftforge.fml.common.eventhandler.Event;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.events.TinkerEvent;
import slimeknights.tconstruct.library.modifiers.IModifier;
import slimeknights.tconstruct.library.modifiers.TinkerGuiException;
import slimeknights.tconstruct.library.utils.TinkerUtil;

@Cancelable
public class TinkerCraftingEvent
extends TinkerEvent {
    private final ItemStack itemStack;
    private final EntityPlayer player;
    private String message;

    protected TinkerCraftingEvent(ItemStack itemStack, EntityPlayer player, String message) {
        this.itemStack = itemStack;
        this.player = player;
        this.message = message = message + "\n" + TextFormatting.ITALIC + "by " + Loader.instance().activeModContainer().getName();
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public String getMessage() {
        return this.message;
    }

    public EntityPlayer getPlayer() {
        return this.player;
    }

    public void setCanceled(String localizedMessage) {
        this.message = localizedMessage;
        this.setCanceled(true);
    }

    public static class ToolPartCraftingEvent
    extends TinkerCraftingEvent {
        private ToolPartCraftingEvent(ItemStack itemStack, EntityPlayer player) {
            super(itemStack, player, Util.translate("gui.error.craftevent.toolpart.default", new Object[0]));
        }

        public static void fireEvent(ItemStack itemStack, EntityPlayer player) throws TinkerGuiException {
            ToolPartCraftingEvent toolPartCraftingEvent = new ToolPartCraftingEvent(itemStack, player);
            if (MinecraftForge.EVENT_BUS.post((Event)toolPartCraftingEvent)) {
                throw new TinkerGuiException(toolPartCraftingEvent.getMessage());
            }
        }
    }

    public static class ToolModifyEvent
    extends TinkerCraftingEvent {
        private final List<IModifier> modifiers;
        private final ItemStack toolBeforeModification;

        protected ToolModifyEvent(ItemStack itemStack, EntityPlayer player, ItemStack toolBeforeModification) {
            super(itemStack, player, Util.translate("gui.error.craftevent.modifier.default", new Object[0]));
            this.toolBeforeModification = toolBeforeModification;
            NonNullList<IModifier> modifiers = TinkerUtil.getModifiers(itemStack);
            modifiers.removeAll((Collection<?>)TinkerUtil.getModifiers(toolBeforeModification));
            this.modifiers = ImmutableList.copyOf(modifiers);
        }

        public List<IModifier> getModifiers() {
            return this.modifiers;
        }

        public ItemStack getToolBeforeModification() {
            return this.toolBeforeModification;
        }

        public static void fireEvent(ItemStack itemStack, EntityPlayer player, ItemStack toolBeforeModification) throws TinkerGuiException {
            ToolModifyEvent toolModifyEvent = new ToolModifyEvent(itemStack, player, toolBeforeModification);
            if (MinecraftForge.EVENT_BUS.post((Event)toolModifyEvent)) {
                throw new TinkerGuiException(toolModifyEvent.getMessage());
            }
        }
    }

    public static class ToolPartReplaceEvent
    extends TinkerCraftingEvent {
        private final NonNullList<ItemStack> toolParts;

        private ToolPartReplaceEvent(ItemStack itemStack, EntityPlayer player, NonNullList<ItemStack> toolParts) {
            super(itemStack, player, Util.translate("gui.error.craftevent.replace.default", new Object[0]));
            this.toolParts = toolParts;
        }

        public NonNullList<ItemStack> getToolParts() {
            return this.toolParts;
        }

        public static void fireEvent(ItemStack itemStack, EntityPlayer player, NonNullList<ItemStack> toolParts) throws TinkerGuiException {
            ToolPartReplaceEvent toolPartReplaceEvent = new ToolPartReplaceEvent(itemStack, player, toolParts);
            if (MinecraftForge.EVENT_BUS.post((Event)toolPartReplaceEvent)) {
                throw new TinkerGuiException(toolPartReplaceEvent.getMessage());
            }
        }
    }

    public static class ToolCraftingEvent
    extends TinkerCraftingEvent {
        private final NonNullList<ItemStack> toolParts;

        private ToolCraftingEvent(ItemStack itemStack, EntityPlayer player, NonNullList<ItemStack> toolParts) {
            super(itemStack, player, Util.translate("gui.error.craftevent.tool.default", new Object[0]));
            this.toolParts = toolParts;
        }

        public NonNullList<ItemStack> getToolParts() {
            return this.toolParts;
        }

        public static void fireEvent(ItemStack itemStack, EntityPlayer player, NonNullList<ItemStack> toolParts) throws TinkerGuiException {
            ToolCraftingEvent toolCraftingEvent = new ToolCraftingEvent(itemStack, player, toolParts);
            if (MinecraftForge.EVENT_BUS.post((Event)toolCraftingEvent)) {
                throw new TinkerGuiException(toolCraftingEvent.getMessage());
            }
        }
    }
}

