/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.smeltery;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.ListIterator;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.StringUtils;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import slimeknights.tconstruct.library.smeltery.ISmelteryTankHandler;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public class SmelteryTank
implements IFluidTank,
IFluidHandler {
    protected final ISmelteryTankHandler parent;
    protected List<FluidStack> liquids = Lists.newArrayList();
    protected int maxCapacity = 0;

    public SmelteryTank(ISmelteryTankHandler parent) {
        this.parent = parent;
    }

    public void setCapacity(int maxCapacity) {
        this.maxCapacity = maxCapacity;
    }

    public List<FluidStack> getFluids() {
        return this.liquids;
    }

    public void setFluids(List<FluidStack> fluids) {
        this.liquids = fluids;
        this.parent.onTankChanged(this.liquids, null);
    }

    @Nullable
    public FluidStack getFluid() {
        return this.liquids.size() > 0 ? this.liquids.get(0) : null;
    }

    public int getFluidAmount() {
        int cap = 0;
        for (FluidStack liquid : this.liquids) {
            cap += liquid.amount;
        }
        return cap;
    }

    public int getCapacity() {
        return this.maxCapacity;
    }

    public FluidTankInfo getInfo() {
        FluidStack fluid = this.getFluid();
        int capacity = this.getCapacity() - this.getFluidAmount();
        if (fluid != null) {
            capacity += fluid.amount;
        }
        return new FluidTankInfo(fluid, capacity);
    }

    public IFluidTankProperties[] getTankProperties() {
        if (this.liquids.size() == 0) {
            return new IFluidTankProperties[]{new FluidTankProperties(null, this.maxCapacity, true, true)};
        }
        IFluidTankProperties[] properties = new IFluidTankProperties[this.liquids.size()];
        for (int i = 0; i < this.liquids.size(); ++i) {
            boolean first = i == 0;
            int capacity = this.liquids.get((int)i).amount;
            if (first) {
                capacity += this.getCapacity() - this.getFluidAmount();
            }
            properties[i] = new FluidTankProperties(this.liquids.get(i), capacity, first, first);
        }
        return properties;
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (StringUtils.func_151246_b((String)FluidRegistry.getFluidName((Fluid)resource.getFluid()))) {
            return 0;
        }
        int used = this.getFluidAmount();
        int usable = Math.min(this.maxCapacity - used, resource.amount);
        if (usable <= 0) {
            return 0;
        }
        if (!doFill) {
            return usable;
        }
        for (FluidStack liquid : this.liquids) {
            if (!liquid.isFluidEqual(resource)) continue;
            liquid.amount += usable;
            this.parent.onTankChanged(this.liquids, liquid);
            return usable;
        }
        resource = resource.copy();
        resource.amount = usable;
        this.liquids.add(resource);
        this.parent.onTankChanged(this.liquids, resource);
        return usable;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (this.liquids.isEmpty()) {
            return null;
        }
        FluidStack liquid = new FluidStack(this.liquids.get(0), maxDrain);
        return this.drain(liquid, doDrain);
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        ListIterator<FluidStack> iter = this.liquids.listIterator();
        while (iter.hasNext()) {
            FluidStack liquid = iter.next();
            if (!liquid.isFluidEqual(resource)) continue;
            int drainable = Math.min(resource.amount, liquid.amount);
            if (doDrain) {
                liquid.amount -= drainable;
                if (liquid.amount <= 0) {
                    iter.remove();
                }
                this.parent.onTankChanged(this.liquids, liquid);
            }
            resource = resource.copy();
            resource.amount = drainable;
            return resource;
        }
        return null;
    }

    public void writeToNBT(NBTTagCompound tag) {
        NBTTagList taglist = new NBTTagList();
        for (FluidStack liquid : this.liquids) {
            if (FluidRegistry.getFluidName((Fluid)liquid.getFluid()) == null) {
                TinkerSmeltery.log.error("Error trying to save fluids inside smeltery! Invalid Liquid found! Smeltery contents:");
                for (FluidStack liquid2 : this.liquids) {
                    TinkerSmeltery.log.error("  " + liquid2.getUnlocalizedName() + "/" + liquid2.amount + "mb");
                }
                continue;
            }
            NBTTagCompound fluidTag = new NBTTagCompound();
            liquid.writeToNBT(fluidTag);
            taglist.func_74742_a((NBTBase)fluidTag);
        }
        tag.func_74782_a("Liquids", (NBTBase)taglist);
        tag.func_74768_a("LiquidCapacity", this.maxCapacity);
    }

    public void readFromNBT(NBTTagCompound tag) {
        NBTTagList taglist = tag.func_150295_c("Liquids", 10);
        this.liquids.clear();
        for (int i = 0; i < taglist.func_74745_c(); ++i) {
            NBTTagCompound fluidTag = taglist.func_150305_b(i);
            FluidStack liquid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)fluidTag);
            if (liquid == null) continue;
            this.liquids.add(liquid);
        }
        this.maxCapacity = tag.func_74762_e("LiquidCapacity");
    }

    public void moveFluidToBottom(int index) {
        if (index < this.liquids.size()) {
            FluidStack fluid = this.liquids.get(index);
            this.liquids.remove(index);
            this.liquids.add(0, fluid);
        }
    }
}

