/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.alchemyArray;

import WayofTime.bloodmagic.alchemyArray.AlchemyArrayEffect;
import WayofTime.bloodmagic.fakePlayer.FakePlayerBM;
import WayofTime.bloodmagic.tile.TileAlchemyArray;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySilverfish;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.NodeProcessor;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathFinder;
import net.minecraft.pathfinding.WalkNodeProcessor;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;

public class AlchemyArrayEffectAttractor
extends AlchemyArrayEffect {
    private FakePlayer target;
    private Set<EntityLiving> tracking = new HashSet<EntityLiving>();
    private int counter = 0;
    private int maxMobsAttracted = 10000;
    private int cooldown = 50;

    public AlchemyArrayEffectAttractor(String key) {
        super(key);
    }

    @Override
    public boolean update(TileEntity tile, int ticksActive) {
        if (tile.func_145831_w().field_72995_K) {
            return false;
        }
        BlockPos pos = tile.func_174877_v();
        ++this.counter;
        if (this.counter < 10) {
            for (EntityLiving ent : this.tracking) {
                this.onEntityTick(pos, ent);
            }
            return false;
        }
        this.counter = 0;
        World world = tile.func_145831_w();
        HashSet<EntityLiving> trackingThisTick = new HashSet<EntityLiving>();
        List entsInBounds = world.func_72872_a(EntityLiving.class, this.getBounds(pos));
        for (EntityLiving ent : entsInBounds) {
            double z;
            double y;
            if (ent.field_70128_L) continue;
            double x = (double)pos.func_177958_n() + 0.5 - ent.field_70165_t;
            double distance = Math.sqrt(x * x + (y = (double)pos.func_177956_o() + 1.0 - ent.field_70163_u) * y + (z = (double)pos.func_177952_p() + 0.5 - ent.field_70161_v) * z);
            if (distance < 2.0 && this.tracking.contains(ent)) {
                this.setEntityCooldown(pos, ent, this.cooldown);
                this.removeAssignedAITask(pos, ent);
                continue;
            }
            if (!this.canEntityBeTracked(pos, ent)) {
                this.decrementEntityCooldown(pos, ent);
                continue;
            }
            if (this.tracking.contains(ent)) {
                trackingThisTick.add(ent);
                this.onEntityTick(pos, ent);
                continue;
            }
            if (this.tracking.size() >= this.maxMobsAttracted || !this.trackMob(pos, ent)) continue;
            trackingThisTick.add(ent);
            this.onTracked(ent);
        }
        for (EntityLiving e : this.tracking) {
            if (trackingThisTick.contains(e)) continue;
            this.onUntracked(e);
        }
        this.tracking.clear();
        this.tracking = trackingThisTick;
        return false;
    }

    public boolean canEntityBeTracked(BlockPos pos, EntityLiving entity) {
        return this.getEntityCooldown(pos, entity) <= 0;
    }

    private String getPosKey(BlockPos pos) {
        return "BMAttractor:" + pos;
    }

    public int getEntityCooldown(BlockPos pos, EntityLiving entity) {
        return entity.getEntityData().func_74762_e(this.getPosKey(pos));
    }

    public void setEntityCooldown(BlockPos pos, EntityLiving entity, int cooldown) {
        entity.getEntityData().func_74768_a(this.getPosKey(pos), cooldown);
    }

    public void decrementEntityCooldown(BlockPos pos, EntityLiving entity) {
        int cooldown = this.getEntityCooldown(pos, entity);
        if (cooldown > 0) {
            this.setEntityCooldown(pos, entity, cooldown - 1);
        }
    }

    public AxisAlignedBB getBounds(BlockPos pos) {
        return new AxisAlignedBB(pos).func_72321_a((double)this.getRange(), (double)this.getRange(), (double)this.getRange());
    }

    public float getRange() {
        return 10.0f;
    }

    private void onUntracked(EntityLiving e) {
        if (e instanceof EntityEnderman) {
            e.getEntityData().func_74757_a("BM:tracked", false);
        }
    }

    private void onTracked(EntityLiving e) {
        if (e instanceof EntityEnderman) {
            e.getEntityData().func_74757_a("BM:tracked", true);
        }
    }

    private void onEntityTick(BlockPos pos, EntityLiving ent) {
        if (ent instanceof EntitySlime) {
            ent.func_70625_a((Entity)this.getTarget(ent.func_130014_f_(), pos), 10.0f, 20.0f);
        } else if (ent instanceof EntitySilverfish) {
            if (this.counter < 10) {
                return;
            }
            EntitySilverfish sf = (EntitySilverfish)ent;
            Path pathentity = this.getPathEntityToEntity((Entity)ent, (Entity)this.getTarget(ent.func_130014_f_(), pos), this.getRange());
            sf.func_70661_as().func_75484_a(pathentity, (double)sf.func_70689_ay());
        } else if (ent instanceof EntityBlaze) {
            double z;
            double y;
            double x = (double)pos.func_177958_n() + 0.5 - ent.field_70165_t;
            double distance = Math.sqrt(x * x + (y = (double)pos.func_177956_o() + 1.0 - ent.field_70163_u) * y + (z = (double)pos.func_177952_p() + 0.5 - ent.field_70161_v) * z);
            if (distance > 1.25) {
                double speed = 0.01;
                ent.field_70159_w += x / distance * speed;
                if (y > 0.0) {
                    ent.field_70181_x += (0.3 - ent.field_70181_x) * 0.3;
                }
                ent.field_70179_y += z / distance * speed;
            }
        } else if (ent instanceof EntityPigZombie || ent instanceof EntitySpider) {
            this.forceMove(pos, ent);
        } else if (ent instanceof EntityEnderman) {
            ent.func_70624_b((EntityLivingBase)this.getTarget(ent.func_130014_f_(), pos));
        }
    }

    private void forceMove(BlockPos pos, EntityLiving ent) {
        double z;
        double y;
        double x = (double)pos.func_177958_n() + 0.5 - ent.field_70165_t;
        double distance = Math.sqrt(x * x + (y = (double)pos.func_177956_o() + 1.0 - ent.field_70163_u) * y + (z = (double)pos.func_177952_p() + 0.5 - ent.field_70161_v) * z);
        if (distance > 2.0) {
            EntityMob mod = (EntityMob)ent;
            mod.func_70625_a((Entity)this.getTarget(ent.func_130014_f_(), pos), 180.0f, 0.0f);
            mod.func_70605_aq().func_188488_a(0.0f, 0.3f);
            if (mod.field_70163_u < (double)pos.func_177956_o()) {
                mod.func_70637_d(true);
            } else {
                mod.func_70637_d(false);
            }
        }
    }

    public Path getPathEntityToEntity(Entity entity, Entity targetEntity, float range) {
        int targX = MathHelper.func_76128_c((double)targetEntity.field_70165_t);
        int targY = MathHelper.func_76128_c((double)(targetEntity.field_70163_u + 1.0));
        int targZ = MathHelper.func_76128_c((double)targetEntity.field_70161_v);
        PathFinder pf = new PathFinder((NodeProcessor)new WalkNodeProcessor());
        return pf.func_186336_a((IBlockAccess)targetEntity.func_130014_f_(), (EntityLiving)entity, new BlockPos(targX, targY, targZ), range);
    }

    private boolean trackMob(BlockPos pos, EntityLiving ent) {
        if (this.useSetTarget(ent)) {
            ent.func_70624_b((EntityLivingBase)this.getTarget(ent.func_130014_f_(), pos));
            return true;
        }
        if (this.useSpecialCase(ent)) {
            return this.applySpecialCase(pos, ent);
        }
        return this.attractUsingAITask(pos, ent);
    }

    private boolean useSetTarget(EntityLiving ent) {
        return ent instanceof EntityPigZombie || ent instanceof EntitySpider || ent instanceof EntitySilverfish;
    }

    public void removeAssignedAITask(BlockPos pos, EntityLiving ent) {
        Set entries = ent.field_70714_bg.field_75782_a;
        EntityAIBase remove = null;
        for (EntityAITasks.EntityAITaskEntry entry : entries) {
            AttractTask at;
            if (!(entry.field_75733_a instanceof AttractTask) || !(at = (AttractTask)entry.field_75733_a).coord.equals((Object)pos)) continue;
            remove = entry.field_75733_a;
        }
        if (remove != null) {
            ent.field_70714_bg.func_85156_a(remove);
        }
    }

    private boolean attractUsingAITask(BlockPos pos, EntityLiving ent) {
        this.tracking.add(ent);
        Set entries = ent.field_70714_bg.field_75782_a;
        EntityAIBase remove = null;
        for (EntityAITasks.EntityAITaskEntry entry : entries) {
            if (!(entry.field_75733_a instanceof AttractTask)) continue;
            AttractTask at = (AttractTask)entry.field_75733_a;
            if (at.coord.equals((Object)pos) || !at.func_75250_a()) {
                remove = entry.field_75733_a;
                continue;
            }
            return false;
        }
        if (remove != null) {
            ent.field_70714_bg.func_85156_a(remove);
        }
        this.cancelCurrentTasks(ent);
        ent.field_70714_bg.func_75776_a(0, (EntityAIBase)new AttractTask(ent, this.getTarget(ent.func_130014_f_(), pos), pos));
        return true;
    }

    private void cancelCurrentTasks(EntityLiving ent) {
        Iterator iterator = ent.field_70714_bg.field_75782_a.iterator();
        ArrayList<EntityAITasks.EntityAITaskEntry> currentTasks = new ArrayList<EntityAITasks.EntityAITaskEntry>();
        while (iterator.hasNext()) {
            EntityAITasks.EntityAITaskEntry entityaitaskentry = (EntityAITasks.EntityAITaskEntry)iterator.next();
            if (entityaitaskentry == null || entityaitaskentry.field_75733_a instanceof AttractTask) continue;
            currentTasks.add(entityaitaskentry);
        }
        for (EntityAITasks.EntityAITaskEntry task : currentTasks) {
            ent.field_70714_bg.func_85156_a(task.field_75733_a);
            ent.field_70714_bg.func_75776_a(task.field_75731_b, task.field_75733_a);
        }
    }

    private boolean applySpecialCase(BlockPos pos, EntityLiving ent) {
        if (ent instanceof EntitySlime) {
            ent.func_70625_a((Entity)this.getTarget(ent.func_130014_f_(), pos), 10.0f, 20.0f);
            return true;
        }
        if (ent instanceof EntitySilverfish) {
            EntitySilverfish es = (EntitySilverfish)ent;
            Path pathentity = this.getPathEntityToEntity((Entity)ent, (Entity)this.getTarget(ent.func_130014_f_(), pos), this.getRange());
            es.func_70661_as().func_75484_a(pathentity, (double)es.func_70689_ay());
            return true;
        }
        return ent instanceof EntityBlaze;
    }

    private boolean useSpecialCase(EntityLiving ent) {
        return ent instanceof EntitySlime || ent instanceof EntitySilverfish || ent instanceof EntityBlaze;
    }

    public FakePlayer getTarget(World world, BlockPos pos) {
        if (this.target == null) {
            this.target = new Target(world, pos);
        }
        return this.target;
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
    }

    @Override
    public AlchemyArrayEffect getNewCopy() {
        return new AlchemyArrayEffectAttractor(this.key);
    }

    private class Target
    extends FakePlayerBM {
        public Target(World world, BlockPos pos) {
            super(world, pos, new GameProfile(null, "bloodmagicArrayAttractor:" + pos));
            this.field_70163_u += 1.0;
        }
    }

    private static class AttractTask
    extends EntityAIBase {
        private EntityLiving mob;
        private BlockPos coord;
        private FakePlayer target;
        private int updatesSincePathing;
        private boolean started = false;

        private AttractTask(EntityLiving mob, FakePlayer target, BlockPos coord) {
            this.mob = mob;
            this.coord = coord;
            this.target = target;
        }

        public boolean func_75250_a() {
            boolean res = false;
            TileEntity te = this.mob.func_130014_f_().func_175625_s(this.coord);
            if (te instanceof TileAlchemyArray) {
                res = true;
            }
            return res;
        }

        public void func_75251_c() {
            this.started = false;
            this.updatesSincePathing = 0;
        }

        public boolean func_75252_g() {
            return true;
        }

        public void func_75246_d() {
            if (!this.started || this.updatesSincePathing > 20) {
                this.started = true;
                boolean speed = true;
                boolean res = this.mob.func_70661_as().func_75497_a((Entity)this.target, (double)speed);
                if (!res) {
                    this.mob.func_70661_as().func_75492_a(this.target.field_70165_t, this.target.field_70163_u + 1.0, this.target.field_70161_v, (double)speed);
                }
                this.updatesSincePathing = 0;
            } else {
                ++this.updatesSincePathing;
            }
        }
    }
}

