/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.client.hud.element;

import WayofTime.bloodmagic.client.hud.element.HUDElement;
import WayofTime.bloodmagic.proxy.ClientProxy;
import WayofTime.bloodmagic.soul.EnumDemonWillType;
import WayofTime.bloodmagic.util.Utils;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;

public class ElementDemonAura
extends HUDElement {
    private static final ResourceLocation BAR_LOCATION = new ResourceLocation("bloodmagic", "textures/hud/bars.png");
    private final List<EnumDemonWillType> orderedTypes = Lists.newArrayList((Object[])new EnumDemonWillType[]{EnumDemonWillType.DEFAULT, EnumDemonWillType.CORROSIVE, EnumDemonWillType.STEADFAST, EnumDemonWillType.DESTRUCTIVE, EnumDemonWillType.VENGEFUL});

    public ElementDemonAura() {
        super(80, 46);
    }

    @Override
    public void draw(ScaledResolution resolution, float partialTicks, int drawX, int drawY) {
        Minecraft minecraft = Minecraft.func_71410_x();
        EntityPlayerSP player = minecraft.field_71439_g;
        minecraft.func_110434_K().func_110577_a(BAR_LOCATION);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        this.drawTexturedModalRect(drawX, drawY, 0.0, 210.0, 80.0, 46.0);
        double maxAmount = Utils.getDemonWillResolution((EntityPlayer)player);
        int i = 0;
        for (EnumDemonWillType type : this.orderedTypes) {
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            minecraft.func_110434_K().func_110577_a(BAR_LOCATION);
            int textureXOffset = ++i > 3 ? i - 3 : 3 - i;
            int maxBarSize = 30 - 2 * textureXOffset;
            double amount = ClientProxy.currentAura == null ? 0.0 : ClientProxy.currentAura.getWill(type);
            double ratio = Math.max(Math.min(amount / maxAmount, 1.0), 0.0);
            double width = (double)maxBarSize * ratio * 2.0;
            double height = 2.0;
            double x = drawX + 2 * textureXOffset + 10;
            double y = drawY + 4 * i + 10;
            double textureX = 2 * textureXOffset + 84;
            double textureY = 4 * i + 220;
            this.drawTexturedModalRect(x, y, textureX, textureY, width, height);
            if (!player.func_70093_af()) continue;
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)(x - (double)(2 * textureXOffset) + 70.0), (double)(y - 1.0), (double)0.0);
            GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)1.0);
            minecraft.field_71466_p.func_175063_a(String.valueOf((int)amount), 0.0f, 2.0f, 0xFFFFFF);
            GlStateManager.func_179121_F();
        }
    }

    @Override
    public boolean shouldRender(Minecraft minecraft) {
        return Utils.canPlayerSeeDemonWill((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
    }
}

