/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.compat.jei.forge;

import WayofTime.bloodmagic.api.impl.recipe.RecipeTartaricForge;
import WayofTime.bloodmagic.compat.jei.BloodMagicJEIPlugin;
import WayofTime.bloodmagic.core.RegistrarBloodMagicItems;
import WayofTime.bloodmagic.util.helper.TextHelper;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.item.ItemStack;

public class TartaricForgeRecipeJEI
implements IRecipeWrapper {
    private RecipeTartaricForge recipe;
    private List<ItemStack> validGems = Lists.newArrayList();

    public TartaricForgeRecipeJEI(RecipeTartaricForge recipe) {
        this.recipe = recipe;
        for (DefaultWill will : DefaultWill.values()) {
            if (!(will.minSouls >= recipe.getMinimumSouls())) continue;
            this.validGems.add(will.willStack);
        }
    }

    public void getIngredients(@Nonnull IIngredients ingredients) {
        List expandedInputs = BloodMagicJEIPlugin.jeiHelper.getStackHelper().expandRecipeItemStackInputs(this.recipe.getInput());
        expandedInputs.add(this.validGems);
        ingredients.setInputLists(ItemStack.class, expandedInputs);
        ingredients.setOutput(ItemStack.class, (Object)this.recipe.getOutput());
    }

    @Nonnull
    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        ArrayList tooltip = Lists.newArrayList();
        if (mouseX >= 40 && mouseX <= 60 && mouseY >= 21 && mouseY <= 34) {
            tooltip.add(TextHelper.localize("jei.bloodmagic.recipe.minimumSouls", this.recipe.getMinimumSouls()));
            tooltip.add(TextHelper.localize("jei.bloodmagic.recipe.soulsDrained", this.recipe.getSoulDrain()));
        }
        return tooltip;
    }

    public RecipeTartaricForge getRecipe() {
        return this.recipe;
    }

    public static enum DefaultWill {
        SOUL(new ItemStack(RegistrarBloodMagicItems.MONSTER_SOUL, 1, 0), 64.0),
        PETTY(new ItemStack(RegistrarBloodMagicItems.SOUL_GEM, 1, 0), 64.0),
        LESSER(new ItemStack(RegistrarBloodMagicItems.SOUL_GEM, 1, 1), 256.0),
        COMMON(new ItemStack(RegistrarBloodMagicItems.SOUL_GEM, 1, 2), 1024.0),
        GREATER(new ItemStack(RegistrarBloodMagicItems.SOUL_GEM, 1, 3), 4096.0),
        GRAND(new ItemStack(RegistrarBloodMagicItems.SOUL_GEM, 1, 4), 16384.0);

        public final ItemStack willStack;
        public final double minSouls;

        private DefaultWill(ItemStack willStack, double minSouls) {
            this.willStack = willStack;
            this.minSouls = minSouls;
        }
    }
}

