/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.entity.projectile;

import WayofTime.bloodmagic.meteor.MeteorRegistry;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IThrowableEntity;

public class EntityMeteor
extends EntityThrowable
implements IThrowableEntity {
    public ItemStack meteorStack = ItemStack.field_190927_a;
    protected int field_70195_i = 0;
    protected int maxTicksInAir = 600;
    protected double radiusModifier = 1.0;
    protected double explosionModifier = 1.0;
    protected double fillerChance = 0.0;

    public EntityMeteor(World world) {
        super(world);
    }

    public EntityMeteor(World world, double x, double y, double z, double velX, double velY, double velZ, double radiusModifier, double explosionModifier, double fillerChance) {
        super(world);
        this.func_70105_a(1.0f, 1.0f);
        this.func_70107_b(x, y, z);
        this.field_70159_w = velX;
        this.field_70181_x = velY;
        this.field_70179_y = velZ;
        this.radiusModifier = radiusModifier;
        this.explosionModifier = explosionModifier;
        this.fillerChance = fillerChance;
    }

    protected float func_70185_h() {
        return 0.03f;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70173_aa > this.maxTicksInAir) {
            this.func_70106_y();
        }
    }

    protected void func_70184_a(RayTraceResult mop) {
        if (mop.field_72313_a == RayTraceResult.Type.ENTITY && mop.field_72308_g != null) {
            this.onImpact(mop.field_72308_g);
        } else if (mop.field_72313_a == RayTraceResult.Type.BLOCK) {
            this.generateMeteor(mop.func_178782_a());
        }
        this.func_70106_y();
    }

    protected void onImpact(Entity mop) {
        if (mop instanceof EntityLivingBase) {
            this.doDamage(100, mop);
        }
        this.generateMeteor(mop.func_180425_c());
        this.func_70106_y();
    }

    protected void doDamage(int i, Entity mop) {
        mop.func_70097_a(this.getDamageSource(), (float)i);
    }

    public void generateMeteor(BlockPos pos) {
        MeteorRegistry.generateMeteorForItem(this.meteorStack, this.func_130014_f_(), pos, Blocks.field_150348_b.func_176223_P(), this.radiusModifier, this.explosionModifier, this.fillerChance);
    }

    public DamageSource getDamageSource() {
        return DamageSource.field_82728_o;
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("projectileTicksInAir", this.field_70195_i);
        nbt.func_74768_a("projectileMaxTicksInAir", this.maxTicksInAir);
        nbt.func_74780_a("radiusModifier", this.radiusModifier);
        nbt.func_74780_a("explosionModifier", this.explosionModifier);
        nbt.func_74780_a("fillerChance", this.fillerChance);
        if (!this.meteorStack.func_190926_b()) {
            this.meteorStack.func_77955_b(nbt);
        } else {
            nbt.func_74757_a("noItem", true);
        }
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.field_70195_i = nbt.func_74762_e("projectileTicksInAir");
        this.maxTicksInAir = nbt.func_74762_e("projectileMaxTicksInAir");
        this.radiusModifier = nbt.func_74769_h("radiusModifier");
        this.explosionModifier = nbt.func_74769_h("explosionModifier");
        this.fillerChance = nbt.func_74769_h("fillerChance");
        this.meteorStack = !nbt.func_74764_b("noItem") ? new ItemStack(nbt) : ItemStack.field_190927_a;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public boolean func_70067_L() {
        return false;
    }

    public void setThrower(Entity entity) {
    }

    public void setMeteorStack(ItemStack meteorStack) {
        this.meteorStack = meteorStack;
    }
}

