/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.item;

import WayofTime.bloodmagic.core.RegistrarBloodMagicItems;
import WayofTime.bloodmagic.core.data.Binding;
import WayofTime.bloodmagic.iface.IBindable;
import WayofTime.bloodmagic.item.ItemEnum;
import WayofTime.bloodmagic.item.types.ISubItem;
import WayofTime.bloodmagic.util.helper.NBTHelper;
import WayofTime.bloodmagic.util.helper.TextHelper;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemTelepositionFocus
extends ItemEnum.Variant<FocusType>
implements IBindable {
    public ItemTelepositionFocus() {
        super(FocusType.class, "focus");
        this.func_77625_d(1);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        RayTraceResult mop;
        if (player.func_70093_af() && (mop = this.func_77621_a(world, player, false)) != null && mop.field_72313_a == RayTraceResult.Type.BLOCK) {
            this.setBlockPos(player.func_184586_b(hand), world, mop.func_178782_a());
        }
        return super.func_77659_a(world, player, hand);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.addAll(Arrays.asList(TextHelper.cutLongString(TextHelper.localize("tooltip.bloodmagic.telepositionFocus." + ((FocusType)this.getItemType(stack)).getInternalName(), new Object[0]))));
        super.func_77624_a(stack, world, tooltip, flag);
        Binding binding = this.getBinding(stack);
        if (binding != null) {
            tooltip.add(TextHelper.localizeEffect("tooltip.bloodmagic.currentOwner", binding.getOwnerName()));
        }
        if (!stack.func_77942_o()) {
            return;
        }
        NBTTagCompound tag = stack.func_77978_p();
        BlockPos coords = this.getBlockPos(stack);
        if (coords != null && tag != null) {
            tooltip.add(TextHelper.localizeEffect("tooltip.bloodmagic.telepositionFocus.coords", coords.func_177958_n(), coords.func_177956_o(), coords.func_177952_p()));
            tooltip.add(TextHelper.localizeEffect("tooltip.bloodmagic.telepositionFocus.dimension", tag.func_74762_e("dimensionId")));
        }
    }

    public World getWorld(ItemStack stack) {
        stack = NBTHelper.checkNBT(stack);
        return DimensionManager.getWorld((int)stack.func_77978_p().func_74762_e("dimensionId"));
    }

    public BlockPos getBlockPos(ItemStack stack) {
        stack = NBTHelper.checkNBT(stack);
        return new BlockPos(stack.func_77978_p().func_74762_e("xCoord"), stack.func_77978_p().func_74762_e("yCoord"), stack.func_77978_p().func_74762_e("zCoord"));
    }

    public ItemStack setBlockPos(ItemStack stack, World world, BlockPos pos) {
        stack = NBTHelper.checkNBT(stack);
        NBTTagCompound itemTag = stack.func_77978_p();
        itemTag.func_74768_a("xCoord", pos.func_177958_n());
        itemTag.func_74768_a("yCoord", pos.func_177956_o());
        itemTag.func_74768_a("zCoord", pos.func_177952_p());
        itemTag.func_74768_a("dimensionId", world.field_73011_w.getDimension());
        return stack;
    }

    public static enum FocusType implements ISubItem
    {
        WEAK,
        ENHANCED,
        REINFORCED,
        DEMONIC;


        @Override
        @Nonnull
        public String getInternalName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        @Override
        @Nonnull
        public ItemStack getStack(int count) {
            return new ItemStack(RegistrarBloodMagicItems.TELEPOSITION_FOCUS, count, this.ordinal());
        }
    }
}

