/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.ritual.types;

import WayofTime.bloodmagic.compress.CompressionRegistry;
import WayofTime.bloodmagic.core.RegistrarBloodMagicBlocks;
import WayofTime.bloodmagic.demonAura.WorldDemonWillHandler;
import WayofTime.bloodmagic.ritual.AreaDescriptor;
import WayofTime.bloodmagic.ritual.EnumRuneType;
import WayofTime.bloodmagic.ritual.IMasterRitualStone;
import WayofTime.bloodmagic.ritual.Ritual;
import WayofTime.bloodmagic.ritual.RitualComponent;
import WayofTime.bloodmagic.ritual.RitualRegister;
import WayofTime.bloodmagic.ritual.crushing.CrushingRegistry;
import WayofTime.bloodmagic.ritual.crushing.ICrushingHandler;
import WayofTime.bloodmagic.soul.EnumDemonWillType;
import WayofTime.bloodmagic.util.Utils;
import com.mojang.authlib.GameProfile;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import org.apache.commons.lang3.tuple.Pair;

@RitualRegister(value="crushing")
public class RitualCrushing
extends Ritual {
    public static final String CRUSHING_RANGE = "crushingRange";
    public static final String CHEST_RANGE = "chest";
    public static double rawWillDrain = 0.05;
    public static double steadfastWillDrain = 0.2;
    public static double destructiveWillDrain = 0.2;
    public static double vengefulWillDrain = 0.2;
    public static Map<ItemStack, Integer> cuttingFluidLPMap = new HashMap<ItemStack, Integer>();
    public static Map<ItemStack, Double> cuttingFluidWillMap = new HashMap<ItemStack, Double>();
    public static int defaultRefreshTime = 40;
    private FakePlayer fakePlayer;
    public int refreshTime = 40;

    public RitualCrushing() {
        super("ritualCrushing", 0, 5000, "ritual.bloodmagic.crushingRitual");
        this.addBlockRange(CRUSHING_RANGE, new AreaDescriptor.Rectangle(new BlockPos(-1, -3, -1), 3));
        this.addBlockRange(CHEST_RANGE, new AreaDescriptor.Rectangle(new BlockPos(0, 1, 0), 1));
        this.setMaximumVolumeAndDistanceOfRange(CRUSHING_RANGE, 50, 10, 10);
        this.setMaximumVolumeAndDistanceOfRange(CHEST_RANGE, 1, 3, 3);
    }

    @Override
    public void performRitual(IMasterRitualStone masterRitualStone) {
        Pair<ItemStack, Boolean> pair;
        World world = masterRitualStone.getWorldObj();
        int currentEssence = masterRitualStone.getOwnerNetwork().getCurrentEssence();
        if (currentEssence < this.getRefreshCost()) {
            masterRitualStone.getOwnerNetwork().causeNausea();
            return;
        }
        BlockPos pos = masterRitualStone.getBlockPos();
        AreaDescriptor chestRange = masterRitualStone.getBlockRange(CHEST_RANGE);
        TileEntity tile = world.func_175625_s(chestRange.getContainedPositions(pos).get(0));
        if (tile != null && Utils.getNumberOfFreeSlots(tile, EnumFacing.DOWN) < 1) {
            return;
        }
        List<EnumDemonWillType> willConfig = masterRitualStone.getActiveWillConfig();
        double rawWill = this.getWillRespectingConfig(world, pos, EnumDemonWillType.DEFAULT, willConfig);
        double steadfastWill = this.getWillRespectingConfig(world, pos, EnumDemonWillType.STEADFAST, willConfig);
        double corrosiveWill = this.getWillRespectingConfig(world, pos, EnumDemonWillType.CORROSIVE, willConfig);
        double destructiveWill = this.getWillRespectingConfig(world, pos, EnumDemonWillType.DESTRUCTIVE, willConfig);
        double vengefulWill = this.getWillRespectingConfig(world, pos, EnumDemonWillType.VENGEFUL, willConfig);
        this.refreshTime = this.getRefreshTimeForRawWill(rawWill);
        boolean consumeRawWill = rawWill >= rawWillDrain && this.refreshTime != defaultRefreshTime;
        boolean isSilkTouch = steadfastWill >= steadfastWillDrain;
        boolean useCuttingFluid = corrosiveWill > 0.0;
        int fortune = destructiveWill > 0.0 ? 3 : 0;
        AreaDescriptor crushingRange = masterRitualStone.getBlockRange(CRUSHING_RANGE);
        boolean hasOperated = false;
        double rawDrain = 0.0;
        for (BlockPos newPos : crushingRange.getContainedPositions(pos)) {
            ItemStack copyStack;
            ItemStack checkStack;
            IBlockState state;
            Block block;
            if (world.func_175623_d(newPos) || (block = (state = world.func_180495_p(newPos)).func_177230_c()).equals(RegistrarBloodMagicBlocks.RITUAL_CONTROLLER) || block.equals(RegistrarBloodMagicBlocks.RITUAL_STONE) || block.func_176195_g(state, world, newPos) == -1.0f || Utils.isBlockLiquid(state)) continue;
            boolean isBlockClaimed = false;
            if (useCuttingFluid) {
                checkStack = block.func_185473_a(world, newPos, state);
                if (checkStack.func_190926_b()) continue;
                copyStack = checkStack.func_77946_l();
                for (ICrushingHandler handler : CrushingRegistry.getCrushingHandlerList()) {
                    ItemStack result;
                    int lpDrain = handler.getLpDrain();
                    double willDrain = handler.getWillDrain();
                    if (corrosiveWill < willDrain || currentEssence < lpDrain + this.getRefreshCost() || (result = handler.getRecipeOutput(copyStack, world, pos)).func_190926_b()) continue;
                    if (tile != null) {
                        if (!(result = Utils.insertStackIntoTile(result, tile, EnumFacing.DOWN)).func_190926_b()) {
                            Utils.spawnStackAtBlock(world, pos, EnumFacing.UP, result);
                        }
                    } else {
                        Utils.spawnStackAtBlock(world, pos, EnumFacing.UP, result);
                    }
                    WorldDemonWillHandler.drainWill(world, pos, EnumDemonWillType.CORROSIVE, willDrain, true);
                    corrosiveWill -= willDrain;
                    masterRitualStone.getOwnerNetwork().syphon(masterRitualStone.ticket(lpDrain));
                    currentEssence -= lpDrain;
                    isBlockClaimed = true;
                }
            }
            if (!isBlockClaimed && isSilkTouch && block.canSilkHarvest(world, newPos, state, (EntityPlayer)this.getFakePlayer((WorldServer)world))) {
                checkStack = block.func_185473_a(world, newPos, state);
                if (checkStack.func_190926_b()) continue;
                copyStack = checkStack.func_77946_l();
                if (!(steadfastWill >= steadfastWillDrain)) continue;
                WorldDemonWillHandler.drainWill(world, pos, EnumDemonWillType.STEADFAST, steadfastWillDrain, true);
                steadfastWill -= steadfastWillDrain;
                if (tile != null) {
                    copyStack = Utils.insertStackIntoTile(copyStack, tile, EnumFacing.DOWN);
                } else {
                    Utils.spawnStackAtBlock(world, pos, EnumFacing.UP, copyStack);
                }
                if (!copyStack.func_190926_b()) {
                    Utils.spawnStackAtBlock(world, pos, EnumFacing.UP, copyStack);
                }
            } else if (!isBlockClaimed) {
                if (fortune > 0 && destructiveWill < destructiveWillDrain) {
                    fortune = 0;
                }
                List stackList = block.getDrops((IBlockAccess)world, newPos, state, fortune);
                for (ItemStack item : stackList) {
                    ItemStack copyStack2 = item.func_77946_l();
                    if (tile == null) {
                        Utils.spawnStackAtBlock(world, pos, EnumFacing.UP, copyStack2);
                        continue;
                    }
                    copyStack2 = Utils.insertStackIntoTile(copyStack2, tile, EnumFacing.DOWN);
                    if (copyStack2.func_190926_b()) continue;
                    Utils.spawnStackAtBlock(world, pos, EnumFacing.UP, copyStack2);
                }
                if (fortune > 0) {
                    WorldDemonWillHandler.drainWill(world, pos, EnumDemonWillType.DESTRUCTIVE, destructiveWillDrain, true);
                    destructiveWill -= destructiveWillDrain;
                }
            }
            world.func_175655_b(newPos, false);
            masterRitualStone.getOwnerNetwork().syphon(masterRitualStone.ticket(this.getRefreshCost()));
            hasOperated = true;
            if (!consumeRawWill) break;
            rawDrain += rawWillDrain;
            rawWill -= rawWillDrain;
            break;
        }
        if (hasOperated && tile != null && vengefulWill >= vengefulWillDrain && ((Boolean)(pair = CompressionRegistry.compressInventory(tile, world)).getRight()).booleanValue()) {
            ItemStack returned = (ItemStack)pair.getLeft();
            if (returned != null) {
                Utils.spawnStackAtBlock(world, pos, EnumFacing.UP, returned);
            }
            WorldDemonWillHandler.drainWill(world, pos, EnumDemonWillType.VENGEFUL, vengefulWillDrain, true);
        }
        if (rawDrain > 0.0) {
            WorldDemonWillHandler.drainWill(world, pos, EnumDemonWillType.DEFAULT, rawDrain, true);
        }
    }

    public int getRefreshTimeForRawWill(double rawWill) {
        if (rawWill >= rawWillDrain) {
            return Math.max(1, (int)(40.0 - rawWill / 5.0));
        }
        return defaultRefreshTime;
    }

    @Override
    public int getRefreshTime() {
        return this.refreshTime;
    }

    @Override
    public int getRefreshCost() {
        return 7;
    }

    @Override
    public void gatherComponents(Consumer<RitualComponent> components) {
        this.addParallelRunes(components, 1, 0, EnumRuneType.EARTH);
        this.addParallelRunes(components, 2, 0, EnumRuneType.FIRE);
        this.addCornerRunes(components, 2, 0, EnumRuneType.DUSK);
        this.addParallelRunes(components, 2, 1, EnumRuneType.AIR);
    }

    @Override
    public ITextComponent[] provideInformationOfRitualToPlayer(EntityPlayer player) {
        return new ITextComponent[]{new TextComponentTranslation(this.getTranslationKey() + ".info", new Object[0]), new TextComponentTranslation(this.getTranslationKey() + ".default.info", new Object[0]), new TextComponentTranslation(this.getTranslationKey() + ".corrosive.info", new Object[0]), new TextComponentTranslation(this.getTranslationKey() + ".steadfast.info", new Object[0]), new TextComponentTranslation(this.getTranslationKey() + ".destructive.info", new Object[0]), new TextComponentTranslation(this.getTranslationKey() + ".vengeful.info", new Object[0])};
    }

    @Override
    public Ritual getNewCopy() {
        return new RitualCrushing();
    }

    public static void registerCuttingFluid(ItemStack stack, int lpDrain, double willDrain) {
        cuttingFluidLPMap.put(stack, lpDrain);
        cuttingFluidWillMap.put(stack, willDrain);
    }

    private FakePlayer getFakePlayer(WorldServer world) {
        return this.fakePlayer == null ? (this.fakePlayer = FakePlayerFactory.get((WorldServer)world, (GameProfile)new GameProfile(null, "bloodmagic_ritual_crushing"))) : this.fakePlayer;
    }
}

