/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.ritual.types;

import WayofTime.bloodmagic.core.RegistrarBloodMagicBlocks;
import WayofTime.bloodmagic.ritual.EnumRuneType;
import WayofTime.bloodmagic.ritual.IMasterRitualStone;
import WayofTime.bloodmagic.ritual.Ritual;
import WayofTime.bloodmagic.ritual.RitualComponent;
import WayofTime.bloodmagic.ritual.RitualRegister;
import WayofTime.bloodmagic.ritual.portal.LocationsHandler;
import WayofTime.bloodmagic.teleport.PortalLocation;
import WayofTime.bloodmagic.tile.TileDimensionalPortal;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

@RitualRegister(value="portal")
public class RitualPortal
extends Ritual {
    public static final String PORTAL_NBT_TAG = "PortalRitualTag";
    public static final String PORTAL_ID_TAG = "PortalRitualID";
    private NBTTagCompound portalRitualTag = new NBTTagCompound();

    public RitualPortal() {
        super("ritualPortal", 0, 50000, "ritual.bloodmagic.portalRitual");
    }

    @Override
    public boolean activateRitual(IMasterRitualStone masterRitualStone, EntityPlayer player, UUID owner) {
        World world = masterRitualStone.getWorldObj();
        int x = masterRitualStone.getBlockPos().func_177958_n();
        int y = masterRitualStone.getBlockPos().func_177956_o();
        int z = masterRitualStone.getBlockPos().func_177952_p();
        EnumFacing direction = masterRitualStone.getDirection();
        String name = owner.toString();
        if (!world.field_72995_K) {
            this.portalRitualTag.func_82580_o(PORTAL_ID_TAG);
            if (direction == EnumFacing.NORTH || direction == EnumFacing.SOUTH) {
                int j;
                IBlockState blockState;
                for (int i = x - 3; i <= x + 3; ++i) {
                    for (int k = z - 2; k <= z + 2; ++k) {
                        if (world.func_175623_d(new BlockPos(i, y, k)) || this.getBlockState(world, i, y, k).func_177230_c() == RegistrarBloodMagicBlocks.RITUAL_STONE) continue;
                        blockState = this.getBlockState(world, i, y, k);
                        name = this.addStringToEnd(name, ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)blockState.func_177230_c()) + String.valueOf(blockState.func_177230_c().func_176201_c(blockState)));
                    }
                }
                for (j = y + 1; j <= y + 5; ++j) {
                    if (world.func_175623_d(new BlockPos(x - 3, j, z)) || this.getBlockState(world, x - 3, j, z).func_177230_c() == RegistrarBloodMagicBlocks.RITUAL_STONE) continue;
                    blockState = this.getBlockState(world, x - 3, j, z);
                    name = this.addStringToEnd(name, ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)blockState.func_177230_c()) + String.valueOf(blockState.func_177230_c().func_176201_c(blockState)));
                }
                for (j = y + 1; j <= y + 5; ++j) {
                    if (world.func_175623_d(new BlockPos(x + 3, j, z)) || this.getBlockState(world, x + 3, j, z) == RegistrarBloodMagicBlocks.RITUAL_STONE) continue;
                    blockState = this.getBlockState(world, x + 3, j, z);
                    name = this.addStringToEnd(name, ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)blockState.func_177230_c()) + String.valueOf(blockState.func_177230_c().func_176201_c(blockState)));
                }
            } else if (direction == EnumFacing.EAST || direction == EnumFacing.WEST) {
                int j;
                IBlockState blockState;
                for (int k = z - 3; k <= z + 3; ++k) {
                    for (int i = x - 2; i <= x + 2; ++i) {
                        if (world.func_175623_d(new BlockPos(i, y, k)) || this.getBlockState(world, i, y, k).func_177230_c() == RegistrarBloodMagicBlocks.RITUAL_STONE) continue;
                        blockState = this.getBlockState(world, i, y, k);
                        name = this.addStringToEnd(name, ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)blockState.func_177230_c()) + String.valueOf(blockState.func_177230_c().func_176201_c(blockState)));
                    }
                }
                for (j = y + 1; j <= y + 5; ++j) {
                    if (world.func_175623_d(new BlockPos(x, j, z - 3)) || this.getBlockState(world, x, j, z - 3).func_177230_c() == RegistrarBloodMagicBlocks.RITUAL_STONE) continue;
                    blockState = this.getBlockState(world, x, j, z - 3);
                    name = this.addStringToEnd(name, ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)blockState.func_177230_c()) + String.valueOf(blockState.func_177230_c().func_176201_c(blockState)));
                }
                for (j = y + 1; j <= y + 5; ++j) {
                    if (world.func_175623_d(new BlockPos(x, j, z + 3)) || this.getBlockState(world, x, j, z + 3).func_177230_c() == RegistrarBloodMagicBlocks.RITUAL_STONE) continue;
                    blockState = this.getBlockState(world, x, j, z + 3);
                    name = this.addStringToEnd(name, ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)blockState.func_177230_c()) + String.valueOf(blockState.func_177230_c().func_176201_c(blockState)));
                }
            }
            if (LocationsHandler.getLocationsHandler().addLocation(name, new PortalLocation(x, y + 1, z, world.field_73011_w.getDimension()))) {
                this.portalRitualTag.func_74778_a(PORTAL_ID_TAG, name);
                return true;
            }
        }
        return false;
    }

    @Override
    public void performRitual(IMasterRitualStone masterRitualStone) {
        block6: {
            EnumFacing direction;
            int z;
            int y;
            int x;
            World world;
            block5: {
                world = masterRitualStone.getWorldObj();
                if (world.field_72995_K) {
                    return;
                }
                x = masterRitualStone.getBlockPos().func_177958_n();
                y = masterRitualStone.getBlockPos().func_177956_o();
                z = masterRitualStone.getBlockPos().func_177952_p();
                direction = masterRitualStone.getDirection();
                if (direction != EnumFacing.NORTH && direction != EnumFacing.SOUTH) break block5;
                for (int i = x - 1; i <= x + 1; ++i) {
                    for (int j = y + 1; j <= y + 3; ++j) {
                        BlockPos tempPos = new BlockPos(i, j, z);
                        if (!world.func_175623_d(tempPos)) continue;
                        IBlockState blockState = RegistrarBloodMagicBlocks.DIMENSIONAL_PORTAL.func_176203_a(0);
                        world.func_180501_a(tempPos, blockState, 3);
                        if (world.func_175625_s(tempPos) == null || !(world.func_175625_s(tempPos) instanceof TileDimensionalPortal)) continue;
                        TileDimensionalPortal tile = (TileDimensionalPortal)world.func_175625_s(tempPos);
                        tile.setMasterStonePos(masterRitualStone.getBlockPos());
                        tile.portalID = this.portalRitualTag.func_74779_i(PORTAL_ID_TAG);
                    }
                }
                break block6;
            }
            if (direction != EnumFacing.EAST && direction != EnumFacing.WEST) break block6;
            for (int k = z - 1; k <= z + 1; ++k) {
                for (int j = y + 1; j <= y + 3; ++j) {
                    BlockPos tempPos = new BlockPos(x, j, k);
                    if (!world.func_175623_d(tempPos)) continue;
                    IBlockState blockState = RegistrarBloodMagicBlocks.DIMENSIONAL_PORTAL.func_176203_a(1);
                    world.func_180501_a(tempPos, blockState, 3);
                    if (world.func_175625_s(tempPos) == null || !(world.func_175625_s(tempPos) instanceof TileDimensionalPortal)) continue;
                    TileDimensionalPortal tile = (TileDimensionalPortal)world.func_175625_s(tempPos);
                    tile.setMasterStonePos(masterRitualStone.getBlockPos());
                    tile.portalID = this.portalRitualTag.func_74779_i(PORTAL_ID_TAG);
                }
            }
        }
    }

    @Override
    public void stopRitual(IMasterRitualStone masterRitualStone, Ritual.BreakType breakType) {
        World world = masterRitualStone.getWorldObj();
        int x = masterRitualStone.getBlockPos().func_177958_n();
        int y = masterRitualStone.getBlockPos().func_177956_o();
        int z = masterRitualStone.getBlockPos().func_177952_p();
        EnumFacing direction = masterRitualStone.getDirection();
        LocationsHandler.getLocationsHandler().removeLocation(this.portalRitualTag.func_74779_i(PORTAL_ID_TAG), new PortalLocation(x, y + 1, z, world.field_73011_w.getDimension()));
        if (direction == EnumFacing.NORTH || direction == EnumFacing.SOUTH) {
            for (int i = x - 2; i <= x + 2; ++i) {
                for (int j = y + 1; j <= y + 3; ++j) {
                    if (this.getBlockState(world, i, j, z).func_177230_c() != RegistrarBloodMagicBlocks.DIMENSIONAL_PORTAL) continue;
                    world.func_175698_g(new BlockPos(i, j, z));
                }
            }
        } else if (direction == EnumFacing.EAST || direction == EnumFacing.WEST) {
            for (int k = z - 2; k <= z + 2; ++k) {
                for (int j = y + 1; j <= y + 3; ++j) {
                    if (this.getBlockState(world, x, j, k).func_177230_c() != RegistrarBloodMagicBlocks.DIMENSIONAL_PORTAL) continue;
                    world.func_175698_g(new BlockPos(x, j, k));
                }
            }
        }
        this.portalRitualTag.func_82580_o(PORTAL_ID_TAG);
    }

    @Override
    public int getRefreshCost() {
        return 0;
    }

    @Override
    public void gatherComponents(Consumer<RitualComponent> components) {
        this.addRune(components, 1, 0, 0, EnumRuneType.AIR);
        this.addRune(components, 2, 0, 0, EnumRuneType.WATER);
        this.addRune(components, -1, 0, 0, EnumRuneType.FIRE);
        this.addRune(components, -2, 0, 0, EnumRuneType.EARTH);
        this.addRune(components, 2, 1, 0, EnumRuneType.DUSK);
        this.addRune(components, 2, 2, 0, EnumRuneType.AIR);
        this.addRune(components, 2, 3, 0, EnumRuneType.WATER);
        this.addRune(components, 2, 4, 0, EnumRuneType.FIRE);
        this.addRune(components, 1, 4, 0, EnumRuneType.EARTH);
        this.addRune(components, 0, 4, 0, EnumRuneType.DUSK);
        this.addRune(components, -1, 4, 0, EnumRuneType.AIR);
        this.addRune(components, -2, 4, 0, EnumRuneType.WATER);
        this.addRune(components, -2, 3, 0, EnumRuneType.FIRE);
        this.addRune(components, -2, 2, 0, EnumRuneType.EARTH);
        this.addRune(components, -2, 1, 0, EnumRuneType.DUSK);
    }

    @Override
    public Ritual getNewCopy() {
        return new RitualPortal();
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.portalRitualTag = tag.func_74775_l(PORTAL_NBT_TAG);
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74782_a(PORTAL_NBT_TAG, (NBTBase)this.portalRitualTag);
    }

    public IBlockState getBlockState(World world, int x, int y, int z) {
        return world.func_180495_p(new BlockPos(x, y, z));
    }

    public String addStringToEnd(String input, String toAdd) {
        return input + toAdd;
    }
}

