/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.item.addon.movility;

import com.buuz135.industrial.item.addon.movility.TransferAddon;
import com.buuz135.industrial.proxy.ItemRegistry;
import com.buuz135.industrial.utils.RecipeUtils;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemStackTransferAddon
extends TransferAddon {
    public ItemStackTransferAddon(TransferAddon.ActionMode mode) {
        super("itemstack_transfer_addon", mode);
    }

    @Override
    public void createRecipe() {
        RecipeUtils.addShapedRecipe(new ItemStack((Item)this), new Object[]{"pcp", "dtd", "pcp", Character.valueOf('p'), ItemRegistry.plastic, Character.valueOf('c'), "chestWood", Character.valueOf('d'), "dyeMagenta", Character.valueOf('t'), this.getMode() == TransferAddon.ActionMode.PUSH ? Blocks.field_150331_J : Blocks.field_150320_F});
    }

    @Override
    public boolean actionTransfer(World world, BlockPos pos, EnumFacing facing, int transferAmount) {
        TileEntity tileEntityOrigin = world.func_175625_s(pos);
        TileEntity tileEntityDestination = world.func_175625_s(pos.func_177972_a(facing));
        if (tileEntityOrigin != null && tileEntityDestination != null && tileEntityOrigin.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing) && tileEntityDestination.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d())) {
            IItemHandler itemHandlerOrigin = this.getCapabilityOriginByMode(tileEntityOrigin, tileEntityDestination, facing);
            IItemHandler itemHandlerDestination = this.getCapabilityDestinationByMode(tileEntityOrigin, tileEntityDestination, facing);
            for (int i = 0; i < itemHandlerOrigin.getSlots(); ++i) {
                ItemStack input = itemHandlerOrigin.extractItem(i, transferAmount, true);
                if (input.func_190926_b()) continue;
                ItemStack result = ItemHandlerHelper.insertItem((IItemHandler)itemHandlerDestination, (ItemStack)input, (boolean)true);
                int amountInserted = input.func_190916_E() - result.func_190916_E();
                if (amountInserted <= 0) continue;
                result = ItemHandlerHelper.insertItem((IItemHandler)itemHandlerDestination, (ItemStack)itemHandlerOrigin.extractItem(i, amountInserted, false), (boolean)false);
                if (!result.func_190926_b()) {
                    ItemHandlerHelper.insertItem((IItemHandler)itemHandlerOrigin, (ItemStack)result, (boolean)false);
                }
                return true;
            }
        }
        return false;
    }

    public IItemHandler getCapabilityOriginByMode(TileEntity origin, TileEntity destination, EnumFacing facing) {
        return this.getMode() == TransferAddon.ActionMode.PUSH ? (IItemHandler)origin.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing) : (IItemHandler)destination.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d());
    }

    public IItemHandler getCapabilityDestinationByMode(TileEntity origin, TileEntity destination, EnumFacing facing) {
        return this.getMode() == TransferAddon.ActionMode.PUSH ? (IItemHandler)destination.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d()) : (IItemHandler)origin.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing);
    }
}

