/*
 * Decompiled with CFR 0.152.
 */
package sonar.core;

import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import sonar.core.SonarBlocks;
import sonar.core.SonarCrafting;
import sonar.core.api.SonarAPI;
import sonar.core.api.energy.IItemEnergyHandler;
import sonar.core.api.energy.ITileEnergyHandler;
import sonar.core.api.fluids.ISonarFluidHandler;
import sonar.core.api.nbt.INBTSyncable;
import sonar.core.handlers.energy.DischargeValues;
import sonar.core.handlers.planting.PlantingHandler;
import sonar.core.helpers.ASMLoader;
import sonar.core.helpers.NBTHelper;
import sonar.core.integration.SonarLoader;
import sonar.core.integration.SonarWailaModule;
import sonar.core.network.FlexibleGuiHandler;
import sonar.core.network.PacketByteBuf;
import sonar.core.network.PacketByteBufMultipart;
import sonar.core.network.PacketFlexibleCloseGui;
import sonar.core.network.PacketFlexibleContainer;
import sonar.core.network.PacketFlexibleItemStackChangeGui;
import sonar.core.network.PacketFlexibleMultipartChangeGui;
import sonar.core.network.PacketFlexibleOpenGui;
import sonar.core.network.PacketInvUpdate;
import sonar.core.network.PacketMultipartSync;
import sonar.core.network.PacketRequestMultipartSync;
import sonar.core.network.PacketRequestSync;
import sonar.core.network.PacketSonarSides;
import sonar.core.network.PacketStackUpdate;
import sonar.core.network.PacketTileSync;
import sonar.core.network.PacketTileSyncUpdate;
import sonar.core.network.SonarCommon;
import sonar.core.network.utils.ByteBufWritable;
import sonar.core.network.utils.IByteBufTile;
import sonar.core.upgrades.MachineUpgradeRegistry;

@Mod(modid="sonarcore", name="SonarCore", version="5.0.19", acceptedMinecraftVersions="[1.12,1.12.2]", dependencies="after:mcmultipart;after:ic2;after:mekanism;after:redstoneflux;before:calculator@[5.0.11,);before:practicallogistics2@[3.0.8,);before:fluxnetworks@[3.0.19,);before:bagelsmore@[2.0.1,);")
public class SonarCore {
    @SidedProxy(clientSide="sonar.core.network.SonarClient", serverSide="sonar.core.network.SonarCommon")
    public static SonarCommon proxy;
    @Mod.Instance(value="sonarcore")
    public static SonarCore instance;
    public static List<ISonarFluidHandler> fluidHandlers;
    public static List<ITileEnergyHandler> tileEnergyHandlers;
    public static List<IItemEnergyHandler> itemEnergyHandlers;
    public static SimpleNetworkWrapper network;
    public FlexibleGuiHandler guiHandler = new FlexibleGuiHandler();
    public MachineUpgradeRegistry machine_upgrades = new MachineUpgradeRegistry();
    public PlantingHandler planting_handler = new PlantingHandler();
    public DischargeValues dischargeValues = new DischargeValues();
    public static Logger logger;
    public static Block reinforcedStoneBlock;
    public static Block reinforcedStoneBrick;
    public static Block reinforcedDirtBlock;
    public static Block reinforcedDirtBrick;
    public static Block stableGlass;
    public static Block clearStableGlass;
    public static Block[] stableStone;
    public static Block[] stablestonerimmedBlock;
    public static Block[] stablestonerimmedblackBlock;
    public static Block reinforcedStoneStairs;
    public static Block reinforcedStoneBrickStairs;
    public static Block reinforcedDirtStairs;
    public static Block reinforcedDirtBrickStairs;
    public static Block reinforcedStoneFence;
    public static Block reinforcedStoneBrickFence;
    public static Block reinforcedDirtFence;
    public static Block reinforcedDirtBrickFence;
    public static Block reinforcedStoneGate;
    public static Block reinforcedStoneBrickGate;
    public static Block reinforcedDirtGate;
    public static Block reinforcedDirtBrickGate;
    public static final Random rand;
    public static CreativeTabs tab;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger.info("Initialising API");
        SonarAPI.init();
        logger.info("Initialised API");
        logger.info("Registering Blocks");
        SonarBlocks.registerBlocks();
        logger.info("Loaded Blocks");
        logger.info("Registering Crafting Recipes");
        SonarCrafting.registerCraftingRecipes();
        logger.info("Register Crafting Recipes");
        for (int i = 0; i < 16; ++i) {
            OreDictionary.registerOre((String)"sonarStableStone", (Block)stableStone[i]);
            OreDictionary.registerOre((String)"sonarStableStone", (Block)stablestonerimmedBlock[i]);
            OreDictionary.registerOre((String)"sonarStableStone", (Block)stablestonerimmedblackBlock[i]);
        }
        ASMLoader.load(event.getAsmData());
        proxy.preInit(event);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        logger.info("Checking Loaded Mods");
        SonarLoader.initLoader();
        logger.info("Registering Packets");
        this.registerPackets();
        logger.info("Register Packets");
        if (SonarLoader.wailaLoaded) {
            SonarWailaModule.register();
            logger.info("Integrated with WAILA");
        } else {
            logger.warn("'WAILA' - unavailable or disabled in config");
        }
        logger.info("Registered Events");
        proxy.load(event);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        logger.info("Adding Discharge Values");
        this.dischargeValues.register();
        logger.info("Added " + this.dischargeValues.getRegisterCount() + " Discharge Values");
        for (Map.Entry entry : this.dischargeValues.registry_ni.entrySet()) {
            logger.info("Discharge Values: " + entry.toString());
        }
        logger.info("Registered " + fluidHandlers.size() + " Fluid Providers");
        logger.info("Registered " + tileEnergyHandlers.size() + " Energy Handlers");
        logger.info("Registered " + itemEnergyHandlers.size() + " Energy Container Providers");
        proxy.postLoad(event);
    }

    private void registerPackets() {
        int id = 0;
        if (network == null) {
            network = NetworkRegistry.INSTANCE.newSimpleChannel("Sonar-Packets");
            network.registerMessage(PacketTileSync.Handler.class, PacketTileSync.class, id++, Side.CLIENT);
            network.registerMessage(PacketSonarSides.Handler.class, PacketSonarSides.class, id++, Side.CLIENT);
            network.registerMessage(PacketRequestSync.Handler.class, PacketRequestSync.class, id++, Side.SERVER);
            network.registerMessage(PacketByteBuf.Handler.class, PacketByteBuf.class, id++, Side.CLIENT);
            network.registerMessage(PacketByteBuf.Handler.class, PacketByteBuf.class, id++, Side.SERVER);
            network.registerMessage(PacketStackUpdate.Handler.class, PacketStackUpdate.class, id++, Side.CLIENT);
            network.registerMessage(PacketInvUpdate.Handler.class, PacketInvUpdate.class, id++, Side.CLIENT);
            network.registerMessage(PacketTileSyncUpdate.Handler.class, PacketTileSyncUpdate.class, id++, Side.CLIENT);
            if (SonarLoader.mcmultipartLoaded) {
                network.registerMessage(PacketMultipartSync.Handler.class, PacketMultipartSync.class, id++, Side.CLIENT);
                network.registerMessage(PacketByteBufMultipart.Handler.class, PacketByteBufMultipart.class, id++, Side.CLIENT);
                network.registerMessage(PacketByteBufMultipart.Handler.class, PacketByteBufMultipart.class, id++, Side.SERVER);
                network.registerMessage(PacketRequestMultipartSync.Handler.class, PacketRequestMultipartSync.class, id++, Side.SERVER);
            }
            network.registerMessage(PacketFlexibleOpenGui.Handler.class, PacketFlexibleOpenGui.class, id++, Side.CLIENT);
            network.registerMessage(PacketFlexibleContainer.Handler.class, PacketFlexibleContainer.class, id++, Side.CLIENT);
            network.registerMessage(PacketFlexibleContainer.Handler.class, PacketFlexibleContainer.class, id++, Side.SERVER);
            network.registerMessage(PacketFlexibleCloseGui.Handler.class, PacketFlexibleCloseGui.class, id++, Side.CLIENT);
            network.registerMessage(PacketFlexibleCloseGui.Handler.class, PacketFlexibleCloseGui.class, id++, Side.SERVER);
            network.registerMessage(PacketFlexibleMultipartChangeGui.Handler.class, PacketFlexibleMultipartChangeGui.class, id++, Side.SERVER);
            network.registerMessage(PacketFlexibleItemStackChangeGui.Handler.class, PacketFlexibleItemStackChangeGui.class, id++, Side.SERVER);
        }
    }

    public static void sendPacketAround(TileEntity tile, int spread, int id) {
        if (tile instanceof IByteBufTile) {
            if (!tile.func_145831_w().field_72995_K) {
                network.sendToAllAround((IMessage)new PacketByteBuf((IByteBufTile)tile, tile.func_174877_v(), id, new ByteBufWritable[0]), new NetworkRegistry.TargetPoint(tile.func_145831_w().field_73011_w.getDimension(), (double)tile.func_174877_v().func_177958_n(), (double)tile.func_174877_v().func_177956_o(), (double)tile.func_174877_v().func_177952_p(), (double)spread));
            } else {
                network.sendToServer((IMessage)new PacketByteBuf((IByteBufTile)tile, tile.func_174877_v(), id, new ByteBufWritable[0]));
            }
        }
    }

    public static void sendFullSyncAround(TileEntity tile, int spread) {
        NBTTagCompound tag;
        if (!tile.func_145831_w().field_72995_K && tile instanceof INBTSyncable && !(tag = ((INBTSyncable)tile).writeData(new NBTTagCompound(), NBTHelper.SyncType.SYNC_OVERRIDE)).func_82582_d()) {
            network.sendToAllAround((IMessage)new PacketTileSync(tile.func_174877_v(), tag), new NetworkRegistry.TargetPoint(tile.func_145831_w().field_73011_w.getDimension(), (double)tile.func_174877_v().func_177958_n(), (double)tile.func_174877_v().func_177956_o(), (double)tile.func_174877_v().func_177952_p(), (double)spread));
        }
    }

    public static void sendFullSyncAroundWithRenderUpdate(TileEntity tile, int spread) {
        NBTTagCompound tag;
        if (tile != null && !tile.func_145831_w().field_72995_K && tile instanceof INBTSyncable && !(tag = ((INBTSyncable)tile).writeData(new NBTTagCompound(), NBTHelper.SyncType.SYNC_OVERRIDE)).func_82582_d()) {
            network.sendToAllAround((IMessage)new PacketTileSyncUpdate(tile.func_174877_v(), tag), new NetworkRegistry.TargetPoint(tile.func_145831_w().field_73011_w.getDimension(), (double)tile.func_174877_v().func_177958_n(), (double)tile.func_174877_v().func_177956_o(), (double)tile.func_174877_v().func_177952_p(), (double)spread));
        }
    }

    public static void refreshFlexibleContainer(EntityPlayer player) {
        if (player.func_130014_f_().field_72995_K) {
            network.sendToServer((IMessage)new PacketFlexibleContainer(player));
        } else {
            network.sendTo((IMessage)new PacketFlexibleContainer(player), (EntityPlayerMP)player);
        }
    }

    public static void sendPacketToServer(TileEntity tile, int id) {
        if (tile.func_145831_w().field_72995_K) {
            network.sendToServer((IMessage)new PacketByteBuf((IByteBufTile)tile, tile.func_174877_v(), id, new ByteBufWritable[0]));
        }
    }

    public static int randInt(int min, int max) {
        return rand.nextInt(max - min + 1) + min;
    }

    static {
        logger = LogManager.getLogger((String)"sonarcore");
        stableStone = new Block[16];
        stablestonerimmedBlock = new Block[16];
        stablestonerimmedblackBlock = new Block[16];
        rand = new Random();
        tab = new CreativeTabs("SonarCore"){

            public ItemStack func_78016_d() {
                return new ItemStack(Item.func_150898_a((Block)reinforcedStoneBlock));
            }
        };
    }
}

