/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.block;

import net.malisis.core.block.MalisisBlock;
import net.malisis.core.item.MalisisItemBlock;
import net.malisis.core.registry.MalisisRegistry;
import net.malisis.core.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistryEntry;

public interface IRegisterable<T> {
    public T setRegistryName(String var1);

    public ResourceLocation getRegistryName();

    default public T setName(String name) {
        if (this instanceof IForgeRegistryEntry && name.startsWith("minecraft:")) {
            Utils.silentRegistryName((IForgeRegistryEntry)this, name);
        } else {
            this.setRegistryName(name);
        }
        return (T)this;
    }

    default public ResourceLocation getName() {
        return this.getRegistryName();
    }

    default public Item getItem(Block block) {
        if (this instanceof MalisisBlock) {
            return new MalisisItemBlock((MalisisBlock)block);
        }
        ItemBlock item = new ItemBlock(block);
        ResourceLocation rl = block.getRegistryName();
        if (rl.func_110624_b().equals("minecraft")) {
            Utils.silentRegistryName(item, rl.toString());
        } else {
            item.setRegistryName(block.getRegistryName());
        }
        return item;
    }

    default public void register() {
        MalisisRegistry.register(this);
    }
}

