/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.inventory;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.SubscriberExceptionHandler;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.malisis.core.ExceptionHandler;
import net.malisis.core.MalisisCore;
import net.malisis.core.client.gui.MalisisGui;
import net.malisis.core.inventory.IInventoryProvider;
import net.malisis.core.inventory.InventoryEvent;
import net.malisis.core.inventory.InventoryState;
import net.malisis.core.inventory.MalisisInventoryContainer;
import net.malisis.core.inventory.MalisisSlot;
import net.malisis.core.inventory.message.OpenInventoryMessage;
import net.malisis.core.inventory.player.PlayerInventory;
import net.malisis.core.util.EntityUtils;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class MalisisInventory {
    protected Set<MalisisInventoryContainer> containers = Collections.newSetFromMap(new WeakHashMap());
    protected int inventoryId;
    protected IInventoryProvider inventoryProvider;
    protected ItemStack itemStackProvider;
    protected NonNullList<MalisisSlot> slots = NonNullList.func_191196_a();
    protected String name;
    protected int slotMaxStackSize = 64;
    private EventBus bus = new EventBus((SubscriberExceptionHandler)ExceptionHandler.instance);
    public InventoryState state = new InventoryState();

    public MalisisInventory(IInventoryProvider provider, Supplier<? extends MalisisSlot> supplier, int size) {
        this.inventoryProvider = provider;
        for (int index = 0; index < size; ++index) {
            this.slots.add((Object)supplier.get());
        }
        this.setupSlots();
    }

    public MalisisInventory(IInventoryProvider provider, int size) {
        this(provider, MalisisSlot::new, size);
    }

    public MalisisInventory(IInventoryProvider provider, MalisisSlot ... slots) {
        this.inventoryProvider = provider;
        Arrays.stream(slots).filter(Objects::nonNull).forEach(arg_0 -> this.slots.add(arg_0));
        this.setupSlots();
    }

    private void setupSlots() {
        for (int i = 0; i < this.slots.size(); ++i) {
            ((MalisisSlot)this.slots.get(i)).setup(this, i);
        }
    }

    public IInventoryProvider getProvider() {
        return this.inventoryProvider;
    }

    public void overrideSlot(MalisisSlot slot, int slotIndex) {
        if (slotIndex < 0 || slotIndex >= this.getSize()) {
            return;
        }
        ((MalisisSlot)this.slots.get(slotIndex)).setup(null, -1);
        this.slots.add(slotIndex, (Object)slot);
        slot.setup(this, slotIndex);
    }

    public void register(Object object) {
        this.bus.register(object);
    }

    public void setInventoryId(int id) {
        this.inventoryId = id;
        if (this.itemStackProvider == null) {
            return;
        }
        NBTTagCompound tag = this.itemStackProvider.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
            this.itemStackProvider.func_77982_d(tag);
        }
        this.itemStackProvider.func_77978_p().func_74768_a("inventoryId", id);
    }

    public int getInventoryId() {
        return this.inventoryId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean hasCustomName() {
        return !StringUtils.isEmpty((CharSequence)this.name);
    }

    public MalisisSlot getSlot(int slotIndex) {
        if (slotIndex < 0 || slotIndex >= this.getSize()) {
            return null;
        }
        return (MalisisSlot)this.slots.get(slotIndex);
    }

    public List<MalisisSlot> getSlots() {
        return this.slots;
    }

    public List<MalisisSlot> getNonEmptySlots() {
        return this.getSlots().stream().filter(MalisisSlot::isNotEmpty).collect(Collectors.toList());
    }

    public ItemStack getItemStack(int slotNumber) {
        MalisisSlot slot = this.getSlot(slotNumber);
        return slot != null ? slot.getItemStack() : ItemStack.field_190927_a;
    }

    public void setItemStack(int slotNumber, ItemStack itemStack) {
        MalisisSlot slot = this.getSlot(slotNumber);
        if (slot == null) {
            return;
        }
        if (itemStack.func_190926_b()) {
            itemStack = ItemStack.field_190927_a;
        } else {
            int max = Math.min(slot.getSlotStackLimit(), itemStack.func_77976_d());
            itemStack.func_190920_e(Math.min(itemStack.func_190916_E(), max));
        }
        if (ItemStack.func_77989_b((ItemStack)itemStack, (ItemStack)slot.getItemStack())) {
            return;
        }
        slot.setItemStack(itemStack);
        slot.onSlotChanged();
    }

    public NonNullList<ItemStack> getItemStackList() {
        return this.getSlots().stream().filter(MalisisSlot::isNotEmpty).map(MalisisSlot::getItemStack).collect(Collectors.toCollection(NonNullList::func_191196_a));
    }

    public boolean itemValidForSlot(MalisisSlot slot, ItemStack itemStack) {
        return true;
    }

    public boolean isItemValidForSlot(int slotNumber, ItemStack itemStack) {
        MalisisSlot slot = this.getSlot(slotNumber);
        if (slot == null) {
            return false;
        }
        return slot.isItemValid(itemStack);
    }

    public int getSize() {
        return this.getSlots().size();
    }

    public int getInventoryStackLimit() {
        return this.slotMaxStackSize;
    }

    public void setInventoryStackLimit(int limit) {
        this.slotMaxStackSize = limit;
    }

    public void setItemStackProvider(ItemStack itemStack) {
        if (!(this.inventoryProvider instanceof Item)) {
            throw new IllegalArgumentException("setItemStack not allowed with " + this.inventoryProvider.getClass().getSimpleName() + " provider.");
        }
        if (itemStack.func_77973_b() != this.inventoryProvider) {
            MalisisCore.log.error("[MalisisInventory] Tried to set itemStack with an different item (" + itemStack.func_77973_b() + ") than the provider (" + this.inventoryProvider + ")");
            return;
        }
        this.itemStackProvider = itemStack;
        this.readFromNBT(itemStack.func_77978_p());
    }

    public void addOpenedContainer(MalisisInventoryContainer container) {
        this.containers.add(container);
    }

    public void removeOpenedContainer(MalisisInventoryContainer container) {
        this.containers.remove((Object)container);
        if (this.containers.size() == 0 && this.itemStackProvider != null && this.itemStackProvider.func_77978_p() != null) {
            this.itemStackProvider.func_77978_p().func_82580_o("inventoryId");
        }
    }

    public Set<MalisisInventoryContainer> getOpenedContainers() {
        return this.containers;
    }

    public boolean isEmpty() {
        return this.getItemStackList().size() == 0;
    }

    public boolean isFull() {
        return !this.getSlots().stream().anyMatch(MalisisSlot::isNotFull);
    }

    public void onSlotChanged(MalisisSlot slot) {
        if (this.inventoryProvider instanceof Item && this.itemStackProvider != null) {
            this.writeToNBT(this.itemStackProvider.func_77978_p());
        }
        this.bus.post((Object)new InventoryEvent.SlotChanged(this, slot));
    }

    public Optional<MalisisSlot> getFirstOccupiedSlot() {
        return this.getSlots().stream().filter(MalisisSlot::isNotEmpty).findFirst();
    }

    public ItemStack pullItemStack() {
        return this.getFirstOccupiedSlot().map(MalisisSlot::extract).get();
    }

    public boolean pullItemStacks(ItemStack itemStack, boolean ignoreFullStacks) {
        for (MalisisSlot s : this.getNonEmptySlots()) {
            ItemStack is = s.getItemStack();
            if (ignoreFullStacks && is.func_190916_E() >= is.func_77976_d() || !s.extractInto(itemStack)) continue;
            return true;
        }
        return false;
    }

    public void transfer(MalisisInventory inventory) {
        for (MalisisSlot s : inventory.getNonEmptySlots()) {
            ItemStack itemStack = this.transferInto(s.getItemStack());
            s.setItemStack(itemStack);
            s.onSlotChanged();
            if (itemStack.func_190926_b()) continue;
            return;
        }
    }

    public ItemStack transferInto(ItemStack itemStack) {
        return this.transferInto(itemStack, false);
    }

    public ItemStack transferInto(ItemStack itemStack, boolean reversed) {
        int end;
        int start = reversed ? this.getSlots().size() - 1 : 0;
        if ((itemStack = this.transferInto(itemStack, false, start, end = reversed ? 0 : this.getSlots().size() - 1)) != null) {
            itemStack = this.transferInto(itemStack, true, start, end);
        }
        return itemStack;
    }

    protected ItemStack transferInto(ItemStack itemStack, boolean emptySlot, int start, int end) {
        int current = start;
        int step = 1;
        if (start > end) {
            step = -1;
            start = end;
            end = current;
        }
        while (!itemStack.func_190926_b() && current >= start && current <= end) {
            MalisisSlot slot = this.getSlot(current);
            if (slot.isItemValid(itemStack) && !slot.isOutputSlot() && (emptySlot || !slot.getItemStack().func_190926_b())) {
                itemStack = slot.insert(itemStack);
            }
            current += step;
        }
        return itemStack;
    }

    public void breakInventory(World world, BlockPos pos) {
        for (ItemStack itemStack : this.getItemStackList()) {
            EntityUtils.spawnEjectedItem(world, pos, itemStack);
        }
        this.closeContainers();
        this.emptyInventory();
    }

    public void emptyInventory() {
        for (MalisisSlot slot : this.slots) {
            slot.setItemStack(ItemStack.field_190927_a);
        }
    }

    public void closeContainers() {
        for (MalisisInventoryContainer container : this.containers) {
            container.close();
        }
    }

    public void readFromNBT(NBTTagCompound tagCompound) {
        if (tagCompound == null) {
            return;
        }
        NBTTagList nbttaglist = tagCompound.func_150295_c("Items", 10);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound stackTag = nbttaglist.func_150305_b(i);
            int slotNumber = stackTag.func_74771_c("Slot") & 0xFF;
            MalisisSlot slot = this.getSlot(slotNumber);
            if (slot == null) continue;
            slot.setItemStack(new ItemStack(stackTag));
        }
    }

    public void writeToNBT(NBTTagCompound tagCompound) {
        if (tagCompound == null) {
            return;
        }
        NBTTagList itemList = new NBTTagList();
        this.getNonEmptySlots().forEach(slot -> {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("Slot", (byte)slot.getSlotIndex());
            slot.getItemStack().func_77955_b(tag);
            itemList.func_74742_a((NBTBase)tag);
        });
        tagCompound.func_74782_a("Items", (NBTBase)itemList);
    }

    public String toString() {
        String provider = "Player";
        if (!(this instanceof PlayerInventory)) {
            provider = this.inventoryProvider != null ? this.inventoryProvider.getClass().getSimpleName() : "null\t";
        }
        return (this.name != null ? this.name : this.getClass().getSimpleName()) + " (" + this.inventoryId + ") from " + provider;
    }

    public static MalisisInventoryContainer open(EntityPlayerMP player, IInventoryProvider.IDirectInventoryProvider inventoryProvider) {
        if (inventoryProvider == null) {
            return null;
        }
        return MalisisInventory.openInventories((EntityPlayer)player, inventoryProvider, inventoryProvider.getInventories(), 0);
    }

    public static <T> MalisisInventoryContainer open(EntityPlayerMP player, IInventoryProvider.IDeferredInventoryProvider<T> inventoryProvider, T data) {
        if (inventoryProvider == null) {
            return null;
        }
        return MalisisInventory.openInventories((EntityPlayer)player, inventoryProvider, inventoryProvider.getInventories(data), 0);
    }

    @SideOnly(value=Side.CLIENT)
    public static MalisisInventoryContainer open(EntityPlayerSP player, IInventoryProvider.IDirectInventoryProvider inventoryProvider, int windowId) {
        if (inventoryProvider == null) {
            return null;
        }
        MalisisInventoryContainer c = MalisisInventory.openInventories((EntityPlayer)player, inventoryProvider, inventoryProvider.getInventories(), windowId);
        MalisisGui gui = inventoryProvider.getGui(c);
        if (gui != null) {
            gui.display();
        }
        return c;
    }

    @SideOnly(value=Side.CLIENT)
    public static <T> MalisisInventoryContainer open(EntityPlayerSP player, IInventoryProvider.IDeferredInventoryProvider<T> inventoryProvider, T data, int windowId) {
        if (inventoryProvider == null) {
            return null;
        }
        MalisisInventoryContainer c = MalisisInventory.openInventories((EntityPlayer)player, inventoryProvider, inventoryProvider.getInventories(data), windowId);
        MalisisGui gui = inventoryProvider.getGui(data, c);
        if (gui != null) {
            gui.display();
        }
        return c;
    }

    private static MalisisInventoryContainer openInventories(EntityPlayer player, IInventoryProvider inventoryProvider, MalisisInventory[] inventories, int windowId) {
        MalisisInventoryContainer c = new MalisisInventoryContainer(player, windowId);
        if (!ArrayUtils.isEmpty((Object[])inventories)) {
            Arrays.stream(inventories).filter(Objects::nonNull).forEach(inv -> {
                c.addInventory((MalisisInventory)inv);
                inv.bus.post((Object)new InventoryEvent.Open(c, (MalisisInventory)inv));
            });
        }
        if (player instanceof EntityPlayerMP) {
            OpenInventoryMessage.send(inventoryProvider, (EntityPlayerMP)player, c.field_75152_c);
            c.sendInventoryContent();
        }
        return c;
    }
}

