/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.core;

import java.util.Collections;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import net.minecraft.advancements.FrameType;
import net.minecraft.item.ItemStack;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import stevekung.mods.moreplanets.core.capability.CapabilityHandlerMP;
import stevekung.mods.moreplanets.core.config.ConfigManagerMP;
import stevekung.mods.moreplanets.core.event.ClientEventHandler;
import stevekung.mods.moreplanets.core.event.EntityEventHandler;
import stevekung.mods.moreplanets.core.event.GeneralEventHandler;
import stevekung.mods.moreplanets.core.event.WorldTickEventHandler;
import stevekung.mods.moreplanets.core.handler.DataFixersMP;
import stevekung.mods.moreplanets.core.handler.GuiHandlerMP;
import stevekung.mods.moreplanets.core.handler.MissingMappingHandler;
import stevekung.mods.moreplanets.init.MPBiomes;
import stevekung.mods.moreplanets.init.MPBlocks;
import stevekung.mods.moreplanets.init.MPDimensions;
import stevekung.mods.moreplanets.init.MPEntities;
import stevekung.mods.moreplanets.init.MPItems;
import stevekung.mods.moreplanets.init.MPOreDictionary;
import stevekung.mods.moreplanets.init.MPOthers;
import stevekung.mods.moreplanets.init.MPPlanets;
import stevekung.mods.moreplanets.init.MPPotions;
import stevekung.mods.moreplanets.init.MPSchematics;
import stevekung.mods.moreplanets.init.MPSounds;
import stevekung.mods.moreplanets.init.MPTileEntities;
import stevekung.mods.moreplanets.network.PacketSimpleMP;
import stevekung.mods.moreplanets.proxy.ServerProxyMP;
import stevekung.mods.moreplanets.recipe.CraftingManagerMP;
import stevekung.mods.moreplanets.recipe.SmeltingManagerMP;
import stevekung.mods.moreplanets.utils.BlocksItemsRegistry;
import stevekung.mods.moreplanets.utils.CompatibilityManagerMP;
import stevekung.mods.moreplanets.utils.CreativeTabsMP;
import stevekung.mods.moreplanets.utils.LoggerMP;
import stevekung.mods.moreplanets.utils.SchematicsRegistry;
import stevekung.mods.stevekunglib.utils.CommonRegistryUtils;
import stevekung.mods.stevekunglib.utils.CommonUtils;
import stevekung.mods.stevekunglib.utils.VersionChecker;
import stevekung.mods.stevekunglib.utils.client.ClientRegistryUtils;
import stevekung.mods.stevekunglib.utils.client.ClientUtils;

@Mod(modid="moreplanets", name="More Planets", version="2.1.10", dependencies="required-after:stevekung's_lib@[1.1.5,); required-after:galacticraftcore@[4.0.2.238,); required-after:galacticraftplanets@[4.0.2.238,); required-after:micdoodlecore; after:forge@[14.23.5.2847,); after:jei@[4.15.0.268,); ", updateJSON="https://raw.githubusercontent.com/SteveKunG/VersionCheckLibrary/master/more_planets_version.json", certificateFingerprint="b3468b224a74e296555ad7efeb35f482e6f445de", acceptedMinecraftVersions="[1.12.2]")
public class MorePlanetsMod {
    public static final String NAME = "More Planets";
    public static final String MOD_ID = "moreplanets";
    private static final int MAJOR_VERSION = 2;
    private static final int MINOR_VERSION = 1;
    private static final int BUILD_VERSION = 10;
    public static final String VERSION = "2.1.10";
    private static final String FORGE_VERSION = "after:forge@[14.23.5.2847,); ";
    private static final String DEPENDENCIES = "after:jei@[4.15.0.268,); ";
    protected static final String MAIN_DEPENDENCIES = "required-after:stevekung's_lib@[1.1.5,); required-after:galacticraftcore@[4.0.2.238,); required-after:galacticraftplanets@[4.0.2.238,); required-after:micdoodlecore; after:forge@[14.23.5.2847,); after:jei@[4.15.0.268,); ";
    protected static final String CERTIFICATE = "b3468b224a74e296555ad7efeb35f482e6f445de";
    public static final String URL = "https://minecraft.curseforge.com/projects/galacticraft-add-on-more-planets";
    protected static final String JSON_URL = "https://raw.githubusercontent.com/SteveKunG/VersionCheckLibrary/master/more_planets_version.json";
    public static boolean isDevelopment;
    @SidedProxy(clientSide="stevekung.mods.moreplanets.proxy.ClientProxyMP", serverSide="stevekung.mods.moreplanets.proxy.ServerProxyMP")
    public static ServerProxyMP PROXY;
    @Mod.Instance(value="moreplanets")
    public static MorePlanetsMod INSTANCE;
    public static VersionChecker CHECKER;
    public static final CreativeTabsMP BLOCK_TAB;
    public static final CreativeTabsMP ITEM_TAB;
    public static ClientRegistryUtils CLIENT_REGISTRY;
    public static final CommonRegistryUtils COMMON_REGISTRY;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        CompatibilityManagerMP.init();
        MorePlanetsMod.initModInfo(event.getModMetadata());
        CommonUtils.registerEventHandler((Object)this);
        CapabilityHandlerMP.register();
        MPBlocks.init();
        MPItems.init();
        MPEntities.init();
        MPPlanets.init();
        MPPotions.init();
        MPBiomes.init();
        MPOthers.init();
        MPPlanets.register();
        PROXY.preInit(event);
        CHECKER = new VersionChecker((Object)INSTANCE, NAME, URL);
        if (ConfigManagerMP.moreplanets_general.enableVersionChecker) {
            CHECKER.startCheck();
        }
        EnumHelper.addEnum(FrameType.class, (String)"TASK_PURPLE", (Class[])new Class[]{String.class, Integer.TYPE, TextFormatting.class}, (Object[])new Object[]{"task_purple", 0, TextFormatting.DARK_PURPLE});
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        MPTileEntities.init();
        MPOreDictionary.init();
        DataFixersMP.init();
        GalacticraftCore.packetPipeline.addDiscriminator(1999, PacketSimpleMP.class);
        BLOCK_TAB.setDisplayItemStack(new ItemStack(MPBlocks.CRASHED_ALIEN_PROBE));
        ITEM_TAB.setDisplayItemStack(new ItemStack(MPItems.SPACE_WARPER_CORE));
        PROXY.init(event);
        if (ClientUtils.isClient()) {
            BlocksItemsRegistry.postRegisteredSortBlock();
            BlocksItemsRegistry.postRegisteredSortItem();
            CommonUtils.registerEventHandler((Object)new ClientEventHandler());
        }
        CommonUtils.registerEventHandler((Object)new EntityEventHandler());
        CommonUtils.registerEventHandler((Object)new GeneralEventHandler());
        CommonUtils.registerEventHandler((Object)new WorldTickEventHandler());
        CommonUtils.registerEventHandler((Object)new MissingMappingHandler());
        SchematicsRegistry.registerSchematicDungeonLoot(4, new ItemStack(MPItems.BLACK_HOLE_STORAGE_SCHEMATIC));
        SchematicsRegistry.registerSchematicDungeonLoot(4, new ItemStack(MPItems.ION_CANNON_SCHEMATIC));
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        PROXY.postInit(event);
        CommonUtils.registerGuiHandler((Object)this, (IGuiHandler)new GuiHandlerMP());
        CraftingManagerMP.init();
        SmeltingManagerMP.init();
        MPSchematics.init();
        MPDimensions.init();
    }

    @Mod.EventHandler
    public void serverAboutToStart(FMLServerAboutToStartEvent event) {
        WorldTickEventHandler.survivalPlanetData = null;
    }

    @Mod.EventHandler
    public void onFingerprintViolation(FMLFingerprintViolationEvent event) {
        if (!isDevelopment) {
            throw new RuntimeException("Invalid fingerprint detected! This version will NOT be supported by the author!");
        }
        LoggerMP.info("Development environment detected! Ignore certificate check.");
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals(MOD_ID)) {
            ConfigManager.sync((String)MOD_ID, (Config.Type)Config.Type.INSTANCE);
        }
    }

    @SubscribeEvent
    public void onBiomeRegister(RegistryEvent.Register<Biome> event) {
        MPBiomes.registerTypes();
    }

    @SubscribeEvent
    public void onSoundRegister(RegistryEvent.Register<SoundEvent> event) {
        LoggerMP.info("Initialize sounds from {}", MPSounds.class);
    }

    private static void initModInfo(ModMetadata info) {
        info.autogenerated = false;
        info.modId = MOD_ID;
        info.name = NAME;
        info.version = VERSION;
        info.description = "An add-on exploration with custom planets for Galacticraft!";
        info.url = URL;
        info.credits = "All credits to Galacticraft Sources/API and some people who helped.";
        info.authorList = Collections.singletonList("SteveKunG");
    }

    static {
        BLOCK_TAB = new CreativeTabsMP("more_planets_blocks");
        ITEM_TAB = new CreativeTabsMP("more_planets_items");
        COMMON_REGISTRY = new CommonRegistryUtils(MOD_ID);
        FluidRegistry.enableUniversalBucket();
        try {
            isDevelopment = Launch.classLoader.getClassBytes("net.minecraft.world.World") != null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (ClientUtils.isClient()) {
            CLIENT_REGISTRY = new ClientRegistryUtils(MOD_ID);
        }
    }
}

