/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.moons.koentus.blocks;

import java.util.Random;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import stevekung.mods.moreplanets.core.MorePlanetsMod;
import stevekung.mods.moreplanets.entity.EntityAntiGravFallingBlock;
import stevekung.mods.moreplanets.init.MPBlocks;
import stevekung.mods.moreplanets.moons.koentus.tileentity.TileEntityGravityExtractor;
import stevekung.mods.moreplanets.utils.CompatibilityManagerMP;
import stevekung.mods.moreplanets.utils.EnumParticleTypesMP;
import stevekung.mods.moreplanets.utils.blocks.BlockFallingMP;
import stevekung.mods.moreplanets.utils.itemblocks.IItemRarity;
import stevekung.mods.stevekunglib.utils.ColorUtils;

public class BlockCreep
extends BlockFallingMP
implements ITileEntityProvider,
IItemRarity {
    private final BlockType type;

    public BlockCreep(String name, BlockType type) {
        super(name, Material.field_151571_B);
        this.setSoundType(SoundType.field_185859_l);
        this.func_149711_c(0.6f);
        this.type = type;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.field_72995_K) {
            if (this.type == BlockType.CREEP_BLOCK) {
                this.checkFallable(world, pos);
            } else if (this.type == BlockType.GRAVITY_CREEP_BLOCK || this.type == BlockType.GRAVITY_CREEP_EXTRACTOR) {
                this.checkFloatable(world, pos);
            }
        }
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return this.type != BlockType.CREEP_BLOCK && CompatibilityManagerMP.isCTMLoaded ? layer == BlockRenderLayer.CUTOUT : super.canRenderInLayer(state, layer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int func_189876_x(IBlockState state) {
        Random rand = RANDOM;
        return this.type == BlockType.CREEP_BLOCK ? ColorUtils.rgbToDecimal((int)136, (int)70, (int)93) : (this.type == BlockType.GRAVITY_CREEP_BLOCK || this.type == BlockType.GRAVITY_CREEP_EXTRACTOR ? (rand.nextInt(3) == 0 ? ColorUtils.rgbToDecimal((int)88, (int)88, (int)88) : (rand.nextInt(2) == 0 ? ColorUtils.rgbToDecimal((int)206, (int)105, (int)10) : ColorUtils.rgbToDecimal((int)16, (int)136, (int)207))) : super.func_189876_x(state));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        super.func_180655_c(state, world, pos, rand);
        if (this.type == BlockType.GRAVITY_CREEP_EXTRACTOR) {
            double z;
            double x;
            int i;
            if (!world.func_180495_p(pos.func_177984_a()).isSideSolid((IBlockAccess)world, pos.func_177984_a(), EnumFacing.UP)) {
                for (i = 0; i < 8; ++i) {
                    x = (double)pos.func_177958_n() + rand.nextDouble();
                    z = (double)pos.func_177952_p() + rand.nextDouble();
                    MorePlanetsMod.PROXY.spawnParticle(EnumParticleTypesMP.GRAVITY_HARVESTER, x, pos.func_177956_o(), z, new Object[]{true});
                }
            }
            if (!world.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)world, pos.func_177977_b(), EnumFacing.DOWN)) {
                for (i = 0; i < 8; ++i) {
                    x = (double)pos.func_177958_n() + rand.nextDouble();
                    z = (double)pos.func_177952_p() + rand.nextDouble();
                    MorePlanetsMod.PROXY.spawnParticle(EnumParticleTypesMP.GRAVITY_HARVESTER, x, pos.func_177956_o() - 1, z, new Object[]{false});
                }
            }
        }
    }

    public TileEntity func_149915_a(World world, int meta) {
        return this.type == BlockType.GRAVITY_CREEP_EXTRACTOR ? new TileEntityGravityExtractor() : null;
    }

    public boolean hasTileEntity(IBlockState state) {
        return this.type == BlockType.GRAVITY_CREEP_EXTRACTOR;
    }

    @Override
    public ColorUtils.RGB getRarity() {
        return ColorUtils.stringToRGB((String)"178, 109, 237");
    }

    private void checkFallable(World world, BlockPos pos) {
        boolean up;
        boolean north = world.func_180495_p(pos.func_177978_c()).func_177230_c() != MPBlocks.GRAVITY_CREEP_BLOCK && world.func_180495_p(pos.func_177978_c()).func_177230_c() != MPBlocks.GRAVITY_CREEP_EXTRACTOR;
        boolean east = world.func_180495_p(pos.func_177974_f()).func_177230_c() != MPBlocks.GRAVITY_CREEP_BLOCK && world.func_180495_p(pos.func_177974_f()).func_177230_c() != MPBlocks.GRAVITY_CREEP_EXTRACTOR;
        boolean south = world.func_180495_p(pos.func_177968_d()).func_177230_c() != MPBlocks.GRAVITY_CREEP_BLOCK && world.func_180495_p(pos.func_177968_d()).func_177230_c() != MPBlocks.GRAVITY_CREEP_EXTRACTOR;
        boolean west = world.func_180495_p(pos.func_177976_e()).func_177230_c() != MPBlocks.GRAVITY_CREEP_BLOCK && world.func_180495_p(pos.func_177976_e()).func_177230_c() != MPBlocks.GRAVITY_CREEP_EXTRACTOR;
        boolean bl = up = world.func_180495_p(pos.func_177984_a()).func_177230_c() != MPBlocks.GRAVITY_CREEP_BLOCK && world.func_180495_p(pos.func_177984_a()).func_177230_c() != MPBlocks.GRAVITY_CREEP_EXTRACTOR;
        if ((world.func_175623_d(pos.func_177977_b()) || world.func_180495_p(pos.func_177977_b()).func_177230_c() == MPBlocks.GRAVITY_CREEP_VINES || BlockFalling.func_185759_i((IBlockState)world.func_180495_p(pos.func_177977_b()))) && north && east && south && west && up && pos.func_177956_o() >= 0) {
            if (!field_149832_M && world.func_175707_a(pos.func_177982_a(-32, -32, -32), pos.func_177982_a(32, 32, 32))) {
                if (!world.field_72995_K) {
                    EntityFallingBlock block = new EntityFallingBlock(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, world.func_180495_p(pos));
                    this.func_149829_a(block);
                    world.func_72838_d((Entity)block);
                }
            } else {
                IBlockState state = world.func_180495_p(pos);
                world.func_175698_g(pos);
                BlockPos blockpos = pos.func_177977_b();
                while ((world.func_175623_d(blockpos) || world.func_180495_p(blockpos.func_177977_b()).func_177230_c() == MPBlocks.GRAVITY_CREEP_VINES || BlockFalling.func_185759_i((IBlockState)world.func_180495_p(blockpos))) && world.func_180495_p(blockpos.func_177978_c()).func_177230_c() != MPBlocks.GRAVITY_CREEP_BLOCK && world.func_180495_p(blockpos.func_177974_f()).func_177230_c() != MPBlocks.GRAVITY_CREEP_BLOCK && world.func_180495_p(blockpos.func_177968_d()).func_177230_c() != MPBlocks.GRAVITY_CREEP_BLOCK && world.func_180495_p(blockpos.func_177976_e()).func_177230_c() != MPBlocks.GRAVITY_CREEP_BLOCK && world.func_180495_p(blockpos.func_177984_a()).func_177230_c() != MPBlocks.GRAVITY_CREEP_BLOCK && world.func_180495_p(blockpos.func_177978_c()).func_177230_c() != MPBlocks.GRAVITY_CREEP_EXTRACTOR && world.func_180495_p(blockpos.func_177974_f()).func_177230_c() != MPBlocks.GRAVITY_CREEP_EXTRACTOR && world.func_180495_p(blockpos.func_177968_d()).func_177230_c() != MPBlocks.GRAVITY_CREEP_EXTRACTOR && world.func_180495_p(blockpos.func_177976_e()).func_177230_c() != MPBlocks.GRAVITY_CREEP_EXTRACTOR && world.func_180495_p(blockpos.func_177984_a()).func_177230_c() != MPBlocks.GRAVITY_CREEP_EXTRACTOR && blockpos.func_177956_o() > 0) {
                    blockpos = blockpos.func_177977_b();
                }
                if (blockpos.func_177956_o() > 0) {
                    world.func_175656_a(blockpos.func_177984_a(), state);
                }
            }
        }
    }

    private void checkFloatable(World world, BlockPos pos) {
        boolean down;
        boolean north = world.func_180495_p(pos.func_177978_c()).func_177230_c() != MPBlocks.CREEP_BLOCK;
        boolean east = world.func_180495_p(pos.func_177974_f()).func_177230_c() != MPBlocks.CREEP_BLOCK;
        boolean south = world.func_180495_p(pos.func_177968_d()).func_177230_c() != MPBlocks.CREEP_BLOCK;
        boolean west = world.func_180495_p(pos.func_177976_e()).func_177230_c() != MPBlocks.CREEP_BLOCK;
        boolean bl = down = world.func_180495_p(pos.func_177977_b()).func_177230_c() != MPBlocks.CREEP_BLOCK;
        if ((world.func_175623_d(pos.func_177984_a()) || BlockFalling.func_185759_i((IBlockState)world.func_180495_p(pos.func_177984_a()))) && north && east && south && west && down && pos.func_177956_o() < 256) {
            if (!BlockFalling.field_149832_M && world.func_175707_a(pos.func_177982_a(-32, -32, -32), pos.func_177982_a(32, 32, 32))) {
                if (!world.field_72995_K) {
                    EntityAntiGravFallingBlock block = new EntityAntiGravFallingBlock(world, (double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, world.func_180495_p(pos));
                    world.func_72838_d((Entity)block);
                }
            } else {
                IBlockState state = world.func_180495_p(pos);
                world.func_175698_g(pos);
                BlockPos blockpos = pos.func_177984_a();
                while ((world.func_175623_d(blockpos) || BlockFalling.func_185759_i((IBlockState)world.func_180495_p(blockpos))) && world.func_180495_p(blockpos.func_177978_c()).func_177230_c() != MPBlocks.CREEP_BLOCK && world.func_180495_p(blockpos.func_177974_f()).func_177230_c() != MPBlocks.CREEP_BLOCK && world.func_180495_p(blockpos.func_177968_d()).func_177230_c() != MPBlocks.CREEP_BLOCK && world.func_180495_p(blockpos.func_177976_e()).func_177230_c() != MPBlocks.CREEP_BLOCK && world.func_180495_p(blockpos.func_177977_b()).func_177230_c() != MPBlocks.CREEP_BLOCK && blockpos.func_177956_o() > 0) {
                    blockpos = blockpos.func_177984_a();
                }
                if (blockpos.func_177956_o() < 256) {
                    world.func_175656_a(blockpos.func_177984_a(), state);
                }
            }
        }
    }

    public static enum BlockType {
        CREEP_BLOCK,
        GRAVITY_CREEP_BLOCK,
        GRAVITY_CREEP_EXTRACTOR;

    }
}

