/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.network;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.network.IPacket;
import micdoodle8.mods.galacticraft.core.network.NetworkUtil;
import micdoodle8.mods.galacticraft.core.network.PacketBase;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.PlayerUtil;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.item.ItemRecord;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import stevekung.mods.moreplanets.client.gui.GuiCelestialSelection;
import stevekung.mods.moreplanets.client.gui.GuiShieldGenerator;
import stevekung.mods.moreplanets.client.gui.GuiShieldGeneratorConfig;
import stevekung.mods.moreplanets.core.event.ClientEventHandler;
import stevekung.mods.moreplanets.core.event.WorldTickEventHandler;
import stevekung.mods.moreplanets.init.MPItems;
import stevekung.mods.moreplanets.init.MPSounds;
import stevekung.mods.moreplanets.inventory.ContainerShieldGeneratorConfig;
import stevekung.mods.moreplanets.tileentity.TileEntityBlackHoleStorage;
import stevekung.mods.moreplanets.tileentity.TileEntityShieldGenerator;
import stevekung.mods.moreplanets.utils.LoggerMP;
import stevekung.mods.moreplanets.utils.TeleportUtils;
import stevekung.mods.stevekunglib.utils.JsonUtils;
import stevekung.mods.stevekunglib.utils.LangUtils;

public class PacketSimpleMP
extends PacketBase {
    private EnumSimplePacketMP type;
    private List<Object> data;

    public PacketSimpleMP() {
    }

    public PacketSimpleMP(EnumSimplePacketMP packetType, int dimID, Object ... dataList) {
        super(dimID);
        List<Object> data = Arrays.asList(dataList);
        if (packetType.getDecodeClasses().length != data.size()) {
            LoggerMP.warning("More Planets Simple Packet found data length different than packet type: {}", packetType.name());
        }
        this.type = packetType;
        this.data = data;
    }

    public void encodeInto(ByteBuf buffer) {
        super.encodeInto(buffer);
        buffer.writeInt(this.type.ordinal());
        try {
            NetworkUtil.encodeData((ByteBuf)buffer, this.data);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void decodeInto(ByteBuf buffer) {
        super.decodeInto(buffer);
        this.type = EnumSimplePacketMP.values[buffer.readInt()];
        if (this.type.getDecodeClasses().length > 0) {
            this.data = NetworkUtil.decodeData((Class[])this.type.getDecodeClasses(), (ByteBuf)buffer);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void handleClientSide(EntityPlayer player) {
        switch (this.type) {
            case C_REMOVE_GUIDE_POS: {
                BlockPos pos = (BlockPos)this.data.get(0);
                ClientEventHandler.RECEIVER_RENDER_POS.remove(pos);
                break;
            }
            case C_RELOAD_RENDERER: {
                FMLClientHandler.instance().getClient().field_71438_f.func_72712_a();
                break;
            }
            case C_SWITCH_SHIELD_GENERATOR_GUI: {
                BlockPos pos = (BlockPos)this.data.get(0);
                boolean isConfig = (Boolean)this.data.get(2);
                if (pos == null) break;
                TileEntity tile = player.field_70170_p.func_175625_s(pos);
                if (tile != null && tile instanceof TileEntityShieldGenerator) {
                    FMLClientHandler.instance().getClient().func_147108_a((GuiScreen)(isConfig ? new GuiShieldGeneratorConfig(player.field_71071_by, (TileEntityShieldGenerator)tile) : new GuiShieldGenerator(player.field_71071_by, (TileEntityShieldGenerator)tile)));
                }
                player.field_71070_bA.field_75152_c = (Integer)this.data.get(1);
                break;
            }
            case C_REMOVE_GENERATOR_GUIDE_POS: {
                BlockPos pos = (BlockPos)this.data.get(0);
                ClientEventHandler.WASTE_RENDER_POS.remove(pos);
                break;
            }
            case C_OPEN_SURVIVAL_PLANET_GUI: {
                GuiCelestialSelection gui = new GuiCelestialSelection();
                FMLClientHandler.instance().getClient().func_147108_a((GuiScreen)gui);
                break;
            }
            case C_MESSAGE_SURVIVAL_PLANET: {
                String name = (String)this.data.get(0);
                player.func_145747_a((ITextComponent)JsonUtils.create((String)("You select " + TextFormatting.AQUA + name + TextFormatting.RESET + " as survival planet, Good Luck!")));
                break;
            }
            case C_PLAY_VEIN_FLOATER_MUSIC: {
                FMLClientHandler.instance().getClient().func_147118_V().func_147682_a((ISound)new PositionedSoundRecord(MPSounds.A_PLANET_TO_CONQUER.getRegistryName(), SoundCategory.PLAYERS, 1.0f, 1.0f, false, 0, ISound.AttenuationType.NONE, 0.0f, 0.0f, 0.0f));
                FMLClientHandler.instance().getClient().field_71456_v.func_73833_a(((ItemRecord)MPItems.VEIN_FLOATER_DISC).func_150927_i());
                break;
            }
            case C_STOP_VEIN_FLOATER_MUSIC: {
                FMLClientHandler.instance().getClient().func_147118_V().func_189520_a(MPSounds.A_PLANET_TO_CONQUER.getRegistryName().toString(), SoundCategory.PLAYERS);
                break;
            }
            case C_PLAY_CREATED_BLACK_HOLE_SOUND: {
                player.func_184185_a(MPSounds.BLACK_HOLE_CREATED, 5.0f, 0.8f);
                player.func_184185_a(MPSounds.BLACK_HOLE_AMBIENT, 5.0f, 1.0f);
                break;
            }
        }
    }

    public void handleServerSide(EntityPlayer player) {
        EntityPlayerMP playerMP = PlayerUtil.getPlayerBaseServerFromPlayer((EntityPlayer)player, (boolean)false);
        GCPlayerStats stats = GCPlayerStats.get((Entity)playerMP);
        World world = player.field_70170_p;
        switch (this.type) {
            case S_BLACK_HOLE_STORAGE_OPTION: {
                TileEntity tile = world.func_175625_s((BlockPos)this.data.get(0));
                String type = (String)this.data.get(1);
                if (!(tile instanceof TileEntityBlackHoleStorage)) break;
                TileEntityBlackHoleStorage storage = (TileEntityBlackHoleStorage)tile;
                switch (type) {
                    case "disable": {
                        storage.disableBlackHole = !storage.disableBlackHole;
                        break;
                    }
                    case "collect_mode": {
                        ++storage.modeInt;
                        storage.modeInt %= 3;
                        switch (storage.modeInt) {
                            case 0: {
                                storage.collectMode = "item";
                                break;
                            }
                            case 1: {
                                storage.collectMode = "xp";
                                break;
                            }
                            case 2: {
                                storage.collectMode = "item_and_xp";
                            }
                        }
                        break;
                    }
                    case "use_hopper": {
                        storage.useHopper = !storage.useHopper;
                    }
                }
                break;
            }
            case S_SHIELD_VISIBLE: {
                TileEntity tile = world.func_175625_s((BlockPos)this.data.get(0));
                if (!(tile instanceof TileEntityShieldGenerator)) break;
                TileEntityShieldGenerator shield = (TileEntityShieldGenerator)tile;
                shield.setBubbleVisible((Boolean)this.data.get(1));
                break;
            }
            case S_ENABLE_SHIELD: {
                TileEntity tile = world.func_175625_s((BlockPos)this.data.get(0));
                if (!(tile instanceof TileEntityShieldGenerator)) break;
                TileEntityShieldGenerator shield = (TileEntityShieldGenerator)tile;
                shield.enableShield = !shield.enableShield;
                break;
            }
            case S_ENABLE_SHIELD_DAMAGE: {
                TileEntity tile = world.func_175625_s((BlockPos)this.data.get(0));
                if (!(tile instanceof TileEntityShieldGenerator)) break;
                TileEntityShieldGenerator shield = (TileEntityShieldGenerator)tile;
                shield.enableDamage = !shield.enableDamage;
                break;
            }
            case S_SHIELD_GENERATOR_OPTION: {
                TileEntity tile = world.func_175625_s((BlockPos)this.data.get(0));
                int value = (Integer)this.data.get(1);
                String type = (String)this.data.get(2);
                if (!(tile instanceof TileEntityShieldGenerator)) break;
                TileEntityShieldGenerator shield = (TileEntityShieldGenerator)tile;
                switch (type) {
                    case "damage": {
                        shield.shieldDamage = value;
                        break;
                    }
                    case "size": {
                        shield.maxShieldSize = value;
                    }
                }
                break;
            }
            case S_SWITCH_SHIELD_GENERATOR_GUI: {
                TileEntity tile = player.field_70170_p.func_175625_s((BlockPos)this.data.get(0));
                boolean isConfig = (Boolean)this.data.get(1);
                if (!(tile instanceof TileEntityShieldGenerator)) break;
                TileEntityShieldGenerator shield = (TileEntityShieldGenerator)tile;
                PacketSimpleMP.openShieldGeneratorConfig(playerMP, shield, isConfig);
                break;
            }
            case S_FAILED_UNLOCK_CHEST: {
                if (stats.getChatCooldown() != 0) break;
                player.func_145747_a((ITextComponent)new TextComponentString(LangUtils.translate((String)"gui.valid_key.message", (Object[])new Object[]{this.data.get(0)})));
                stats.setChatCooldown(100);
                break;
            }
            case S_START_SURVIVAL_PLANET: {
                if (WorldTickEventHandler.survivalPlanetData == null || WorldTickEventHandler.survivalPlanetData.hasSurvivalPlanetData) break;
                int sourceDimId = (Integer)this.data.get(0);
                String celestialName = (String)this.data.get(1);
                LoggerMP.info("Start survival planet at: {}, Dimension: {}", celestialName, WorldUtil.getProviderForNameServer((String)celestialName).getDimension());
                WorldTickEventHandler.survivalPlanetData.hasSurvivalPlanetData = true;
                WorldTickEventHandler.survivalPlanetData.survivalPlanetName = celestialName;
                WorldTickEventHandler.survivalPlanetData.func_76186_a(true);
                TeleportUtils.teleportPlayerToPlanet(playerMP, playerMP.func_184102_h(), sourceDimId, WorldUtil.getProviderForNameServer((String)celestialName).getDimension());
                break;
            }
            case S_UPDATE_NIBIRU_WEATHER: {
                int i = (300 + world.field_73012_v.nextInt(600)) * 20;
                boolean thunder = (Boolean)this.data.get(0);
                WorldInfo worldinfo = playerMP.field_71133_b.field_71305_c[0].func_72912_H();
                worldinfo.func_176142_i(0);
                worldinfo.func_76080_g(i);
                worldinfo.func_76090_f(i);
                worldinfo.func_76084_b(true);
                worldinfo.func_76069_a(thunder);
                break;
            }
        }
    }

    public static void sendToAllAround(PacketSimpleMP packet, World world, int dimID, BlockPos pos, double radius) {
        double x = (double)pos.func_177958_n() + 0.5;
        double y = (double)pos.func_177956_o() + 0.5;
        double z = (double)pos.func_177952_p() + 0.5;
        double r2 = radius * radius;
        for (EntityPlayer player : world.field_73010_i) {
            double dz;
            double dy;
            double dx;
            if (!(player instanceof EntityPlayerMP)) continue;
            EntityPlayerMP playerMP = (EntityPlayerMP)player;
            if (playerMP.field_71093_bK != dimID || !((dx = x - playerMP.field_70165_t) * dx + (dy = y - playerMP.field_70163_u) * dy + (dz = z - playerMP.field_70161_v) * dz < r2)) continue;
            GalacticraftCore.packetPipeline.sendTo((IPacket)packet, playerMP);
        }
    }

    private static void openShieldGeneratorConfig(EntityPlayerMP player, TileEntityShieldGenerator tile, boolean isConfig) {
        player.func_71117_bO();
        player.func_71128_l();
        int windowId = player.field_71139_cq;
        GalacticraftCore.packetPipeline.sendTo((IPacket)new PacketSimpleMP(EnumSimplePacketMP.C_SWITCH_SHIELD_GENERATOR_GUI, GCCoreUtil.getDimensionID((World)player.field_70170_p), tile.func_174877_v(), windowId, isConfig), player);
        player.field_71070_bA = new ContainerShieldGeneratorConfig(player.field_71071_by, tile);
        player.field_71070_bA.field_75152_c = windowId;
        player.field_71070_bA.func_75132_a((IContainerListener)player);
    }

    public static enum EnumSimplePacketMP {
        S_BLACK_HOLE_STORAGE_OPTION(Side.SERVER, BlockPos.class, String.class),
        S_SHIELD_VISIBLE(Side.SERVER, BlockPos.class, Boolean.class),
        S_ENABLE_SHIELD(Side.SERVER, BlockPos.class),
        S_ENABLE_SHIELD_DAMAGE(Side.SERVER, BlockPos.class),
        S_SHIELD_GENERATOR_OPTION(Side.SERVER, BlockPos.class, Integer.class, String.class),
        S_SWITCH_SHIELD_GENERATOR_GUI(Side.SERVER, BlockPos.class, Boolean.class),
        S_FAILED_UNLOCK_CHEST(Side.SERVER, String.class),
        S_START_SURVIVAL_PLANET(Side.SERVER, Integer.class, String.class),
        S_UPDATE_NIBIRU_WEATHER(Side.SERVER, Boolean.class),
        C_REMOVE_GUIDE_POS(Side.CLIENT, BlockPos.class),
        C_RELOAD_RENDERER(Side.CLIENT, new Class[0]),
        C_SWITCH_SHIELD_GENERATOR_GUI(Side.CLIENT, BlockPos.class, Integer.class, Boolean.class),
        C_REMOVE_GENERATOR_GUIDE_POS(Side.CLIENT, BlockPos.class),
        C_OPEN_SURVIVAL_PLANET_GUI(Side.CLIENT, new Class[0]),
        C_MESSAGE_SURVIVAL_PLANET(Side.CLIENT, String.class),
        C_PLAY_VEIN_FLOATER_MUSIC(Side.CLIENT, new Class[0]),
        C_STOP_VEIN_FLOATER_MUSIC(Side.CLIENT, new Class[0]),
        C_PLAY_CREATED_BLACK_HOLE_SOUND(Side.CLIENT, new Class[0]);

        private Side targetSide;
        private Class[] decodeAs;
        public static final EnumSimplePacketMP[] values;

        private EnumSimplePacketMP(Side targetSide, Class ... decodeAs) {
            this.targetSide = targetSide;
            this.decodeAs = decodeAs;
        }

        public Side getTargetSide() {
            return this.targetSide;
        }

        public Class[] getDecodeClasses() {
            return this.decodeAs;
        }

        static {
            values = EnumSimplePacketMP.values();
        }
    }
}

