/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.planets.diona.world.gen.structure;

import java.util.Map;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;
import stevekung.mods.moreplanets.init.MPBlocks;
import stevekung.mods.moreplanets.init.MPLootTables;
import stevekung.mods.moreplanets.planets.diona.tileentity.TileEntityCrashedAlienProbe;
import stevekung.mods.moreplanets.tileentity.TileEntityAlienChest;
import stevekung.mods.moreplanets.tileentity.TileEntityAlienDefenderBeacon;
import stevekung.mods.moreplanets.utils.LoggerMP;
import stevekung.mods.stevekunglib.utils.enums.CachedEnum;

public abstract class ComponentCrashedAlienShipPieces
extends StructureComponent {
    protected int width;
    protected int height;
    protected int depth;
    protected int horizontalPos = -1;

    public ComponentCrashedAlienShipPieces() {
    }

    protected ComponentCrashedAlienShipPieces(Random rand, int x, int y, int z, int sizeX, int sizeY, int sizeZ) {
        super(0);
        this.width = sizeX;
        this.height = sizeY;
        this.depth = sizeZ;
        this.func_186164_a(EnumFacing.Plane.HORIZONTAL.func_179518_a(rand));
        this.field_74887_e = this.func_186165_e().func_176740_k() == EnumFacing.Axis.Z ? new StructureBoundingBox(x, y, z, x + sizeX - 1, y + sizeY - 1, z + sizeZ - 1) : new StructureBoundingBox(x, y, z, x + sizeZ - 1, y + sizeY - 1, z + sizeX - 1);
    }

    protected void func_143012_a(NBTTagCompound nbt) {
        nbt.func_74768_a("Width", this.width);
        nbt.func_74768_a("Height", this.height);
        nbt.func_74768_a("Depth", this.depth);
        nbt.func_74768_a("HPos", this.horizontalPos);
    }

    protected void func_143011_b(NBTTagCompound nbt, TemplateManager manager) {
        this.width = nbt.func_74762_e("Width");
        this.height = nbt.func_74762_e("Height");
        this.depth = nbt.func_74762_e("Depth");
        this.horizontalPos = nbt.func_74762_e("HPos");
    }

    protected boolean offsetToAverageGroundLevel(World world, StructureBoundingBox bb, int yOffset) {
        if (this.horizontalPos >= 0) {
            return true;
        }
        int i = 0;
        int j = 0;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int k = this.field_74887_e.field_78896_c; k <= this.field_74887_e.field_78892_f; ++k) {
            for (int l = this.field_74887_e.field_78897_a; l <= this.field_74887_e.field_78893_d; ++l) {
                pos.func_181079_c(l, 64, k);
                if (!bb.func_175898_b((Vec3i)pos)) continue;
                i += Math.max(world.func_175672_r((BlockPos)pos).func_177956_o(), world.field_73011_w.func_76557_i());
                ++j;
            }
        }
        if (j == 0) {
            return false;
        }
        this.horizontalPos = i / j;
        this.field_74887_e.func_78886_a(0, this.horizontalPos - this.field_74887_e.field_78895_b + yOffset, 0);
        return true;
    }

    public static class CrashedAlienShip
    extends ComponentCrashedAlienShipPieces {
        private static final ResourceLocation ALIEN_SHIP = new ResourceLocation("moreplanets:crashed_alien_ship");

        public CrashedAlienShip() {
        }

        public CrashedAlienShip(Random rand, int x, int z) {
            super(rand, x, 64, z, 8, 9, 8);
        }

        public boolean func_74875_a(World world, Random rand, StructureBoundingBox box) {
            if (!this.offsetToAverageGroundLevel(world, box, -1)) {
                return false;
            }
            StructureBoundingBox box1 = this.func_74874_b();
            BlockPos pos = new BlockPos(box1.field_78897_a, box1.field_78895_b, box1.field_78896_c);
            Rotation[] arotation = CachedEnum.rotationValues;
            MinecraftServer server = world.func_73046_m();
            TemplateManager manager = world.func_72860_G().func_186340_h();
            PlacementSettings settings = new PlacementSettings().func_186220_a(arotation[rand.nextInt(arotation.length)]).func_186225_a(Blocks.field_189881_dj).func_186223_a(box1);
            settings.func_189946_a(0.65f);
            Template template = manager.func_186237_a(server, ALIEN_SHIP);
            pos = pos.func_177982_a(0, -4, 0);
            template.func_186260_a(world, pos, settings);
            LoggerMP.debug("Generate Crashed Alien Ship at {} {} {}", pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            Map map = template.func_186258_a(pos, settings);
            for (Map.Entry entry : map.entrySet()) {
                BlockPos pos2;
                if ("crashed_alien_probe".equals(entry.getValue())) {
                    pos2 = (BlockPos)entry.getKey();
                    world.func_180501_a(pos2, MPBlocks.ALIEN_DEFENDER_BEACON.func_176223_P(), 3);
                    TileEntity tile = world.func_175625_s(pos2);
                    TileEntity tileDown = world.func_175625_s(pos2.func_177977_b());
                    if (tile instanceof TileEntityAlienDefenderBeacon) {
                        ((TileEntityAlienDefenderBeacon)tile).creativeSpawn = true;
                    }
                    if (tileDown instanceof TileEntityCrashedAlienProbe) {
                        ((TileEntityCrashedAlienProbe)tileDown).setLootTable(MPLootTables.CRASHED_ALIEN_PROBE, rand.nextLong());
                    }
                }
                if (!"alien_chest".equals(entry.getValue())) continue;
                pos2 = (BlockPos)entry.getKey();
                world.func_180501_a(pos2, Blocks.field_150350_a.func_176223_P(), 3);
                TileEntity tileDown = world.func_175625_s(pos2.func_177977_b());
                if (!(tileDown instanceof TileEntityAlienChest)) continue;
                ((TileEntityAlienChest)tileDown).func_189404_a(MPLootTables.CRASHED_ALIEN_SHIP, rand.nextLong());
            }
            return true;
        }
    }
}

