/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.planets.fronos.blocks;

import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import stevekung.mods.moreplanets.init.MPSounds;
import stevekung.mods.moreplanets.utils.blocks.BlockBreakableMP;
import stevekung.mods.moreplanets.utils.blocks.EnumSortCategoryBlock;
import stevekung.mods.stevekunglib.utils.ColorUtils;

public class BlockJelly
extends BlockBreakableMP {
    private static final Map<BlockType, float[]> JELLY_RGB = new EnumMap<BlockType, float[]>(BlockType.class);
    private final BlockType type;

    public BlockJelly(String name, BlockType type) {
        super(Material.field_151580_n);
        this.func_149672_a(MPSounds.SMALL_SLIME);
        this.func_149663_c(name);
        this.type = type;
    }

    @Nullable
    public float[] getBeaconColorMultiplier(IBlockState state, World world, BlockPos pos, BlockPos beaconPos) {
        return JELLY_RGB.get((Object)this.type);
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    public EnumSortCategoryBlock getBlockCategory() {
        return EnumSortCategoryBlock.DECORATION_BLOCK;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public void func_180658_a(World world, BlockPos pos, Entity entity, float fallDistance) {
        if (entity.func_70093_af()) {
            super.func_180658_a(world, pos, entity, fallDistance);
        } else {
            entity.func_180430_e(fallDistance, 0.0f);
        }
    }

    public void func_176216_a(World world, Entity entity) {
        if (entity.func_70093_af()) {
            super.func_176216_a(world, entity);
        } else if (entity.field_70181_x < 0.0) {
            entity.field_70181_x = -entity.field_70181_x;
            if (!(entity instanceof EntityLivingBase)) {
                entity.field_70181_x *= 0.8;
            }
        }
    }

    public void func_176199_a(World world, BlockPos pos, Entity entity) {
        if (Math.abs(entity.field_70181_x) < 0.1 && !entity.func_70093_af()) {
            double d0 = 0.4 + Math.abs(entity.field_70181_x) * 0.2;
            entity.field_70159_w *= d0;
            entity.field_70179_y *= d0;
        }
    }

    @Override
    protected boolean isTranslucent() {
        return true;
    }

    @Override
    protected boolean renderSideWithState() {
        return true;
    }

    public boolean isStickyBlock(IBlockState state) {
        return true;
    }

    static {
        JELLY_RGB.put(BlockType.GRAPE_JELLY_BLOCK, ColorUtils.rgbToFloatArray((int)230, (int)77, (int)201));
        JELLY_RGB.put(BlockType.RASPBERRY_JELLY_BLOCK, ColorUtils.rgbToFloatArray((int)250, (int)68, (int)112));
        JELLY_RGB.put(BlockType.STRAWBERRY_JELLY_BLOCK, ColorUtils.rgbToFloatArray((int)247, (int)102, (int)103));
        JELLY_RGB.put(BlockType.BERRY_JELLY_BLOCK, ColorUtils.rgbToFloatArray((int)122, (int)47, (int)198));
        JELLY_RGB.put(BlockType.LIME_JELLY_BLOCK, ColorUtils.rgbToFloatArray((int)197, (int)254, (int)136));
        JELLY_RGB.put(BlockType.ORANGE_JELLY_BLOCK, ColorUtils.rgbToFloatArray((int)255, (int)144, (int)32));
        JELLY_RGB.put(BlockType.GREEN_JELLY_BLOCK, ColorUtils.rgbToFloatArray((int)47, (int)151, (int)47));
        JELLY_RGB.put(BlockType.LEMON_JELLY_BLOCK, ColorUtils.rgbToFloatArray((int)183, (int)221, (int)67));
    }

    public static enum BlockType {
        GRAPE_JELLY_BLOCK,
        RASPBERRY_JELLY_BLOCK,
        STRAWBERRY_JELLY_BLOCK,
        BERRY_JELLY_BLOCK,
        LIME_JELLY_BLOCK,
        ORANGE_JELLY_BLOCK,
        GREEN_JELLY_BLOCK,
        LEMON_JELLY_BLOCK;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

