/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.utils;

import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import stevekung.mods.moreplanets.utils.client.particle.ParticleDiggingNoColor;
import stevekung.mods.stevekunglib.utils.client.RenderUtils;
import stevekung.mods.stevekunglib.utils.enums.CachedEnum;

@SideOnly(value=Side.CLIENT)
public class ClientRendererUtils {
    public static void renderModel(IBlockState state) {
        Minecraft mc = Minecraft.func_71410_x();
        mc.field_71446_o.func_110577_a(TextureMap.field_110575_b);
        GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        int i = mc.func_184125_al().func_186724_a(state, null, null, 0);
        IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178125_b(state);
        if (EntityRenderer.field_78517_a) {
            i = TextureUtil.func_177054_c((int)i);
        }
        float f = (float)(i >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(i & 0xFF) / 255.0f;
        ClientRendererUtils.renderModelBrightnessColor(state, model, 1.0f, f, f1, f2);
    }

    public static void renderModelBrightnessColor(IBlockState state, IBakedModel model, float brightness, float red, float green, float blue) {
        for (EnumFacing facing : CachedEnum.facingValues) {
            ClientRendererUtils.renderModelBrightnessColorQuads(brightness, red, green, blue, model.func_188616_a(state, facing, 0L));
        }
        ClientRendererUtils.renderModelBrightnessColorQuads(brightness, red, green, blue, model.func_188616_a(state, null, 0L));
    }

    private static void renderModelBrightnessColorQuads(float brightness, float red, float green, float blue, List<BakedQuad> listQuads) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        int j = listQuads.size();
        for (int i = 0; i < j; ++i) {
            BakedQuad bakedquad = listQuads.get(i);
            vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_176599_b);
            vertexbuffer.func_178981_a(bakedquad.func_178209_a());
            if (bakedquad.func_178212_b()) {
                ClientRendererUtils.putColorRGB_F4(vertexbuffer, red * brightness, green * brightness, blue * brightness);
            } else {
                ClientRendererUtils.putColorRGB_F4(vertexbuffer, brightness, brightness, brightness);
            }
            Vec3i vec3i = bakedquad.func_178210_d().func_176730_m();
            vertexbuffer.func_178975_e((float)vec3i.func_177958_n(), (float)vec3i.func_177956_o(), (float)vec3i.func_177952_p());
            tessellator.func_78381_a();
        }
    }

    private static void putColorRGB_F4(BufferBuilder vertexbuffer, float red, float green, float blue) {
        for (int i = 0; i < 4; ++i) {
            ClientRendererUtils.putColorRGB_F(vertexbuffer, red, green, blue, i + 1);
        }
    }

    private static void putColorRGB_F(BufferBuilder vertexbuffer, float red, float green, float blue, int vertexIndex) {
        int i = vertexbuffer.func_78909_a(vertexIndex);
        int j = MathHelper.func_76125_a((int)((int)(red * 255.0f)), (int)0, (int)255);
        int k = MathHelper.func_76125_a((int)((int)(green * 255.0f)), (int)0, (int)255);
        int l = MathHelper.func_76125_a((int)((int)(blue * 255.0f)), (int)0, (int)255);
        vertexbuffer.putColorRGBA(i, j, k, l, 127);
    }

    public static void renderBeam(double x, double y, double z, float partialTicks, double prevX, double prevY, double prevZ, int ticksExisted, double targetX, double targetY, double targetZ) {
        float f = (float)(targetX - prevX);
        float f1 = (float)(targetY - 1.0 - prevY);
        float f2 = (float)(targetZ - prevZ);
        float f3 = MathHelper.func_76129_c((float)(f * f + f2 * f2));
        float f4 = MathHelper.func_76129_c((float)(f * f + f1 * f1 + f2 * f2));
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)x), (float)((float)y + 2.0f), (float)((float)z));
        GlStateManager.func_179114_b((float)((float)(-Math.atan2(f2, f)) * 57.295776f - 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)(-Math.atan2(f3, f1)) * 57.295776f - 90.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        RenderUtils.disableLighting();
        GlStateManager.func_179129_p();
        GlStateManager.func_179103_j((int)7425);
        float f5 = 0.0f - ((float)ticksExisted + partialTicks) * 0.01f;
        float f6 = MathHelper.func_76129_c((float)(f * f + f1 * f1 + f2 * f2)) / 32.0f - ((float)ticksExisted + partialTicks) * 0.01f;
        vertexbuffer.func_181668_a(5, DefaultVertexFormats.field_181709_i);
        for (int j = 0; j <= 8; ++j) {
            float f7 = MathHelper.func_76126_a((float)((float)(j % 8) * ((float)Math.PI * 2) / 8.0f)) * 0.75f;
            float f8 = MathHelper.func_76134_b((float)((float)(j % 8) * ((float)Math.PI * 2) / 8.0f)) * 0.75f;
            float f9 = (float)(j % 8) / 8.0f;
            vertexbuffer.func_181662_b((double)(f7 * 0.2f), (double)(f8 * 0.2f), 0.0).func_187315_a((double)f9, (double)f5).func_181669_b(0, 0, 0, 255).func_181675_d();
            vertexbuffer.func_181662_b((double)f7, (double)f8, (double)f4).func_187315_a((double)f9, (double)f6).func_181669_b(255, 255, 255, 255).func_181675_d();
        }
        tessellator.func_78381_a();
        GlStateManager.func_179089_o();
        GlStateManager.func_179103_j((int)7424);
        RenderUtils.enableLighting();
        GlStateManager.func_179121_F();
    }

    public static void addBlockDestroyEffects(World world, BlockPos pos, IBlockState state, ParticleManager manager) {
        if (!state.func_177230_c().isAir(state, (IBlockAccess)world, pos)) {
            state = state.func_185899_b((IBlockAccess)world, pos);
            for (int j = 0; j < 4; ++j) {
                for (int k = 0; k < 4; ++k) {
                    for (int l = 0; l < 4; ++l) {
                        double d0 = ((double)j + 0.5) / 4.0;
                        double d1 = ((double)k + 0.5) / 4.0;
                        double d2 = ((double)l + 0.5) / 4.0;
                        manager.func_78873_a((Particle)new ParticleDiggingNoColor(world, (double)pos.func_177958_n() + d0, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, d0 - 0.5, d1 - 0.5, d2 - 0.5, state).setBlockPos(pos));
                    }
                }
            }
        }
    }

    public static void addBlockHitEffects(World world, BlockPos pos, EnumFacing side, ParticleManager manager) {
        IBlockState iblockstate = world.func_180495_p(pos);
        if (iblockstate.func_185901_i() != EnumBlockRenderType.INVISIBLE) {
            int i = pos.func_177958_n();
            int j = pos.func_177956_o();
            int k = pos.func_177952_p();
            AxisAlignedBB axisalignedbb = iblockstate.func_185900_c((IBlockAccess)world, pos);
            double d0 = (double)i + world.field_73012_v.nextDouble() * (axisalignedbb.field_72336_d - axisalignedbb.field_72340_a - (double)0.2f) + (double)0.1f + axisalignedbb.field_72340_a;
            double d1 = (double)j + world.field_73012_v.nextDouble() * (axisalignedbb.field_72337_e - axisalignedbb.field_72338_b - (double)0.2f) + (double)0.1f + axisalignedbb.field_72338_b;
            double d2 = (double)k + world.field_73012_v.nextDouble() * (axisalignedbb.field_72334_f - axisalignedbb.field_72339_c - (double)0.2f) + (double)0.1f + axisalignedbb.field_72339_c;
            if (side == EnumFacing.DOWN) {
                d1 = (double)j + axisalignedbb.field_72338_b - (double)0.1f;
            }
            if (side == EnumFacing.UP) {
                d1 = (double)j + axisalignedbb.field_72337_e + (double)0.1f;
            }
            if (side == EnumFacing.NORTH) {
                d2 = (double)k + axisalignedbb.field_72339_c - (double)0.1f;
            }
            if (side == EnumFacing.SOUTH) {
                d2 = (double)k + axisalignedbb.field_72334_f + (double)0.1f;
            }
            if (side == EnumFacing.WEST) {
                d0 = (double)i + axisalignedbb.field_72340_a - (double)0.1f;
            }
            if (side == EnumFacing.EAST) {
                d0 = (double)i + axisalignedbb.field_72336_d + (double)0.1f;
            }
            manager.func_78873_a(new ParticleDiggingNoColor(world, d0, d1, d2, 0.0, 0.0, 0.0, iblockstate).setBlockPos(pos).func_70543_e(0.2f).func_70541_f(0.6f));
        }
    }
}

