/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.utils.blocks;

import java.lang.reflect.Method;
import micdoodle8.mods.galacticraft.core.GCItems;
import micdoodle8.mods.galacticraft.core.util.CompatibilityManager;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import stevekung.mods.moreplanets.utils.blocks.BlockBaseMP;

public abstract class BlockAdvancedMP
extends BlockBaseMP
implements ITileEntityProvider {
    public BlockAdvancedMP(Material material) {
        super(material);
        this.func_149711_c(0.6f);
        this.func_149752_b(2.5f);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (hand != EnumHand.MAIN_HAND) {
            return false;
        }
        ItemStack heldItem = player.func_184586_b(hand);
        if (this.useWrench(world, pos, player, hand, heldItem, side, hitX, hitY, hitZ)) {
            return true;
        }
        if (player.func_70093_af() && this.onSneakMachineActivated(world, pos, player, hand, heldItem, side, hitX, hitY, hitZ)) {
            return true;
        }
        return this.onMachineActivated(world, pos, state, player, hand, heldItem, side, hitX, hitY, hitZ);
    }

    protected boolean useWrench(World world, BlockPos pos, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (this.isUsableWrench(player, heldItem, pos)) {
            this.damageWrench(player, heldItem, pos);
            if (player.func_70093_af() && this.onSneakUseWrench(world, pos, player, hand, heldItem, side, hitX, hitY, hitZ)) {
                player.func_184609_a(hand);
                return true;
            }
            if (this.onUseWrench(world, pos, player, hand, heldItem, side, hitX, hitY, hitZ)) {
                player.func_184609_a(hand);
                return true;
            }
        }
        return false;
    }

    public boolean isUsableWrench(EntityPlayer entityPlayer, ItemStack itemStack, BlockPos pos) {
        block4: {
            if (entityPlayer != null && !itemStack.func_190926_b()) {
                Item item = itemStack.func_77973_b();
                if (item == GCItems.wrench) {
                    return true;
                }
                Class<?> wrenchClass = item.getClass();
                try {
                    Method methodCanWrench = wrenchClass.getMethod("canWrench", EntityPlayer.class, BlockPos.class);
                    return (Boolean)methodCanWrench.invoke((Object)item, entityPlayer, pos);
                }
                catch (Exception exception) {
                    if (!CompatibilityManager.isIc2Loaded() || wrenchClass != CompatibilityManager.classIC2wrench && wrenchClass != CompatibilityManager.classIC2wrenchElectric) break block4;
                    return itemStack.func_77952_i() < itemStack.func_77958_k();
                }
            }
        }
        return false;
    }

    public boolean damageWrench(EntityPlayer entityPlayer, ItemStack itemStack, BlockPos pos) {
        if (this.isUsableWrench(entityPlayer, itemStack, pos)) {
            Class<?> wrenchClass = itemStack.func_77973_b().getClass();
            try {
                Method methodWrenchUsed = wrenchClass.getMethod("wrenchUsed", EntityPlayer.class, BlockPos.class);
                methodWrenchUsed.invoke((Object)itemStack.func_77973_b(), entityPlayer, pos);
                return true;
            }
            catch (Exception methodWrenchUsed) {
                try {
                    if (wrenchClass == CompatibilityManager.classIC2wrench || wrenchClass == CompatibilityManager.classIC2wrenchElectric) {
                        Method methodWrenchDamage = wrenchClass.getMethod("damage", ItemStack.class, Integer.TYPE, EntityPlayer.class);
                        methodWrenchDamage.invoke((Object)itemStack.func_77973_b(), itemStack, 1, entityPlayer);
                        return true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    public boolean onMachineActivated(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    public boolean onSneakMachineActivated(World world, BlockPos pos, EntityPlayer entityPlayer, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    public boolean onUseWrench(World world, BlockPos pos, EntityPlayer entityPlayer, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    public boolean onSneakUseWrench(World world, BlockPos pos, EntityPlayer entityPlayer, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        return this.onUseWrench(world, pos, entityPlayer, hand, heldItem, side, hitX, hitY, hitZ);
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return this.isNormalCube(state, world, pos);
    }
}

