/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.utils.blocks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import stevekung.mods.moreplanets.core.MorePlanetsMod;
import stevekung.mods.moreplanets.init.MPBlocks;
import stevekung.mods.moreplanets.init.MPItems;
import stevekung.mods.moreplanets.utils.EnumParticleTypesMP;
import stevekung.mods.moreplanets.utils.blocks.BlockBaseMP;
import stevekung.mods.moreplanets.utils.blocks.EnumSortCategoryBlock;
import stevekung.mods.stevekunglib.utils.BlockStateProperty;

public class BlockLeavesMP
extends BlockBaseMP
implements IShearable {
    private int[] surroundings;
    private BlockType type;

    public BlockLeavesMP(String name, BlockType type) {
        super(Material.field_151584_j);
        this.func_149675_a(true);
        this.func_149711_c(0.2f);
        this.func_149713_g(1);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149663_c(name);
        this.type = type;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        int z;
        int y;
        int x = pos.func_177958_n();
        if (world.func_175707_a(new BlockPos(x - 2, (y = pos.func_177956_o()) - 2, (z = pos.func_177952_p()) - 2), new BlockPos(x + 2, y + 2, z + 2))) {
            for (int j1 = -1; j1 <= 1; ++j1) {
                for (int k1 = -1; k1 <= 1; ++k1) {
                    for (int l1 = -1; l1 <= 1; ++l1) {
                        BlockPos blockpos = pos.func_177982_a(j1, k1, l1);
                        IBlockState iblockstate = world.func_180495_p(blockpos);
                        if (!iblockstate.func_177230_c().isLeaves(iblockstate, (IBlockAccess)world, blockpos)) continue;
                        iblockstate.func_177230_c().beginLeavesDecay(iblockstate, world, blockpos);
                    }
                }
            }
        }
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.field_72995_K && ((Boolean)state.func_177229_b((IProperty)BlockStateProperty.CHECK_DECAY)).booleanValue() && ((Boolean)state.func_177229_b((IProperty)BlockStateProperty.DECAYABLE)).booleanValue()) {
            int l2;
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            if (this.surroundings == null) {
                this.surroundings = new int[32768];
            }
            if (!world.func_175697_a(pos, 1)) {
                return;
            }
            if (world.func_175697_a(pos, 6)) {
                BlockPos.MutableBlockPos mutableblockpos = new BlockPos.MutableBlockPos();
                for (int i2 = -4; i2 <= 4; ++i2) {
                    for (int j2 = -4; j2 <= 4; ++j2) {
                        for (int k2 = -4; k2 <= 4; ++k2) {
                            IBlockState iblockstate = world.func_180495_p((BlockPos)mutableblockpos.func_181079_c(x + i2, y + j2, z + k2));
                            Block block = iblockstate.func_177230_c();
                            if (!block.canSustainLeaves(iblockstate, (IBlockAccess)world, (BlockPos)mutableblockpos.func_181079_c(x + i2, y + j2, z + k2))) {
                                if (block.isLeaves(iblockstate, (IBlockAccess)world, (BlockPos)mutableblockpos.func_181079_c(x + i2, y + j2, z + k2))) {
                                    this.surroundings[(i2 + 16) * 1024 + (j2 + 16) * 32 + k2 + 16] = -2;
                                    continue;
                                }
                                this.surroundings[(i2 + 16) * 1024 + (j2 + 16) * 32 + k2 + 16] = -1;
                                continue;
                            }
                            this.surroundings[(i2 + 16) * 1024 + (j2 + 16) * 32 + k2 + 16] = 0;
                        }
                    }
                }
                for (int i3 = 1; i3 <= 4; ++i3) {
                    for (int j3 = -4; j3 <= 4; ++j3) {
                        for (int k3 = -4; k3 <= 4; ++k3) {
                            for (int l3 = -4; l3 <= 4; ++l3) {
                                if (this.surroundings[(j3 + 16) * 1024 + (k3 + 16) * 32 + l3 + 16] != i3 - 1) continue;
                                if (this.surroundings[(j3 + 16 - 1) * 1024 + (k3 + 16) * 32 + l3 + 16] == -2) {
                                    this.surroundings[(j3 + 16 - 1) * 1024 + (k3 + 16) * 32 + l3 + 16] = i3;
                                }
                                if (this.surroundings[(j3 + 16 + 1) * 1024 + (k3 + 16) * 32 + l3 + 16] == -2) {
                                    this.surroundings[(j3 + 16 + 1) * 1024 + (k3 + 16) * 32 + l3 + 16] = i3;
                                }
                                if (this.surroundings[(j3 + 16) * 1024 + (k3 + 16 - 1) * 32 + l3 + 16] == -2) {
                                    this.surroundings[(j3 + 16) * 1024 + (k3 + 16 - 1) * 32 + l3 + 16] = i3;
                                }
                                if (this.surroundings[(j3 + 16) * 1024 + (k3 + 16 + 1) * 32 + l3 + 16] == -2) {
                                    this.surroundings[(j3 + 16) * 1024 + (k3 + 16 + 1) * 32 + l3 + 16] = i3;
                                }
                                if (this.surroundings[(j3 + 16) * 1024 + (k3 + 16) * 32 + l3 + 16 - 1] == -2) {
                                    this.surroundings[(j3 + 16) * 1024 + (k3 + 16) * 32 + l3 + 16 - 1] = i3;
                                }
                                if (this.surroundings[(j3 + 16) * 1024 + (k3 + 16) * 32 + l3 + 16 + 1] != -2) continue;
                                this.surroundings[(j3 + 16) * 1024 + (k3 + 16) * 32 + l3 + 16 + 1] = i3;
                            }
                        }
                    }
                }
            }
            if ((l2 = this.surroundings[16912]) >= 0) {
                world.func_180501_a(pos, state.func_177226_a((IProperty)BlockStateProperty.CHECK_DECAY, (Comparable)Boolean.valueOf(false)), 4);
            } else {
                this.destroy(world, pos);
            }
        }
    }

    public int func_149745_a(Random rand) {
        return rand.nextInt(20) == 0 ? 1 : 0;
    }

    public boolean func_149662_c(IBlockState state) {
        return Blocks.field_150362_t.func_149662_c(state);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return Blocks.field_150362_t.func_180664_k();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return Blocks.field_150362_t.func_176225_a(state, world, pos, side);
    }

    public boolean func_176214_u(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        double d2;
        double d1;
        double d0;
        if (world.func_175727_C(pos.func_177984_a()) && !world.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP) && rand.nextInt(15) == 1) {
            d0 = (float)pos.func_177958_n() + rand.nextFloat();
            d1 = (double)pos.func_177956_o() - 0.05;
            d2 = (float)pos.func_177952_p() + rand.nextFloat();
            world.func_175688_a(EnumParticleTypes.DRIP_WATER, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
        }
        if (this.type == BlockType.ALIEN_BERRY_OAK_LEAVES && world.func_175623_d(pos.func_177977_b()) && rand.nextInt(10) == 0) {
            d0 = (float)pos.func_177958_n() + rand.nextFloat();
            d1 = (double)pos.func_177956_o() - 0.05;
            d2 = (float)pos.func_177952_p() + rand.nextFloat();
            MorePlanetsMod.PROXY.spawnParticle(EnumParticleTypesMP.ALIEN_BERRY_LEAVES_SPARK, d0, d1, d2);
        }
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        Random rand = world instanceof World ? ((World)world).field_73012_v : RANDOM;
        int chance = 20;
        if (fortune > 0 && (chance -= 2 << fortune) < 10) {
            chance = 10;
        }
        if (rand.nextInt(chance) == 0) {
            drops.add((Object)new ItemStack(this.func_180660_a(state, rand, fortune)));
        }
        chance = 200;
        if (fortune > 0 && (chance -= 10 << fortune) < 40) {
            chance = 40;
        }
        this.captureDrops(true);
        if (world instanceof World) {
            this.dropFruits((World)world, pos, state, chance);
        }
        drops.addAll((Collection)this.captureDrops(false));
    }

    public boolean isShearable(ItemStack itemStack, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public boolean isLeaves(IBlockState state, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public void beginLeavesDecay(IBlockState state, World world, BlockPos pos) {
        if (!((Boolean)state.func_177229_b((IProperty)BlockStateProperty.CHECK_DECAY)).booleanValue()) {
            world.func_180501_a(pos, state.func_177226_a((IProperty)BlockStateProperty.CHECK_DECAY, (Comparable)Boolean.valueOf(true)), 4);
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        if (this.type == BlockType.INFECTED_OAK_LEAVES) {
            return Item.func_150898_a((Block)MPBlocks.INFECTED_OAK_SAPLING);
        }
        if (this.type == BlockType.INFECTED_JUNGLE_LEAVES) {
            return Item.func_150898_a((Block)MPBlocks.INFECTED_JUNGLE_SAPLING);
        }
        if (this.type == BlockType.INFECTED_SPRUCE_LEAVES) {
            return Item.func_150898_a((Block)MPBlocks.INFECTED_SPRUCE_SAPLING);
        }
        if (this.type == BlockType.ALIEN_BERRY_OAK_LEAVES) {
            return Item.func_150898_a((Block)MPBlocks.ALIEN_BERRY_OAK_SAPLING);
        }
        return Item.func_150898_a((Block)this);
    }

    public ArrayList<ItemStack> onSheared(ItemStack itemStack, IBlockAccess world, BlockPos pos, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ret.add(new ItemStack((Block)this));
        return ret;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Block)this);
    }

    @Override
    public EnumSortCategoryBlock getBlockCategory() {
        return EnumSortCategoryBlock.DECORATION_BLOCK;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BlockStateProperty.DECAYABLE, BlockStateProperty.CHECK_DECAY});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)BlockStateProperty.DECAYABLE, (Comparable)Boolean.valueOf((meta & 4) == 0)).func_177226_a((IProperty)BlockStateProperty.CHECK_DECAY, (Comparable)Boolean.valueOf((meta & 8) > 0));
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        if (!((Boolean)state.func_177229_b((IProperty)BlockStateProperty.DECAYABLE)).booleanValue()) {
            i |= 4;
        }
        if (((Boolean)state.func_177229_b((IProperty)BlockStateProperty.CHECK_DECAY)).booleanValue()) {
            i |= 8;
        }
        return i;
    }

    private void dropFruits(World world, BlockPos pos, IBlockState state, int chance) {
        if (world.field_73012_v.nextInt(chance) == 0) {
            if (this.type == BlockType.INFECTED_OAK_LEAVES) {
                Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack(MPItems.INFECTED_APPLE));
            } else if (this.type == BlockType.ALIEN_BERRY_OAK_LEAVES) {
                Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack(MPItems.ALIEN_BERRY));
            }
        }
    }

    private void destroy(World world, BlockPos pos) {
        this.func_180660_a(world.func_180495_p(pos), world.field_73012_v, 0);
        world.func_175698_g(pos);
    }

    public static enum BlockType {
        INFECTED_OAK_LEAVES,
        INFECTED_SPRUCE_LEAVES,
        INFECTED_JUNGLE_LEAVES,
        ALIEN_BERRY_OAK_LEAVES;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

