/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.utils.debug;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import stevekung.mods.stevekunglib.utils.JsonUtils;

public class JSONRecipe {
    private static File RECIPE_DIR = null;
    private static File ADVANCE_DIR = null;
    private static final Set<String> USED_OD_NAMES = new TreeSet<String>();
    public static final boolean ENABLE = false;

    private static void setupDir() {
        if (RECIPE_DIR == null) {
            RECIPE_DIR = Minecraft.func_71410_x().field_71412_D.toPath().resolve("../src/main/resources/assets/moreplanets/recipes/").toFile();
        }
        if (!RECIPE_DIR.exists()) {
            RECIPE_DIR.mkdir();
        }
    }

    private static void setupAdvDir() {
        if (ADVANCE_DIR == null) {
            ADVANCE_DIR = Minecraft.func_71410_x().field_71412_D.toPath().resolve("../src/main/resources/assets/moreplanets/advancements/recipes/").toFile();
        }
        if (!ADVANCE_DIR.exists()) {
            ADVANCE_DIR.mkdir();
        }
    }

    public static void addShapedRecipe(ItemStack output, Object ... components) {
        JSONRecipe.addShapedRecipe(output, null, null, components);
    }

    public static void addShapedRecipe(ItemStack output, String group, Object ... components) {
        JSONRecipe.addShapedRecipe(output, group, null, components);
    }

    public static void addShapedRecipe(ItemStack output, String group, String altName, Object ... components) {
    }

    public static void addShapelessRecipe(ItemStack output, Object ... components) {
        JSONRecipe.addShapelessRecipe(output, null, null, components);
    }

    public static void addShapelessRecipe(ItemStack output, String group, Object ... components) {
        JSONRecipe.addShapelessRecipe(output, group, null, components);
    }

    public static void addShapelessRecipe(ItemStack output, String group, String altName, Object ... components) {
    }

    private static Map<String, Object> serializeItem(Object obj) {
        if (obj instanceof Item) {
            return JSONRecipe.serializeItem(new ItemStack((Item)obj));
        }
        if (obj instanceof Block) {
            return JSONRecipe.serializeItem(new ItemStack((Block)obj));
        }
        if (obj instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)obj;
            HashMap<String, Object> ret = new HashMap<String, Object>();
            if (itemStack.func_77942_o()) {
                ret.put("type", "minecraft:item_nbt");
            }
            ret.put("item", itemStack.func_77973_b().getRegistryName().toString());
            if (itemStack.func_77973_b().func_77614_k() || itemStack.func_77952_i() != 0) {
                ret.put("data", itemStack.func_77952_i());
            }
            if (itemStack.func_77942_o()) {
                ret.put("nbt", itemStack.func_77978_p().toString());
            }
            if (itemStack.func_190916_E() > 1) {
                ret.put("count", itemStack.func_190916_E());
            }
            return ret;
        }
        if (obj instanceof String) {
            HashMap<String, Object> ret = new HashMap<String, Object>();
            USED_OD_NAMES.add((String)obj);
            ret.put("item", "#" + ((String)obj).toUpperCase(Locale.ROOT));
            return ret;
        }
        throw new IllegalArgumentException("Not a Block, Item, ItemStack, or OreDictionary Name: " + obj + " " + obj.getClass());
    }

    private static Map<String, Object> serializeItemAdv(Object obj) {
        if (obj instanceof Item) {
            return JSONRecipe.serializeItemAdv(new ItemStack((Item)obj));
        }
        if (obj instanceof Block) {
            return JSONRecipe.serializeItemAdv(new ItemStack((Block)obj));
        }
        if (obj instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)obj;
            HashMap<String, Object> ret = new HashMap<String, Object>();
            ret.put("item", itemStack.func_77973_b().getRegistryName().toString());
            if (itemStack.func_77973_b().func_77614_k() || itemStack.func_77952_i() != 0) {
                ret.put("data", itemStack.func_77952_i());
            }
            if (itemStack.func_77942_o()) {
                ret.put("nbt", itemStack.func_77978_p().toString());
            }
            if (itemStack.func_190916_E() > 1) {
                ret.put("count", itemStack.func_190916_E());
            }
            return ret;
        }
        if (obj instanceof String) {
            if (OreDictionary.getOres((String)((String)obj)).isEmpty()) {
                return null;
            }
            ItemStack itemStack = (ItemStack)OreDictionary.getOres((String)((String)obj)).get(0);
            return JSONRecipe.serializeItemAdv(itemStack);
        }
        throw new IllegalArgumentException("Not a Block, Item, ItemStack, or OreDictionary Name: " + obj + " " + obj.getClass());
    }

    public static void writeAdvancements(String name, List<Map<String, Object>> ingredients) {
    }

    public static void generateConstants() {
    }

    public static void addSmelting(ItemStack in, ItemStack result, float xp) {
        JSONRecipe.addSmelting(in, result, xp, 200);
    }

    public static void addSmelting(ItemStack in, ItemStack result, float xp, int cookTime) {
        JSONRecipe.setupDir();
        HashMap<String, Object> json = new HashMap<String, Object>();
        json.put("type", "minecraft:smelting");
        json.put("ingredient", JSONRecipe.serializeItem(in));
        json.put("result", JSONRecipe.serializeItem(result));
        json.put("experience", Float.valueOf(xp));
        json.put("cookingtime", cookTime);
        String suffix = result.func_77973_b().func_77614_k() ? "_" + result.func_77952_i() : "";
        File file = new File(RECIPE_DIR, result.func_77973_b().getRegistryName().func_110623_a() + suffix + ".json");
        try (FileWriter writer = new FileWriter(file);){
            JsonUtils.toJson(json, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

