/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.zenscript.expression;

import org.objectweb.asm.Type;
import stanhebben.zenscript.compiler.IEnvironmentGlobal;
import stanhebben.zenscript.compiler.IEnvironmentMethod;
import stanhebben.zenscript.expression.Expression;
import stanhebben.zenscript.expression.ExpressionArrayList;
import stanhebben.zenscript.expression.ExpressionAs;
import stanhebben.zenscript.expression.ExpressionInvalid;
import stanhebben.zenscript.type.ZenType;
import stanhebben.zenscript.type.ZenTypeArray;
import stanhebben.zenscript.type.ZenTypeArrayBasic;
import stanhebben.zenscript.type.ZenTypeArrayList;
import stanhebben.zenscript.type.casting.ICastingRule;
import stanhebben.zenscript.util.MethodOutput;
import stanhebben.zenscript.util.ZenPosition;

public class ExpressionArray
extends Expression {
    private final Expression[] contents;
    private final ZenTypeArrayBasic type;

    public ExpressionArray(ZenPosition position, ZenTypeArrayBasic type, Expression ... contents) {
        super(position);
        this.contents = contents;
        this.type = type;
    }

    @Override
    public Expression cast(ZenPosition position, IEnvironmentGlobal environment, ZenType type) {
        if (this.type.equals(type)) {
            return this;
        }
        if (type instanceof ZenTypeArray) {
            ZenTypeArray arrayType = (ZenTypeArray)type;
            Expression[] newContents = new Expression[this.contents.length];
            for (int i = 0; i < this.contents.length; ++i) {
                newContents[i] = this.contents[i].cast(position, environment, arrayType.getBaseType());
            }
            if (type instanceof ZenTypeArrayBasic) {
                return new ExpressionArray(this.getPosition(), (ZenTypeArrayBasic)arrayType, newContents);
            }
            return new ExpressionArrayList(this.getPosition(), (ZenTypeArrayList)arrayType, newContents);
        }
        ICastingRule castingRule = this.type.getCastingRule(type, environment);
        if (castingRule == null) {
            environment.error(position, "cannot cast " + this.type + " to " + type);
            return new ExpressionInvalid(position, type);
        }
        return new ExpressionAs(position, this, castingRule);
    }

    @Override
    public ZenType getType() {
        return this.type;
    }

    @Override
    public void compile(boolean result, IEnvironmentMethod environment) {
        ZenType baseType = this.type.getBaseType();
        Type asmBaseType = this.type.getBaseType().toASMType();
        MethodOutput output = environment.getOutput();
        output.constant(this.contents.length);
        output.newArray(asmBaseType);
        for (int i = 0; i < this.contents.length; ++i) {
            output.dup();
            output.constant(i);
            this.contents[i].cast(this.getPosition(), environment, baseType).compile(result, environment);
            output.arrayStore(asmBaseType);
        }
    }
}

