/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.network.node;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.api.util.Action;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.ICoverable;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNode;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.cover.CoverManager;
import com.raoulvdberge.refinedstorage.apiimpl.util.OneSixMigrationHelper;
import com.raoulvdberge.refinedstorage.inventory.fluid.FluidInventory;
import com.raoulvdberge.refinedstorage.inventory.item.ItemHandlerBase;
import com.raoulvdberge.refinedstorage.inventory.item.ItemHandlerUpgrade;
import com.raoulvdberge.refinedstorage.inventory.listener.ListenerNetworkNode;
import com.raoulvdberge.refinedstorage.tile.TileDiskDrive;
import com.raoulvdberge.refinedstorage.tile.TileImporter;
import com.raoulvdberge.refinedstorage.tile.config.IComparable;
import com.raoulvdberge.refinedstorage.tile.config.IFilterable;
import com.raoulvdberge.refinedstorage.tile.config.IType;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import com.raoulvdberge.refinedstorage.util.WorldUtils;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class NetworkNodeImporter
extends NetworkNode
implements IComparable,
IFilterable,
IType,
ICoverable {
    public static final String ID = "importer";
    private static final String NBT_COMPARE = "Compare";
    private static final String NBT_MODE = "Mode";
    private static final String NBT_TYPE = "Type";
    private static final String NBT_COVERS = "Covers";
    private static final String NBT_FLUID_FILTERS = "FLuidFilters";
    private ItemHandlerBase itemFilters = new ItemHandlerBase(9, new ListenerNetworkNode(this), new Predicate[0]);
    private FluidInventory fluidFilters = new FluidInventory(9, new ListenerNetworkNode(this));
    private ItemHandlerUpgrade upgrades = new ItemHandlerUpgrade(4, (Consumer<Integer>)new ListenerNetworkNode(this), 2, 4);
    private int compare = 3;
    private int mode = 1;
    private int type = 0;
    private CoverManager coverManager = new CoverManager(this);
    private int currentSlot;

    public NetworkNodeImporter(World world, BlockPos pos) {
        super(world, pos);
    }

    @Override
    public int getEnergyUsage() {
        return RS.INSTANCE.config.importerUsage + this.upgrades.getEnergyUsage();
    }

    @Override
    public void update() {
        FluidStack toDrain;
        FluidStack stack;
        IFluidHandler handler;
        super.update();
        if (!this.canUpdate()) {
            return;
        }
        if (this.type == 0) {
            TileEntity facing = this.getFacingTile();
            IItemHandler handler2 = WorldUtils.getItemHandler(facing, this.getDirection().func_176734_d());
            if (facing instanceof TileDiskDrive || handler2 == null) {
                return;
            }
            if (this.currentSlot >= handler2.getSlots()) {
                this.currentSlot = 0;
            }
            if (handler2.getSlots() > 0) {
                while (this.currentSlot + 1 < handler2.getSlots() && handler2.getStackInSlot(this.currentSlot).func_190926_b()) {
                    ++this.currentSlot;
                }
                ItemStack stack2 = handler2.getStackInSlot(this.currentSlot);
                if (!IFilterable.acceptsItem((IItemHandler)this.itemFilters, this.mode, this.compare, stack2)) {
                    ++this.currentSlot;
                } else if (this.ticks % this.upgrades.getSpeed() == 0) {
                    ItemStack result = handler2.extractItem(this.currentSlot, this.upgrades.getItemInteractCount(), true);
                    if (!result.func_190926_b() && this.network.insertItem(result, result.func_190916_E(), Action.SIMULATE) == null) {
                        result = handler2.extractItem(this.currentSlot, this.upgrades.getItemInteractCount(), false);
                        if (!result.func_190926_b()) {
                            this.network.insertItemTracked(result, result.func_190916_E());
                        }
                    } else {
                        ++this.currentSlot;
                    }
                }
            }
        } else if (this.type == 1 && this.ticks % this.upgrades.getSpeed() == 0 && (handler = WorldUtils.getFluidHandler(this.getFacingTile(), this.getDirection().func_176734_d())) != null && (stack = handler.drain(1000, false)) != null && IFilterable.acceptsFluid(this.fluidFilters, this.mode, this.compare, stack) && this.network.insertFluid(stack, stack.amount, Action.SIMULATE) == null && (toDrain = handler.drain(1000 * this.upgrades.getItemInteractCount(), false)) != null) {
            FluidStack remainder = this.network.insertFluidTracked(toDrain, toDrain.amount);
            if (remainder != null) {
                toDrain.amount -= remainder.amount;
            }
            handler.drain(toDrain, true);
        }
    }

    @Override
    public int getCompare() {
        return this.compare;
    }

    @Override
    public void setCompare(int compare) {
        this.compare = compare;
        this.markDirty();
    }

    @Override
    public int getMode() {
        return this.mode;
    }

    @Override
    public void setMode(int mode) {
        this.mode = mode;
        this.markDirty();
    }

    @Override
    public void read(NBTTagCompound tag) {
        super.read(tag);
        StackUtils.readItems((IItemHandlerModifiable)this.upgrades, 1, tag);
        if (tag.func_74764_b(NBT_COVERS)) {
            this.coverManager.readFromNbt(tag.func_150295_c(NBT_COVERS, 10));
        }
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public NBTTagCompound write(NBTTagCompound tag) {
        super.write(tag);
        StackUtils.writeItems((IItemHandler)this.upgrades, 1, tag);
        tag.func_74782_a(NBT_COVERS, (NBTBase)this.coverManager.writeToNbt());
        return tag;
    }

    @Override
    public NBTTagCompound writeConfiguration(NBTTagCompound tag) {
        super.writeConfiguration(tag);
        tag.func_74768_a(NBT_COMPARE, this.compare);
        tag.func_74768_a(NBT_MODE, this.mode);
        tag.func_74768_a(NBT_TYPE, this.type);
        StackUtils.writeItems((IItemHandler)this.itemFilters, 0, tag);
        tag.func_74782_a(NBT_FLUID_FILTERS, (NBTBase)this.fluidFilters.writeToNbt());
        return tag;
    }

    @Override
    public void readConfiguration(NBTTagCompound tag) {
        super.readConfiguration(tag);
        if (tag.func_74764_b(NBT_COMPARE)) {
            this.compare = tag.func_74762_e(NBT_COMPARE);
        }
        if (tag.func_74764_b(NBT_MODE)) {
            this.mode = tag.func_74762_e(NBT_MODE);
        }
        if (tag.func_74764_b(NBT_TYPE)) {
            this.type = tag.func_74762_e(NBT_TYPE);
        }
        StackUtils.readItems((IItemHandlerModifiable)this.itemFilters, 0, tag);
        if (tag.func_74764_b(NBT_FLUID_FILTERS)) {
            this.fluidFilters.readFromNbt(tag.func_74775_l(NBT_FLUID_FILTERS));
        }
        OneSixMigrationHelper.migrateEmptyWhitelistToEmptyBlacklist(this.version, this, this.itemFilters);
    }

    public IItemHandler getUpgrades() {
        return this.upgrades;
    }

    @Override
    public IItemHandler getDrops() {
        return new CombinedInvWrapper(new IItemHandlerModifiable[]{this.upgrades, this.coverManager.getAsInventory()});
    }

    @Override
    public boolean canConduct(@Nullable EnumFacing direction) {
        return this.coverManager.canConduct(direction);
    }

    @Override
    public int getType() {
        return this.world.field_72995_K ? TileImporter.TYPE.getValue() : this.type;
    }

    @Override
    public void setType(int type) {
        this.type = type;
        this.markDirty();
    }

    @Override
    public IItemHandlerModifiable getItemFilters() {
        return this.itemFilters;
    }

    @Override
    public FluidInventory getFluidFilters() {
        return this.fluidFilters;
    }

    @Override
    public CoverManager getCoverManager() {
        return this.coverManager;
    }
}

