/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.item;

import com.raoulvdberge.refinedstorage.item.ItemBase;
import com.raoulvdberge.refinedstorage.item.capprovider.CapabilityProviderEnergy;
import com.raoulvdberge.refinedstorage.item.info.IItemInfo;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public abstract class ItemEnergyItem
extends ItemBase {
    public static final int TYPE_NORMAL = 0;
    public static final int TYPE_CREATIVE = 1;
    private int energyCapacity;

    public ItemEnergyItem(IItemInfo info, int energyCapacity) {
        super(info);
        this.energyCapacity = energyCapacity;
        this.func_77656_e(energyCapacity);
        this.func_77625_d(1);
        this.func_77627_a(true);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound tag) {
        return new CapabilityProviderEnergy(stack, this.energyCapacity);
    }

    public boolean func_77645_m() {
        return true;
    }

    public boolean isRepairable() {
        return false;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        IEnergyStorage energy = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
        return 1.0 - (double)energy.getEnergyStored() / (double)energy.getMaxEnergyStored();
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        IEnergyStorage energy = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
        return MathHelper.func_181758_c((float)(Math.max(0.0f, (float)energy.getEnergyStored() / (float)energy.getMaxEnergyStored()) / 3.0f), (float)1.0f, (float)1.0f);
    }

    public boolean isDamaged(ItemStack stack) {
        return stack.func_77952_i() != 1;
    }

    public void setDamage(ItemStack stack, int damage) {
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        items.add((Object)new ItemStack((Item)this, 1, 0));
        ItemStack fullyCharged = new ItemStack((Item)this, 1, 0);
        IEnergyStorage energy = (IEnergyStorage)fullyCharged.getCapability(CapabilityEnergy.ENERGY, null);
        energy.receiveEnergy(energy.getMaxEnergyStored(), false);
        items.add((Object)fullyCharged);
        items.add((Object)new ItemStack((Item)this, 1, 1));
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        if (stack.func_77952_i() != 1) {
            IEnergyStorage energy = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
            tooltip.add(I18n.func_135052_a((String)"misc.refinedstorage:energy_stored", (Object[])new Object[]{energy.getEnergyStored(), energy.getMaxEnergyStored()}));
        }
    }
}

