/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs4.plugins.vanilla.crafting;

import cubex2.cs4.api.SlotProvider;
import cubex2.cs4.plugins.vanilla.crafting.CraftingManagerCS4;
import cubex2.cs4.plugins.vanilla.crafting.InventoryCraftingWrapper;
import cubex2.cs4.plugins.vanilla.crafting.SlotItemHandlerCrafting;
import cubex2.cs4.plugins.vanilla.tileentity.ItemHandlerTileEntity;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemHandlerCrafting
extends ItemHandlerTileEntity
implements SlotProvider {
    private final int rows;
    private final int columns;
    private final ResourceLocation recipeList;
    private World world;

    public ItemHandlerCrafting(TileEntity tile, int rows, int columns, ResourceLocation recipeList) {
        super(rows * columns + 1, tile);
        this.rows = rows;
        this.columns = columns;
        this.recipeList = recipeList;
    }

    public void setWorld(World world) {
        this.world = world;
    }

    public int getWidth() {
        return this.columns;
    }

    public int getHeight() {
        return this.rows;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (slot >= this.rows * this.columns) {
            return stack;
        }
        return super.insertItem(slot, stack, simulate);
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (slot == this.rows * this.columns) {
            ItemStack result = this.getCraftResult();
            if (result.func_190926_b() || amount < result.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            amount = result.func_190916_E();
            if (!simulate) {
                this.removeItems();
                this.setStackInSlot(this.rows * this.columns, ItemStack.field_190927_a);
                return ItemHandlerHelper.copyStackWithSize((ItemStack)result, (int)amount);
            }
        }
        return super.extractItem(slot, amount, simulate);
    }

    void removeItems() {
        for (int i = 0; i < this.rows * this.columns; ++i) {
            this.extractItem(i, 1, false);
        }
    }

    @Override
    protected void onContentsChanged(int slot) {
        this.setStackInSlot(this.rows * this.columns, this.getCraftResult());
        this.tile.func_70296_d();
    }

    private ItemStack getCraftResult() {
        InventoryCraftingWrapper wrapper = new InventoryCraftingWrapper(this);
        return CraftingManagerCS4.findMatchingRecipe(this.recipeList, (InventoryCrafting)wrapper, this.world);
    }

    @Override
    public Optional<Slot> createSlot(int index, int x, int y) {
        if (index == this.rows * this.columns) {
            return Optional.of(new SlotItemHandlerCrafting(this, index, x, y));
        }
        return Optional.empty();
    }
}

