/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.gui.elements;

import blusunrize.immersiveengineering.client.ClientUtils;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import org.lwjgl.input.Mouse;

public class GuiReactiveList
extends GuiButton {
    private final GuiScreen gui;
    private String[] entries;
    private int[] padding = new int[]{0, 0, 0, 0};
    private boolean needsSlider = false;
    private int perPage;
    private Function<String, String> translationFunction;
    private int scrollMode = 0;
    private float textScale = 1.0f;
    private boolean unicode = false;
    private int offset;
    private int maxOffset;
    private long prevWheelNano = 0L;
    private int targetEntry = -1;
    private int hoverTimer = 0;
    public int selectedOption = -1;

    public GuiReactiveList(GuiScreen gui, int id, int x, int y, int w, int h, String ... entries) {
        super(id, x, y, w, h, "");
        this.gui = gui;
        this.entries = entries;
        this.recalculateEntries();
    }

    private void recalculateEntries() {
        this.perPage = (int)((float)(this.field_146121_g - this.padding[0] - this.padding[1]) / ((float)ClientUtils.mc().field_71466_p.field_78288_b * this.textScale));
        if (this.perPage < this.entries.length) {
            this.needsSlider = true;
            this.maxOffset = this.entries.length - this.perPage;
        } else {
            this.needsSlider = false;
        }
    }

    public GuiReactiveList setPadding(int up, int down, int left, int right) {
        this.padding[0] = up;
        this.padding[1] = down;
        this.padding[2] = left;
        this.padding[3] = right;
        this.recalculateEntries();
        return this;
    }

    public GuiReactiveList setTranslationFunc(Function<String, String> func) {
        this.translationFunction = func;
        return this;
    }

    public GuiReactiveList setScrollMode(int mode) {
        this.scrollMode = mode;
        return this;
    }

    public GuiReactiveList setFormatting(float textScale, boolean unicode) {
        this.textScale = textScale;
        this.unicode = unicode;
        this.recalculateEntries();
        return this;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public int getMaxOffset() {
        return this.maxOffset;
    }

    public void func_191745_a(Minecraft mc, int mx, int my, float partialTicks) {
        FontRenderer fr = ClientUtils.mc().field_71466_p;
        boolean uni = fr.func_82883_a();
        fr.func_78264_a(this.unicode);
        int mmY = my - this.field_146129_i;
        int strWidth = this.field_146120_f - this.padding[2] - this.padding[3] - (this.needsSlider ? 6 : 0);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        if (this.needsSlider) {
            ClientUtils.bindTexture("immersiveengineering:textures/gui/hud_elements.png");
            this.func_73729_b(this.field_146128_h + this.field_146120_f - 6, this.field_146129_i, 16, 136, 6, 4);
            this.func_73729_b(this.field_146128_h + this.field_146120_f - 6, this.field_146129_i + this.field_146121_g - 4, 16, 144, 6, 4);
            for (int i = 0; i < this.field_146121_g - 8; i += 2) {
                this.func_73729_b(this.field_146128_h + this.field_146120_f - 6, this.field_146129_i + 4 + i, 16, 141, 6, 2);
            }
            int sliderSize = Math.max(6, this.field_146121_g - this.maxOffset * fr.field_78288_b);
            float silderShift = (float)(this.field_146121_g - sliderSize) / (float)this.maxOffset * (float)this.offset;
            this.func_175174_a(this.field_146128_h + this.field_146120_f - 5, (float)this.field_146129_i + silderShift + 1.0f, 20, 129, 4, 2);
            this.func_175174_a(this.field_146128_h + this.field_146120_f - 5, (float)this.field_146129_i + silderShift + (float)sliderSize - 4.0f, 20, 132, 4, 3);
            for (int i = 0; i < sliderSize - 7; ++i) {
                this.func_175174_a(this.field_146128_h + this.field_146120_f - 5, (float)this.field_146129_i + silderShift + 3.0f + (float)i, 20, 131, 4, 1);
            }
        }
        GlStateManager.func_179152_a((float)this.textScale, (float)this.textScale, (float)1.0f);
        this.field_146123_n = mx >= this.field_146128_h && mx < this.field_146128_h + this.field_146120_f && my >= this.field_146129_i && my < this.field_146129_i + this.field_146121_g;
        boolean hasTarget = false;
        for (int i = 0; i < Math.min(this.perPage, this.entries.length); ++i) {
            String s;
            int overLength;
            boolean selectionHover;
            int j = this.offset + i;
            int col = 0xE0E0E0;
            boolean bl = selectionHover = this.field_146123_n && mmY >= i * fr.field_78288_b && mmY < (i + 1) * fr.field_78288_b;
            if (selectionHover) {
                hasTarget = true;
                if (this.targetEntry != j) {
                    this.targetEntry = j;
                    this.hoverTimer = 0;
                } else {
                    ++this.hoverTimer;
                }
                col = -557004;
            }
            if (j > this.entries.length - 1) {
                j = this.entries.length - 1;
            }
            if ((overLength = (s = this.translationFunction != null ? this.translationFunction.apply(this.entries[j]) : this.entries[j]).length() - fr.func_78259_e(s, strWidth)) > 0) {
                if (selectionHover && this.hoverTimer > 20) {
                    int textOffset = this.hoverTimer / 10 % s.length();
                    s = s.substring(textOffset) + " " + s.substring(0, textOffset);
                }
                s = fr.func_78269_a(s, strWidth);
            }
            float tx = (float)(this.field_146128_h + this.padding[2]) / this.textScale;
            float ty = (float)(this.field_146129_i + this.padding[0] + fr.field_78288_b * i) / this.textScale;
            GlStateManager.func_179109_b((float)tx, (float)ty, (float)0.0f);
            fr.func_175065_a(s, 0.0f, 0.0f, col, false);
            GlStateManager.func_179109_b((float)(-tx), (float)(-ty), (float)0.0f);
        }
        GlStateManager.func_179152_a((float)(1.0f / this.textScale), (float)(1.0f / this.textScale), (float)1.0f);
        if (!hasTarget) {
            this.targetEntry = -1;
            this.hoverTimer = 0;
        }
        fr.func_78264_a(uni);
        int mouseWheel = Mouse.getEventDWheel();
        if (mouseWheel != 0 && this.maxOffset > 0 && Mouse.getEventNanoseconds() != this.prevWheelNano) {
            this.prevWheelNano = Mouse.getEventNanoseconds();
            if (mouseWheel < 0 && this.offset < this.maxOffset) {
                ++this.offset;
            }
            if (mouseWheel > 0 && this.offset > 0) {
                --this.offset;
            }
        }
    }

    public boolean func_146116_c(Minecraft mc, int mx, int my) {
        boolean b = super.func_146116_c(mc, mx, my);
        FontRenderer fr = ClientUtils.mc().field_71466_p;
        this.selectedOption = -1;
        if (b) {
            int mmY = my - this.field_146129_i;
            for (int i = 0; i < Math.min(this.perPage, this.entries.length); ++i) {
                if (mmY < i * fr.field_78288_b || mmY >= (i + 1) * fr.field_78288_b) continue;
                this.selectedOption = this.offset + i;
            }
        }
        return this.selectedOption != -1;
    }
}

