/*
 * Decompiled with CFR 0.152.
 */
package reborncore.client.multiblock;

import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.opengl.GL14;
import reborncore.client.multiblock.Multiblock;
import reborncore.client.multiblock.MultiblockSet;
import reborncore.client.multiblock.RebornFluidRenderer;
import reborncore.client.multiblock.component.MultiblockComponent;

public class MultiblockRenderEvent {
    public static BlockPos anchor;
    public MultiblockSet currentMultiblock;
    public BlockPos parent;
    RebornFluidRenderer fluidRenderer = new RebornFluidRenderer();
    private ICamera camera;

    public void setMultiblock(MultiblockSet set) {
        this.currentMultiblock = set;
        anchor = null;
        this.parent = null;
    }

    @SubscribeEvent
    public void onWorldRenderLast(RenderWorldLastEvent event) throws Throwable {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g != null && mc.field_71476_x != null && !mc.field_71439_g.func_70093_af() && this.currentMultiblock != null) {
            BlockPos anchorPos = anchor != null ? anchor : mc.field_71476_x.func_178782_a();
            Multiblock mb = this.currentMultiblock.getForIndex(0);
            for (MultiblockComponent comp : mb.getComponents()) {
                if (comp.state.func_185901_i() != EnumBlockRenderType.LIQUID) continue;
                this.renderComponent(comp, anchorPos.func_177984_a(), event.getPartialTicks(), mc.field_71439_g);
            }
            for (MultiblockComponent comp : mb.getComponents()) {
                if (comp.state.func_185901_i() == EnumBlockRenderType.LIQUID) continue;
                this.renderComponent(comp, anchorPos.func_177984_a(), event.getPartialTicks(), mc.field_71439_g);
            }
        }
    }

    private void renderComponent(MultiblockComponent comp, BlockPos anchor, float partialTicks, EntityPlayerSP player) {
        double dx = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks;
        double dy = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks;
        double dz = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks;
        if (this.camera == null) {
            this.camera = new Frustum();
        }
        this.camera.func_78547_a(dx, dy, dz);
        BlockPos pos = anchor.func_177971_a((Vec3i)comp.getRelativePosition());
        if (!this.camera.func_78546_a(new AxisAlignedBB(pos))) {
            return;
        }
        Minecraft minecraft = Minecraft.func_71410_x();
        World world = player.field_70170_p;
        minecraft.func_110434_K().func_110577_a(TextureMap.field_110575_b);
        BlockRenderLayer originalLayer = MinecraftForgeClient.getRenderLayer();
        ForgeHooksClient.setRenderLayer((BlockRenderLayer)BlockRenderLayer.CUTOUT);
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(-dx), (double)(-dy), (double)(-dz));
        GlStateManager.func_179109_b((float)pos.func_177958_n(), (float)pos.func_177956_o(), (float)pos.func_177952_p());
        GlStateManager.func_179139_a((double)0.8, (double)0.8, (double)0.8);
        GlStateManager.func_179137_b((double)0.2, (double)0.2, (double)0.2);
        RenderHelper.func_74518_a();
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.CONSTANT_ALPHA);
        GL14.glBlendColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.35f);
        this.renderModel(world, pos, comp.state);
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
        ForgeHooksClient.setRenderLayer((BlockRenderLayer)originalLayer);
    }

    private void renderModel(World world, BlockPos pos, IBlockState state) {
        BlockRendererDispatcher blockRendererDispatcher = Minecraft.func_71410_x().field_175618_aM;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        GlStateManager.func_179109_b((float)(-pos.func_177958_n()), (float)(-pos.func_177956_o()), (float)(-pos.func_177952_p()));
        buffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        if (state.func_185901_i() == EnumBlockRenderType.LIQUID) {
            this.fluidRenderer.func_178270_a((IBlockAccess)world, state, pos, buffer);
        } else {
            blockRendererDispatcher.func_175018_a(state, pos, (IBlockAccess)world, buffer);
        }
        tessellator.func_78381_a();
    }

    @SubscribeEvent
    public void breakBlock(BlockEvent.BreakEvent event) {
        if (this.parent != null && event.getPos().func_177958_n() == this.parent.func_177958_n() && event.getPos().func_177956_o() == this.parent.func_177956_o() && event.getPos().func_177952_p() == this.parent.func_177952_p()) {
            this.setMultiblock(null);
        }
    }

    @SubscribeEvent
    public void worldUnloaded(WorldEvent.Unload event) {
        this.setMultiblock(null);
    }
}

