/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.blocks;

import micdoodle8.mods.galacticraft.core.blocks.BlockMachineBase;
import micdoodle8.mods.galacticraft.core.tile.IMachineSides;
import micdoodle8.mods.galacticraft.core.tile.IMachineSidesProperties;
import micdoodle8.mods.galacticraft.core.tile.TileEntityElectricFurnace;
import micdoodle8.mods.galacticraft.core.tile.TileEntityEnergyStorageModule;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockMachineTiered
extends BlockMachineBase {
    public static final PropertyEnum<EnumTieredMachineType> TYPE = PropertyEnum.func_177709_a((String)"type", EnumTieredMachineType.class);
    public static IMachineSidesProperties MACHINESIDES_RENDERTYPE = IMachineSidesProperties.TWOFACES_HORIZ;
    public static final PropertyEnum SIDES = BlockMachineTiered.MACHINESIDES_RENDERTYPE.asProperty;
    public static final PropertyInteger FILL_VALUE = PropertyInteger.func_177719_a((String)"fill_value", (int)0, (int)33);

    public BlockMachineTiered(String assetName) {
        super(assetName);
    }

    @Override
    protected void initialiseTypes() {
        this.types = EnumTieredMachineType.values;
        this.typeBase = EnumTieredMachineType.values[0];
    }

    @Override
    public TileEntity createTileEntity(World world, IBlockState state) {
        TileEntity tile = super.createTileEntity(world, state);
        tile.func_145834_a(world);
        return tile;
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_176731_b((int)(meta % 4));
        EnumTieredMachineType type = (EnumTieredMachineType)this.typeBase.fromMetadata(meta);
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing).func_177226_a(TYPE, (Comparable)((Object)type));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b() + ((EnumTieredMachineType)((Object)state.func_177229_b(TYPE))).getMetadata();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, TYPE, FILL_VALUE, SIDES});
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntity tile = worldIn.func_175625_s(pos);
        state = IMachineSides.addPropertyForTile(state, tile, MACHINESIDES_RENDERTYPE, (PropertyEnum<IMachineSidesProperties.MachineSidesModel>)SIDES);
        if (!(tile instanceof TileEntityEnergyStorageModule)) {
            return state.func_177226_a((IProperty)FILL_VALUE, (Comparable)Integer.valueOf(0));
        }
        int energyLevel = ((TileEntityEnergyStorageModule)tile).scaledEnergyLevel;
        if (state.func_177229_b(TYPE) == EnumTieredMachineType.STORAGE_CLUSTER) {
            energyLevel += 17;
        }
        return state.func_177226_a((IProperty)FILL_VALUE, (Comparable)Integer.valueOf(energyLevel));
    }

    public static enum EnumTieredMachineType implements BlockMachineBase.EnumMachineBase,
    IStringSerializable
    {
        STORAGE_MODULE(0, "energy_storage", TileEntityEnergyStorageModule::new, "tile.energy_storage_module_tier1.description", "tile.machine.1"),
        ELECTRIC_FURNACE(4, "electric_furnace", TileEntityElectricFurnace::new, "tile.electric_furnace_tier1.description", "tile.machine.2"),
        STORAGE_CLUSTER(8, "cluster_storage", TileEntityEnergyStorageModule::new, "tile.energy_storage_module_tier2.description", "tile.machine.8"),
        ARC_FURNACE(12, "arc_furnace", TileEntityElectricFurnace::new, "tile.electric_furnace_tier2.description", "tile.machine.7");

        private final int meta;
        private final String name;
        private TileConstructor tile;
        private final String shiftDescriptionKey;
        private final String blockName;
        private static final EnumTieredMachineType[] values;

        private EnumTieredMachineType(int meta, String name, TileConstructor tc, String key, String blockName) {
            this.meta = meta;
            this.name = name;
            this.tile = tc;
            this.shiftDescriptionKey = key;
            this.blockName = blockName;
        }

        @Override
        public int getMetadata() {
            return this.meta;
        }

        @Override
        public BlockMachineBase.EnumMachineBase fromMetadata(int meta) {
            return values[meta / 4 % values.length];
        }

        public String func_176610_l() {
            return this.name;
        }

        @Override
        public TileEntity tileConstructor() {
            int tier = this.meta / 8 + 1;
            return this.tile.create(tier);
        }

        @Override
        public String getShiftDescriptionKey() {
            return this.shiftDescriptionKey;
        }

        @Override
        public String getUnlocalizedName() {
            return this.blockName;
        }

        static {
            values = EnumTieredMachineType.values();
        }

        @FunctionalInterface
        private static interface TileConstructor {
            public TileEntity create(int var1);
        }
    }
}

