/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes.jei.bottler;

import forestry.factory.recipes.jei.bottler.BottlerRecipeWrapper;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.ingredients.IIngredientRegistry;
import mezz.jei.api.ingredients.VanillaTypes;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class BottlerRecipeMaker {
    private BottlerRecipeMaker() {
    }

    public static List<BottlerRecipeWrapper> getBottlerRecipes(IIngredientRegistry ingredientRegistry) {
        ArrayList<BottlerRecipeWrapper> recipes = new ArrayList<BottlerRecipeWrapper>();
        for (ItemStack stack : ingredientRegistry.getAllIngredients(VanillaTypes.ITEM)) {
            IFluidHandlerItem fillingCapability;
            FluidStack drainedFluid;
            IFluidHandlerItem fluidHandler;
            if (!stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null) || (fluidHandler = (IFluidHandlerItem)stack.func_77946_l().getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) == null) continue;
            if (BottlerRecipeMaker.hasDrainProperty((IFluidHandler)fluidHandler) && (drainedFluid = fluidHandler.drain(Integer.MAX_VALUE, true)) != null) {
                ItemStack drained = fluidHandler.getContainer();
                recipes.add(new BottlerRecipeWrapper(stack, drainedFluid, drained, false));
            }
            if (!BottlerRecipeMaker.hasFillProperty((IFluidHandler)fluidHandler) || (fillingCapability = (IFluidHandlerItem)stack.func_77946_l().getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) == null) continue;
            for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
                int testFill = fillingCapability.fill(new FluidStack(fluid, Integer.MAX_VALUE), false);
                if (testFill <= 0) continue;
                IFluidHandlerItem copiedCap = (IFluidHandlerItem)stack.func_77946_l().getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
                int fill = copiedCap.fill(new FluidStack(fluid, Integer.MAX_VALUE), true);
                FluidStack filledFluid = new FluidStack(fluid, fill);
                ItemStack filled = copiedCap.getContainer();
                recipes.add(new BottlerRecipeWrapper(stack, filledFluid, filled, true));
            }
        }
        return recipes;
    }

    private static boolean hasDrainProperty(IFluidHandler fluidHandler) {
        for (IFluidTankProperties properties : fluidHandler.getTankProperties()) {
            if (!properties.canDrain()) continue;
            return true;
        }
        return false;
    }

    private static boolean hasFillProperty(IFluidHandler fluidHandler) {
        for (IFluidTankProperties properties : fluidHandler.getTankProperties()) {
            if (!properties.canFill()) continue;
            return true;
        }
        return false;
    }
}

