/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.network.messages;

import io.netty.buffer.ByteBuf;
import lumien.randomthings.network.IRTMessage;
import lumien.randomthings.network.MessageUtil;
import lumien.randomthings.tileentity.TileEntityChatDetector;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class MessageChatDetector
implements IRTMessage {
    String chatMessage;
    boolean consume;
    BlockPos pos;

    public MessageChatDetector() {
    }

    public MessageChatDetector(String chatMessage, boolean consume, BlockPos pos) {
        this.chatMessage = chatMessage;
        this.pos = pos;
        this.consume = consume;
    }

    public void toBytes(ByteBuf buffer) {
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.chatMessage);
        buffer.writeBoolean(this.consume);
        MessageUtil.writeBlockPos(this.pos, buffer);
    }

    public void fromBytes(ByteBuf buffer) {
        this.chatMessage = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        this.consume = buffer.readBoolean();
        this.pos = MessageUtil.readBlockPos(buffer);
    }

    @Override
    public void onMessage(final MessageContext ctx) {
        FMLCommonHandler.instance().getMinecraftServerInstance().func_152344_a(new Runnable(){

            @Override
            public void run() {
                EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                World worldObj = player.field_70170_p;
                TileEntity te = worldObj.func_175625_s(MessageChatDetector.this.pos);
                if (te != null && te instanceof TileEntityChatDetector && MessageChatDetector.this.pos.func_177951_i((Vec3i)player.func_180425_c()) < 100.0) {
                    TileEntityChatDetector od = (TileEntityChatDetector)worldObj.func_175625_s(MessageChatDetector.this.pos);
                    od.setChatMessage(MessageChatDetector.this.chatMessage);
                    od.setConsume(MessageChatDetector.this.consume);
                }
            }
        });
    }

    @Override
    public Side getHandlingSide() {
        return Side.SERVER;
    }
}

