/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.light;

import codechicken.lib.model.ModelRegistryHelper;
import codechicken.lib.model.bakery.CCBakeryModel;
import codechicken.lib.model.bakery.IBakeryProvider;
import codechicken.lib.model.bakery.ModelBakery;
import codechicken.lib.model.bakery.ModelErrorStateProperty;
import codechicken.lib.model.bakery.generation.IBakery;
import cofh.core.block.BlockCore;
import cofh.core.render.IModelRegister;
import cofh.core.util.helpers.ItemHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.BlockTEBase;
import cofh.thermalexpansion.block.light.ItemBlockLight;
import cofh.thermalexpansion.block.light.TileLightBase;
import cofh.thermalexpansion.init.TEProps;
import cofh.thermalexpansion.render.BakeryLight;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BlockLight
extends BlockTEBase
implements IModelRegister,
IBakeryProvider {
    public static final PropertyEnum<Type> VARIANT = PropertyEnum.func_177709_a((String)"type", Type.class);
    public static boolean[] enable = new boolean[Type.values().length];
    public static ItemStack lightIlluminator;
    public static ItemStack lightLumiumLamp;
    public static ItemStack lightRadiantLamp;
    public static ItemBlockLight itemBlock;
    public static final int ILLUMINATOR = 0;
    public static final int LUMIUM_LAMP = 1;
    public static final int RADIANT_LAMP = 2;

    public BlockLight() {
        super(Material.field_151591_t);
        this.func_149663_c("light");
        this.func_149711_c(3.0f);
        this.func_149752_b(150.0f);
        this.func_149672_a(SoundType.field_185853_f);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)Type.ILLUMINATOR)));
        this.configGui = true;
    }

    protected BlockStateContainer func_180661_e() {
        BlockStateContainer.Builder builder = new BlockStateContainer.Builder((Block)this);
        builder.add(new IProperty[]{VARIANT});
        builder.add(new IUnlistedProperty[]{ModelErrorStateProperty.ERROR_STATE});
        builder.add(new IUnlistedProperty[]{TEProps.TILE_LIGHT});
        return builder.build();
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        for (int i = 0; i < Type.values().length; ++i) {
            items.add((Object)itemBlock.setDefaultTag(new ItemStack((Block)this, 1, i)));
        }
    }

    public String getUnlocalizedName(ItemStack stack) {
        return "tile.thermalexpansion.light." + Type.values()[ItemHelper.getItemDamage((ItemStack)stack)].func_176610_l() + ".name";
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)Type.values()[meta]));
    }

    public int func_176201_c(IBlockState state) {
        return ((Type)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    public int func_180651_a(IBlockState state) {
        return ((Type)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        if (state.func_177230_c().func_176201_c(state) >= Type.values().length) {
            return null;
        }
        return new TileLightBase();
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    public boolean shouldCheckWeakPower(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return layer == BlockRenderLayer.SOLID || layer == BlockRenderLayer.CUTOUT || layer == BlockRenderLayer.TRANSLUCENT;
    }

    @SideOnly(value=Side.CLIENT)
    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        return ModelBakery.handleExtendedState((IExtendedBlockState)((IExtendedBlockState)super.getExtendedState(state, world, pos)), (IBlockAccess)world, (BlockPos)pos);
    }

    public IBakery getBakery() {
        return BakeryLight.INSTANCE;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        StateMap.Builder stateMap = new StateMap.Builder();
        stateMap.func_178442_a(new IProperty[]{VARIANT});
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)stateMap.func_178441_a());
        ModelResourceLocation location = new ModelResourceLocation(this.getRegistryName(), "normal");
        for (Type type : Type.values()) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)type.getMetadata(), (ModelResourceLocation)location);
        }
        ModelRegistryHelper.register((ModelResourceLocation)location, (IBakedModel)new CCBakeryModel());
        ModelBakery.registerBlockKeyGenerator((Block)this, state -> {
            TileLightBase tile = (TileLightBase)((Object)((Object)state.getValue(TEProps.TILE_LIGHT)));
            StringBuilder builder = new StringBuilder(state.func_177230_c().getRegistryName().toString() + "|" + state.func_177230_c().func_176201_c((IBlockState)state));
            builder.append(",color=").append(tile.color);
            builder.append(",light=").append(tile.getInternalLight());
            return builder.toString();
        });
        ModelBakery.registerItemKeyGenerator((Item)itemBlock, stack -> ModelBakery.defaultItemKeyGenerator.generateKey(stack));
    }

    public boolean preInit() {
        this.setRegistryName("light");
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)this);
        itemBlock = new ItemBlockLight((BlockCore)this);
        itemBlock.setRegistryName(this.getRegistryName());
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)itemBlock);
        ThermalExpansion.proxy.addIModelRegister(this);
        return true;
    }

    public boolean initialize() {
        lightIlluminator = itemBlock.setDefaultTag(new ItemStack((Block)this, 1, Type.ILLUMINATOR.getMetadata()));
        lightLumiumLamp = itemBlock.setDefaultTag(new ItemStack((Block)this, 1, Type.LUMIUM_LAMP.getMetadata()));
        lightRadiantLamp = itemBlock.setDefaultTag(new ItemStack((Block)this, 1, Type.RADIANT_LAMP.getMetadata()));
        this.addRecipes();
        return true;
    }

    private void addRecipes() {
    }

    public static enum Type implements IStringSerializable
    {
        ILLUMINATOR(0, "illuminator"),
        LUMIUM_LAMP(1, "lumium_lamp"),
        RADIANT_LAMP(2, "radiant_lamp");

        private final int metadata;
        private final String name;

        private Type(int metadata, String name) {
            this.metadata = metadata;
            this.name = name;
        }

        public int getMetadata() {
            return this.metadata;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

