/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.renderer.block.canvas;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.property.IUnlistedProperty;
import openblocks.client.renderer.block.canvas.CanvasSideState;

public class CanvasState {
    public static final IUnlistedProperty<CanvasState> PROPERTY = new IUnlistedProperty<CanvasState>(){

        public String getName() {
            return "sides";
        }

        public boolean isValid(CanvasState value) {
            return true;
        }

        public Class<CanvasState> getType() {
            return CanvasState.class;
        }

        public String valueToString(CanvasState value) {
            return value.toString();
        }
    };
    public static final CanvasState EMPTY = new CanvasState((Map<EnumFacing, CanvasSideState>)ImmutableMap.of());
    public final Map<EnumFacing, CanvasSideState> sideStates;

    private CanvasState(Map<EnumFacing, CanvasSideState> sideStates) {
        this.sideStates = sideStates;
    }

    public CanvasState update(EnumFacing side, CanvasSideState sideState) {
        CanvasSideState oldSideState = this.sideStates.get(side);
        if (oldSideState != null) {
            oldSideState.release();
        }
        sideState.acquire();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)side, (Object)sideState);
        for (Map.Entry<EnumFacing, CanvasSideState> e : this.sideStates.entrySet()) {
            if (e.getKey() == side) continue;
            builder.put(e);
        }
        return new CanvasState((Map<EnumFacing, CanvasSideState>)builder.build());
    }

    public void acquire() {
        for (CanvasSideState side : this.sideStates.values()) {
            side.acquire();
        }
    }

    public void release() {
        for (CanvasSideState sideState : this.sideStates.values()) {
            sideState.release();
        }
    }

    public void onRender() {
        for (CanvasSideState sideState : this.sideStates.values()) {
            sideState.onRender();
        }
    }

    public int hashCode() {
        return this.sideStates.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof CanvasState) {
            CanvasState other = (CanvasState)obj;
            return this.sideStates.equals(other.sideStates);
        }
        return false;
    }

    public String toString() {
        ArrayList elements = Lists.newArrayListWithExpectedSize((int)6);
        for (Map.Entry<EnumFacing, CanvasSideState> e : this.sideStates.entrySet()) {
            elements.add(e.getKey() + ":" + e.getValue());
        }
        return "[" + Joiner.on((String)", ").join((Iterable)elements) + "]";
    }

    public Collection<EnumFacing> applicationOrder() {
        return this.sideStates.keySet();
    }
}

