/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.item;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import openblocks.Config;
import openblocks.common.entity.EntityGlyph;
import openmods.geometry.BlockTextureTransform;
import openmods.utils.TranslationUtils;
import org.apache.commons.lang3.ArrayUtils;

public class ItemGlyph
extends Item {
    public static final char[] ALMOST_ASCII = "\u00c0\u00c1\u00c2\u00c8\u00ca\u00cb\u00cd\u00d3\u00d4\u00d5\u00da\u00df\u00e3\u00f5\u011f\u0130\u0131\u0152\u0153\u015e\u015f\u0174\u0175\u017e\u0207\u0000\u0000\u0000\u0000\u0000\u0000\u0000 !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u0000\u00c7\u00fc\u00e9\u00e2\u00e4\u00e0\u00e5\u00e7\u00ea\u00eb\u00e8\u00ef\u00ee\u00ec\u00c4\u00c5\u00c9\u00e6\u00c6\u00f4\u00f6\u00f2\u00fb\u00f9\u00ff\u00d6\u00dc\u00f8\u00a3\u00d8\u00d7\u0192\u00e1\u00ed\u00f3\u00fa\u00f1\u00d1\u00aa\u00ba\u00bf\u00ae\u00ac\u00bd\u00bc\u00a1\u00ab\u00bb\u2591\u2592\u2593\u2502\u2524\u2561\u2562\u2556\u2555\u2563\u2551\u2557\u255d\u255c\u255b\u2510\u2514\u2534\u252c\u251c\u2500\u253c\u255e\u255f\u255a\u2554\u2569\u2566\u2560\u2550\u256c\u2567\u2568\u2564\u2565\u2559\u2558\u2552\u2553\u256b\u256a\u2518\u250c\u2588\u2584\u258c\u2590\u2580\u03b1\u03b2\u0393\u03c0\u03a3\u03c3\u03bc\u03c4\u03a6\u0398\u03a9\u03b4\u221e\u2205\u2208\u2229\u2261\u00b1\u2265\u2264\u2320\u2321\u00f7\u2248\u00b0\u2219\u00b7\u221a\u207f\u00b2\u25a0\u0000".toCharArray();
    private static final char[] DISPLAY_CHARS = " 0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".toCharArray();
    private static final char DEFAULT_CHAR = '?';
    public static final int DEFAULT_CHAR_INDEX = ItemGlyph.getCharIndex('?');
    private final BlockTextureTransform transform = BlockTextureTransform.builder().build();

    private static int getCharIndex(char ch) {
        int result = ArrayUtils.indexOf((char[])ALMOST_ASCII, (char)ch);
        return result != -1 ? result : DEFAULT_CHAR_INDEX;
    }

    public static boolean isHiddenCharacter(char ch) {
        return ch != ' ' && (ch == '\u0000' || Character.isWhitespace(ch));
    }

    private static char getChar(int index) {
        if (index >= 0 && index < ALMOST_ASCII.length) {
            return ALMOST_ASCII[index];
        }
        return '?';
    }

    public ItemGlyph() {
        this.func_77627_a(true);
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        char ch = ItemGlyph.getChar(ItemGlyph.getCharIndex(stack));
        tooltip.add(String.format("%04X (%s)", ch, Character.getName(ch)));
    }

    public String func_77653_i(ItemStack stack) {
        int index = ItemGlyph.getCharIndex(stack);
        if (index == DEFAULT_CHAR_INDEX) {
            return super.func_77653_i(stack);
        }
        char ch = ItemGlyph.getChar(index);
        return TranslationUtils.translateToLocalFormatted((String)"item.openblocks.glyph.with_char", (Object[])new Object[]{Character.valueOf(ch)});
    }

    public static ItemStack createStack(Item item, int size, char ch) {
        return new ItemStack(item, size, ItemGlyph.getCharIndex(ch));
    }

    public static ItemStack createStack(Item item, char ch) {
        return ItemGlyph.createStack(item, 1, ch);
    }

    public static ItemStack createStack(Item item, int charIndex) {
        return new ItemStack(item, 1, charIndex);
    }

    public static int getCharIndex(ItemStack item) {
        return item.func_77952_i();
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        block3: {
            block2: {
                if (!Config.showGlypsInSearch || tab != CreativeTabs.field_78027_g) break block2;
                for (int i = 0; i < ALMOST_ASCII.length; ++i) {
                    char ch = ALMOST_ASCII[i];
                    if (ItemGlyph.isHiddenCharacter(ch)) continue;
                    items.add((Object)ItemGlyph.createStack((Item)this, i));
                }
                break block3;
            }
            if (!ArrayUtils.contains((Object[])this.getCreativeTabs(), (Object)tab)) break block3;
            for (char ch : DISPLAY_CHARS) {
                items.add((Object)ItemGlyph.createStack((Item)this, ch));
            }
        }
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        BlockPos blockpos = pos.func_177972_a(facing);
        if (facing != EnumFacing.DOWN && facing != EnumFacing.UP && player.func_175151_a(blockpos, facing, stack)) {
            BlockTextureTransform.TexCoords localHit = this.transform.worldVecToTextureCoords(facing, (double)hitX, (double)hitY, (double)hitZ);
            byte xOffset = (byte)(localHit.u * 16.0);
            byte yOffset = (byte)(16.0 - localHit.v * 16.0);
            EntityGlyph entityhanging = new EntityGlyph(worldIn, blockpos, facing, ItemGlyph.getCharIndex(stack), xOffset, yOffset);
            if (entityhanging.func_70518_d()) {
                if (!worldIn.field_72995_K) {
                    entityhanging.func_184523_o();
                    worldIn.func_72838_d((Entity)entityhanging);
                }
                stack.func_190918_g(1);
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    @SideOnly(value=Side.CLIENT)
    public static class ColorHandler
    implements IItemColor {
        public int func_186726_a(@Nonnull ItemStack stack, int tintIndex) {
            return 0;
        }
    }
}

