/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.client;

import icbm.classic.CommonProxy;
import icbm.classic.ICBMClassic;
import icbm.classic.client.fx.ParticleSmokeICBM;
import icbm.classic.client.render.entity.RenderCreeperXmas;
import icbm.classic.client.render.entity.RenderEntityBlock;
import icbm.classic.client.render.entity.RenderExBlock;
import icbm.classic.client.render.entity.RenderExplosion;
import icbm.classic.client.render.entity.RenderFragments;
import icbm.classic.client.render.entity.RenderGrenade;
import icbm.classic.client.render.entity.RenderLightBeam;
import icbm.classic.client.render.entity.RenderMissile;
import icbm.classic.client.render.entity.RenderSeat;
import icbm.classic.client.render.entity.RenderSkeletonXmas;
import icbm.classic.client.render.entity.RenderSnowmanXmas;
import icbm.classic.client.render.entity.RenderZombieXmas;
import icbm.classic.content.entity.EntityExplosion;
import icbm.classic.content.entity.EntityExplosive;
import icbm.classic.content.entity.EntityFlyingBlock;
import icbm.classic.content.entity.EntityFragments;
import icbm.classic.content.entity.EntityGrenade;
import icbm.classic.content.entity.EntityLightBeam;
import icbm.classic.content.entity.EntityPlayerSeat;
import icbm.classic.content.entity.mobs.EntityXmasCreeper;
import icbm.classic.content.entity.mobs.EntityXmasSkeleton;
import icbm.classic.content.entity.mobs.EntityXmasSkeletonBoss;
import icbm.classic.content.entity.mobs.EntityXmasSnowman;
import icbm.classic.content.entity.mobs.EntityXmasZombie;
import icbm.classic.content.entity.mobs.EntityXmasZombieBoss;
import icbm.classic.content.explosive.Explosives;
import icbm.classic.content.explosive.handlers.missiles.Missile;
import icbm.classic.content.explosive.tile.BlockExplosive;
import icbm.classic.content.items.ItemCrafting;
import icbm.classic.content.machines.emptower.TESREMPTower;
import icbm.classic.content.machines.emptower.TileEMPTower;
import icbm.classic.content.machines.launcher.base.TESRLauncherBase;
import icbm.classic.content.machines.launcher.base.TileLauncherBase;
import icbm.classic.content.machines.launcher.cruise.TESRCruiseLauncher;
import icbm.classic.content.machines.launcher.cruise.TileCruiseLauncher;
import icbm.classic.content.machines.launcher.frame.TESRLauncherFrame;
import icbm.classic.content.machines.launcher.frame.TileLauncherFrame;
import icbm.classic.content.machines.launcher.screen.TESRLauncherScreen;
import icbm.classic.content.machines.launcher.screen.TileLauncherScreen;
import icbm.classic.content.machines.radarstation.TESRRadarStation;
import icbm.classic.content.machines.radarstation.TileRadarStation;
import icbm.classic.content.missile.EntityMissile;
import icbm.classic.lib.transform.vector.Pos;
import icbm.classic.prefab.tile.BlockICBM;
import icbm.classic.prefab.tile.EnumTier;
import java.util.Collections;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.DefaultStateMapper;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.obj.OBJLoader;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ClientProxy
extends CommonProxy {
    @Override
    public void doLoadModels() {
        OBJLoader.INSTANCE.addDomain("icbmclassic");
        this.newBlockModel(ICBMClassic.blockReinforcedGlass, 0, "inventory", "");
        this.newBlockModel(ICBMClassic.blockGlassPlate, 0, "inventory", "");
        this.newBlockModel(ICBMClassic.blockGlassButton, 0, "inventory", "");
        this.newBlockModel(ICBMClassic.blockSpikes, 0, "inventory", "");
        this.newBlockModel(ICBMClassic.blockSpikes, 1, "inventory", "_poison");
        this.newBlockModel(ICBMClassic.blockSpikes, 2, "inventory", "_fire");
        this.newBlockModel(ICBMClassic.blockConcrete, 0, "inventory", "");
        this.newBlockModel(ICBMClassic.blockConcrete, 1, "inventory", "_compact");
        this.newBlockModel(ICBMClassic.blockConcrete, 2, "inventory", "_reinforced");
        this.newBlockModel(ICBMClassic.blockBattery, 0, "inventory", "");
        this.newBlockModel(ICBMClassic.blockCruiseLauncher, 0, "inventory", "");
        this.registerExBlockRenders();
        this.registerGrenadeRenders();
        this.registerCartRenders();
        this.registerMissileRenders();
        this.newBlockModel(ICBMClassic.blockEmpTower, 0, "inventory", "");
        this.newBlockModel(ICBMClassic.blockRadarStation, 0, "inventory", "");
        this.newBlockModel(ICBMClassic.blockBattery, 0, "inventory", "");
        this.registerLauncherPart(ICBMClassic.blockLaunchBase);
        this.registerLauncherPart(ICBMClassic.blockLaunchSupport);
        this.registerLauncherPart(ICBMClassic.blockLaunchScreen);
        this.registerMultiBlockRenders();
        this.newItemModel(ICBMClassic.itemPoisonPowder, 0, "inventory", "");
        this.newItemModel(ICBMClassic.itemSulfurDust, 0, "inventory", "");
        this.newItemModel(ICBMClassic.itemSaltpeterDust, 0, "inventory", "");
        this.newItemModel(ICBMClassic.itemAntidote, 0, "inventory", "");
        this.newItemModel(ICBMClassic.itemSignalDisrupter, 0, "inventory", "");
        this.newItemModel(ICBMClassic.itemTracker, 0, "inventory", "");
        this.newItemModel(ICBMClassic.itemDefuser, 0, "inventory", "");
        this.newItemModel(ICBMClassic.itemRadarGun, 0, "inventory", "");
        this.newItemModel(ICBMClassic.itemRemoteDetonator, 0, "inventory", "");
        this.newItemModel(ICBMClassic.itemLaserDesignator, 0, "inventory", "");
        this.newItemModel(ICBMClassic.itemRocketLauncher, 0, "inventory", "");
        this.newItemModel(ICBMClassic.itemBattery, 0, "inventory", "");
        this.registerCraftingRender(ICBMClassic.itemIngot);
        this.registerCraftingRender(ICBMClassic.itemIngotClump);
        this.registerCraftingRender(ICBMClassic.itemPlate);
        this.registerCraftingRender(ICBMClassic.itemCircuit);
        this.registerCraftingRender(ICBMClassic.itemWire);
        RenderingRegistry.registerEntityRenderingHandler(EntityExplosive.class, manager -> new RenderExBlock(manager));
        RenderingRegistry.registerEntityRenderingHandler(EntityFlyingBlock.class, manager -> new RenderEntityBlock(manager));
        RenderingRegistry.registerEntityRenderingHandler(EntityExplosion.class, manager -> new RenderExplosion(manager));
        RenderingRegistry.registerEntityRenderingHandler(EntityGrenade.class, manager -> new RenderGrenade(manager));
        RenderingRegistry.registerEntityRenderingHandler(EntityLightBeam.class, manager -> new RenderLightBeam(manager));
        RenderingRegistry.registerEntityRenderingHandler(EntityFragments.class, manager -> new RenderFragments(manager));
        RenderingRegistry.registerEntityRenderingHandler(EntityPlayerSeat.class, manager -> new RenderSeat(manager));
        RenderingRegistry.registerEntityRenderingHandler(EntityMissile.class, manager -> {
            RenderMissile.INSTANCE = new RenderMissile(manager);
            return RenderMissile.INSTANCE;
        });
        RenderingRegistry.registerEntityRenderingHandler(EntityXmasSkeleton.class, manager -> new RenderSkeletonXmas(manager));
        RenderingRegistry.registerEntityRenderingHandler(EntityXmasSkeletonBoss.class, manager -> new RenderSkeletonXmas(manager));
        RenderingRegistry.registerEntityRenderingHandler(EntityXmasSnowman.class, manager -> new RenderSnowmanXmas(manager));
        RenderingRegistry.registerEntityRenderingHandler(EntityXmasZombie.class, manager -> new RenderZombieXmas(manager));
        RenderingRegistry.registerEntityRenderingHandler(EntityXmasZombieBoss.class, manager -> new RenderZombieXmas(manager));
        RenderingRegistry.registerEntityRenderingHandler(EntityXmasCreeper.class, manager -> new RenderCreeperXmas(manager));
        ClientRegistry.bindTileEntitySpecialRenderer(TileEMPTower.class, (TileEntitySpecialRenderer)new TESREMPTower());
        ClientRegistry.bindTileEntitySpecialRenderer(TileRadarStation.class, (TileEntitySpecialRenderer)new TESRRadarStation());
        ClientRegistry.bindTileEntitySpecialRenderer(TileLauncherFrame.class, (TileEntitySpecialRenderer)new TESRLauncherFrame());
        ClientRegistry.bindTileEntitySpecialRenderer(TileLauncherBase.class, (TileEntitySpecialRenderer)new TESRLauncherBase());
        ClientRegistry.bindTileEntitySpecialRenderer(TileLauncherScreen.class, (TileEntitySpecialRenderer)new TESRLauncherScreen());
        ClientRegistry.bindTileEntitySpecialRenderer(TileCruiseLauncher.class, (TileEntitySpecialRenderer)new TESRCruiseLauncher());
    }

    protected void registerMultiBlockRenders() {
        ModelLoader.setCustomStateMapper((Block)ICBMClassic.multiBlock, block -> Collections.emptyMap());
        ModelBakery.registerItemVariants((Item)Item.func_150898_a((Block)ICBMClassic.multiBlock), (ResourceLocation[])new ResourceLocation[0]);
    }

    protected void registerExBlockRenders() {
        final String resourcePath = ICBMClassic.blockExplosive.getRegistryName().toString();
        ModelLoader.setCustomStateMapper((Block)ICBMClassic.blockExplosive, (IStateMapper)new DefaultStateMapper(){

            protected ModelResourceLocation func_178132_a(IBlockState state) {
                return new ModelResourceLocation(resourcePath, this.func_178131_a((Map)state.func_177228_b()));
            }
        });
        for (Explosives ex : Explosives.values()) {
            if (!ex.handler.hasBlockForm()) continue;
            IBlockState state = ICBMClassic.blockExplosive.func_176223_P().func_177226_a((IProperty)BlockExplosive.EX_PROP, (Comparable)((Object)ex)).func_177226_a((IProperty)BlockICBM.ROTATION_PROP, (Comparable)EnumFacing.UP);
            String properties_string = ClientProxy.getPropertyString(state.func_177228_b(), new String[0]);
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)ICBMClassic.blockExplosive), (int)ex.ordinal(), (ModelResourceLocation)new ModelResourceLocation(resourcePath, properties_string));
        }
    }

    protected void registerLauncherPart(Block block) {
        final String resourcePath = block.getRegistryName().toString();
        ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)new DefaultStateMapper(){

            protected ModelResourceLocation func_178132_a(IBlockState state) {
                return new ModelResourceLocation(resourcePath, this.func_178131_a((Map)state.func_177228_b()));
            }
        });
        for (EnumTier tier : new EnumTier[]{EnumTier.ONE, EnumTier.TWO, EnumTier.THREE}) {
            IBlockState state = block.func_176223_P().func_177226_a((IProperty)BlockICBM.TIER_PROP, (Comparable)((Object)tier)).func_177226_a((IProperty)BlockICBM.ROTATION_PROP, (Comparable)EnumFacing.UP);
            String properties_string = ClientProxy.getPropertyString(state.func_177228_b(), new String[0]);
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)block), (int)tier.ordinal(), (ModelResourceLocation)new ModelResourceLocation(resourcePath, properties_string));
        }
    }

    protected void registerGrenadeRenders() {
        String resourcePath = ICBMClassic.itemGrenade.getRegistryName().toString();
        for (Explosives ex : Explosives.values()) {
            if (!ex.handler.hasGrenadeForm()) continue;
            String properties_string = "explosive=" + ex.func_176610_l();
            ModelLoader.setCustomModelResourceLocation((Item)ICBMClassic.itemGrenade, (int)ex.ordinal(), (ModelResourceLocation)new ModelResourceLocation(resourcePath, properties_string));
        }
    }

    protected void registerCartRenders() {
        String resourcePath = ICBMClassic.itemBombCart.getRegistryName().toString();
        for (Explosives ex : Explosives.values()) {
            if (!ex.handler.hasMinecartForm()) continue;
            String properties_string = "explosive=" + ex.func_176610_l();
            ModelLoader.setCustomModelResourceLocation((Item)ICBMClassic.itemBombCart, (int)ex.ordinal(), (ModelResourceLocation)new ModelResourceLocation(resourcePath, properties_string));
        }
    }

    protected void registerMissileRenders() {
        String resourcePath = ICBMClassic.itemMissile.getRegistryName().toString();
        for (Explosives ex : Explosives.values()) {
            if (!ex.handler.hasMissileForm()) continue;
            if (ex.handler instanceof Missile) {
                ModelLoader.setCustomModelResourceLocation((Item)ICBMClassic.itemMissile, (int)ex.ordinal(), (ModelResourceLocation)new ModelResourceLocation(resourcePath, "explosive=" + ex.func_176610_l()));
                continue;
            }
            ModelLoader.setCustomModelResourceLocation((Item)ICBMClassic.itemMissile, (int)ex.ordinal(), (ModelResourceLocation)new ModelResourceLocation(resourcePath + "_" + (ex.handler.getTier().ordinal() + 1), "explosive=" + ex.func_176610_l()));
        }
    }

    protected void registerCraftingRender(ItemCrafting itemCrafting) {
        if (itemCrafting != null) {
            String resourcePath = itemCrafting.getRegistryName().toString();
            for (int i = 0; i < itemCrafting.subItems.length; ++i) {
                String subItem = itemCrafting.subItems[i];
                ModelLoader.setCustomModelResourceLocation((Item)itemCrafting, (int)i, (ModelResourceLocation)new ModelResourceLocation(resourcePath, "name=" + subItem));
            }
        }
    }

    protected void newBlockModel(Block block, int meta, String varient, String sub) {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)block), (int)meta, (ModelResourceLocation)new ModelResourceLocation(block.getRegistryName() + sub, varient));
    }

    protected void newItemModel(Item item, int meta, String varient, String sub) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName() + sub, varient));
    }

    public static String getPropertyString(Map<IProperty<?>, Comparable<?>> values, String ... extrasArgs) {
        StringBuilder stringbuilder = new StringBuilder();
        for (Map.Entry<IProperty<?>, Comparable<?>> entry : values.entrySet()) {
            if (stringbuilder.length() != 0) {
                stringbuilder.append(",");
            }
            IProperty<?> iproperty = entry.getKey();
            stringbuilder.append(iproperty.func_177701_a());
            stringbuilder.append("=");
            stringbuilder.append(ClientProxy.getPropertyName(iproperty, entry.getValue()));
        }
        if (stringbuilder.length() == 0) {
            stringbuilder.append("inventory");
        }
        for (String args : extrasArgs) {
            if (stringbuilder.length() != 0) {
                stringbuilder.append(",");
            }
            stringbuilder.append(args);
        }
        return stringbuilder.toString();
    }

    private static <T extends Comparable<T>> String getPropertyName(IProperty<T> property, Comparable<?> comparable) {
        return property.func_177702_a(comparable);
    }

    @Override
    public void spawnSmoke(World world, Pos position, double v, double v1, double v2, float red, float green, float blue, float scale, int ticksToLive) {
        if (world != null) {
            ParticleSmokeICBM particleSmokeICBM = new ParticleSmokeICBM(world, position, v, v1, v2, scale);
            particleSmokeICBM.setColor(red, green, blue, true);
            particleSmokeICBM.setAge(ticksToLive);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)particleSmokeICBM);
        }
    }
}

