/*
 * Decompiled with CFR 0.152.
 */
package omtteam.omlib.network.messages.render;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import omtteam.omlib.api.render.ColorOM;
import omtteam.omlib.api.render.RenderManager;
import omtteam.omlib.api.render.object.Ray;

public class MessageRenderRay
implements IMessage {
    private double x;
    private double y;
    private double z;
    private double xEnd;
    private double yEnd;
    private double zEnd;
    private float r;
    private float g;
    private float b;
    private float a;
    private int duration;
    private boolean bloom;

    public MessageRenderRay() {
    }

    public MessageRenderRay(double x, double y, double z, double xEnd, double yEnd, double zEnd, ColorOM color, int duration, boolean bloom) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.xEnd = xEnd;
        this.yEnd = yEnd;
        this.zEnd = zEnd;
        this.r = color.r;
        this.g = color.g;
        this.b = color.b;
        this.a = color.a;
        this.duration = duration;
        this.bloom = bloom;
    }

    public MessageRenderRay(Vec3d start, Vec3d end, ColorOM color, int duration, boolean bloom) {
        this.x = start.field_72450_a;
        this.y = start.field_72448_b;
        this.z = start.field_72449_c;
        this.xEnd = end.field_72450_a;
        this.yEnd = end.field_72448_b;
        this.zEnd = end.field_72449_c;
        this.r = color.r;
        this.g = color.g;
        this.b = color.b;
        this.a = color.a;
        this.duration = duration;
        this.bloom = bloom;
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readDouble();
        this.y = buf.readDouble();
        this.z = buf.readDouble();
        this.xEnd = buf.readDouble();
        this.yEnd = buf.readDouble();
        this.zEnd = buf.readDouble();
        this.r = buf.readFloat();
        this.g = buf.readFloat();
        this.b = buf.readFloat();
        this.a = buf.readFloat();
        this.duration = buf.readInt();
        this.bloom = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeDouble(this.x);
        buf.writeDouble(this.y);
        buf.writeDouble(this.z);
        buf.writeDouble(this.xEnd);
        buf.writeDouble(this.yEnd);
        buf.writeDouble(this.zEnd);
        buf.writeFloat(this.r);
        buf.writeFloat(this.g);
        buf.writeFloat(this.b);
        buf.writeFloat(this.a);
        buf.writeInt(this.duration);
        buf.writeBoolean(this.bloom);
    }

    public static class MessageHandlerRenderRay
    implements IMessageHandler<MessageRenderRay, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(MessageRenderRay messageIn, MessageContext ctx) {
            MessageRenderRay message = messageIn;
            Minecraft.func_71410_x().func_152344_a(() -> RenderManager.getInstance().addRenderObjectToList(new Ray(message.x, message.y, message.z, message.xEnd, message.yEnd, message.zEnd, new ColorOM(message.r, message.g, message.b, message.a), message.duration, message.bloom)));
            return null;
        }
    }
}

