/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.prefab.entities;

import asmodeuscore.api.entity.ICustomEngine;
import asmodeuscore.core.astronomy.SpaceData;
import galaxyspace.GalaxySpace;
import galaxyspace.core.util.GSUtils;
import galaxyspace.systems.SolarSystem.planets.overworld.items.armor.ItemSpaceSuit;
import java.util.List;
import micdoodle8.mods.galacticraft.api.entity.IRocketType;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntitySpaceshipBase;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntityTieredRocket;
import micdoodle8.mods.galacticraft.api.tile.IFuelDock;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.tile.TileEntityLandingPad;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.PlayerUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;

public abstract class EntityTieredRocketWithEngine
extends EntityTieredRocket
implements ICustomEngine {
    private SpaceData.Engine_Type engine_type = SpaceData.Engine_Type.FUEL_ENGINE;
    private int tier;

    public EntityTieredRocketWithEngine(World par1World, int tier) {
        super(par1World);
        this.func_70105_a(2.2f, 11.0f);
        this.tier = tier;
    }

    public EntityTieredRocketWithEngine(World par1World, double par2, double par4, double par6, int tier, IRocketType.EnumRocketType rocketType) {
        super(par1World, par2, par4, par6);
        this.rocketType = rocketType;
        this.tier = tier;
        this.stacks = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
    }

    protected void func_70088_a() {
        super.func_70088_a();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        int i = this.timeUntilLaunch >= 100 ? Math.abs(this.timeUntilLaunch / 100) : 1;
        if ((this.getLaunched() || this.launchPhase == EntitySpaceshipBase.EnumLaunchPhase.IGNITED.ordinal() && this.field_70146_Z.nextInt(i) == 0) && !ConfigManagerCore.disableSpaceshipParticles && this.hasValidFuel() && this.field_70170_p.field_72995_K) {
            this.spawnParticles(this.getLaunched());
        }
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT && this.hasValidFuel() && this.field_70146_Z.nextInt(4) == 0 && !this.getLaunched() && this.getEngine() == SpaceData.Engine_Type.FUEL_ENGINE) {
            GalaxySpace.proxy.spawnParticle("waterbubbles", new Vector3(this.field_70165_t + 0.4 + this.field_70146_Z.nextDouble(), this.field_70163_u - 0.4 + this.field_70146_Z.nextDouble(), this.field_70161_v + this.field_70146_Z.nextDouble()), new Vector3(0.11, -0.5, -0.03), new Object[]{20, 5, false, new Vector3(1.0), 1.0});
            GalaxySpace.proxy.spawnParticle("waterbubbles", new Vector3(this.field_70165_t - 0.8 + this.field_70146_Z.nextDouble(), this.field_70163_u - 0.4 + this.field_70146_Z.nextDouble(), this.field_70161_v + this.field_70146_Z.nextDouble()), new Vector3(-0.2, -0.5, -0.03), new Object[]{20, 5, false, new Vector3(1.0), 1.0});
            GalaxySpace.proxy.spawnParticle("waterbubbles", new Vector3(this.field_70165_t - 0.2 + this.field_70146_Z.nextDouble(), this.field_70163_u - 0.4 + this.field_70146_Z.nextDouble(), this.field_70161_v + 0.4 + this.field_70146_Z.nextDouble()), new Vector3(0.0, -0.5, 0.16), new Object[]{20, 5, false, new Vector3(1.0), 1.0});
            GalaxySpace.proxy.spawnParticle("waterbubbles", new Vector3(this.field_70165_t - 0.2 + this.field_70146_Z.nextDouble(), this.field_70163_u - 0.4 + this.field_70146_Z.nextDouble(), this.field_70161_v - 0.4 + this.field_70146_Z.nextDouble()), new Vector3(0.0, -0.5, -0.16), new Object[]{20, 5, false, new Vector3(1.0), 1.0});
        }
        if (this.launchPhase >= EntitySpaceshipBase.EnumLaunchPhase.LAUNCHED.ordinal() && this.hasValidFuel()) {
            if (this.launchPhase == EntitySpaceshipBase.EnumLaunchPhase.LAUNCHED.ordinal()) {
                double d = this.timeSinceLaunch / 150.0f;
                float mod_engine = 1.0f;
                switch (this.engine_type) {
                    case FUEL_ENGINE: {
                        break;
                    }
                    case ION_ENGINE: {
                        mod_engine = 2.0f;
                        break;
                    }
                    case SUBLIGHT_ENGINE: {
                        mod_engine = 5.0f;
                        break;
                    }
                }
                d = this.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider && ((IGalacticraftWorldProvider)this.field_70170_p.field_73011_w).hasNoAtmosphere() ? Math.min(d * 1.2 * (double)mod_engine, (double)(2.0f * mod_engine)) : Math.min(d * (double)mod_engine, 1.4 * (double)mod_engine);
                if (d != 0.0) {
                    this.field_70181_x = -d * 2.5 * Math.cos((this.field_70125_A - 180.0f) / 57.295776f);
                }
            } else {
                this.field_70181_x -= 0.008;
            }
            double multiplier = 1.0;
            if (this.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider && (multiplier = ((IGalacticraftWorldProvider)this.field_70170_p.field_73011_w).getFuelUsageMultiplier()) <= 0.0) {
                multiplier = 1.0;
            }
            if (this.timeSinceLaunch % (float)MathHelper.func_76128_c((double)(2.0 * (1.0 / multiplier))) == 0.0f) {
                this.removeFuel(4);
                if (!this.hasValidFuel()) {
                    this.stopRocketSound();
                }
            }
        } else if (!this.hasValidFuel() && this.getLaunched() && !this.field_70170_p.field_72995_K && Math.abs(Math.sin(this.timeSinceLaunch / 1000.0f)) / 10.0 != 0.0) {
            this.field_70181_x -= Math.abs(Math.sin(this.timeSinceLaunch / 1000.0f)) / 20.0;
        }
    }

    public void onTeleport(EntityPlayerMP player) {
        EntityPlayerMP playerBase = PlayerUtil.getPlayerBaseServerFromPlayer((EntityPlayer)player, (boolean)false);
        if (playerBase != null) {
            GCPlayerStats stats = GCPlayerStats.get((Entity)playerBase);
            if (this.stacks == null || this.stacks.isEmpty()) {
                stats.setRocketStacks(NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a));
            } else {
                stats.setRocketStacks(this.stacks);
            }
            stats.setRocketType(this.rocketType.getIndex());
            stats.setFuelLevel(this.fuelTank.getFluidAmount());
            if (this.engine_type != SpaceData.Engine_Type.FUEL_ENGINE) {
                ItemStack withengine = this.getPickedResult(null);
                if (!withengine.func_77942_o()) {
                    withengine.func_77982_d(new NBTTagCompound());
                }
                withengine.func_77978_p().func_74757_a(this.engine_type.getName(), true);
                withengine.func_77978_p().func_74768_a(ItemSpaceSuit.mod_count, 0);
                for (int i = 0; i < stats.getRocketStacks().size(); ++i) {
                    ItemStack stack = (ItemStack)stats.getRocketStacks().get(i);
                    if (i != stats.getRocketStacks().size() - 1) continue;
                    stats.getRocketStacks().set(i, (Object)withengine);
                    break;
                }
            } else {
                stats.setRocketItem(this.getPickedResult(null).func_77973_b());
            }
        }
    }

    protected abstract void spawnParticles(boolean var1);

    public boolean func_70300_a(EntityPlayer par1EntityPlayer) {
        return !this.field_70128_L && par1EntityPlayer.func_70068_e((Entity)this) <= 64.0;
    }

    protected void func_70014_b(NBTTagCompound par1NBTTagCompound) {
        super.func_70014_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74768_a("engine_type", this.engine_type.getID());
    }

    protected void func_70037_a(NBTTagCompound par1NBTTagCompound) {
        super.func_70037_a(par1NBTTagCompound);
        this.engine_type = SpaceData.Engine_Type.byID((int)par1NBTTagCompound.func_74762_e("engine_type"));
    }

    public int getRocketTier() {
        return this.tier;
    }

    public int getPreLaunchWait() {
        return 400;
    }

    public float getCameraZoom() {
        return 15.0f;
    }

    public boolean defaultThirdPerson() {
        return true;
    }

    public List<ItemStack> getItemsDropped(List<ItemStack> droppedItems) {
        super.getItemsDropped(droppedItems);
        ItemStack rocket = this.getPickedResult(null);
        rocket.func_77982_d(new NBTTagCompound());
        rocket.func_77978_p().func_74768_a("RocketFuel", this.fuelTank.getFluidAmount());
        droppedItems.add(rocket);
        return droppedItems;
    }

    public float getRenderOffsetY() {
        return -0.2f;
    }

    public boolean isDockValid(IFuelDock dock) {
        return dock instanceof TileEntityLandingPad;
    }

    public int addFuel(FluidStack liquid, boolean doFill) {
        return GSUtils.fillWithGCFuel(this.fuelTank, liquid, doFill, this);
    }

    public void setEngine(SpaceData.Engine_Type type) {
        this.engine_type = type;
    }

    public SpaceData.Engine_Type getEngine() {
        return this.engine_type;
    }

    public abstract int getFuelTankCapacity();

    public abstract double func_70033_W();

    public abstract ItemStack getPickedResult(RayTraceResult var1);

    public abstract double func_70042_X();

    public abstract float getRotateOffset();

    public abstract double getOnPadYOffset();
}

