/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.arcade.sweeper;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vswe.stevescarts.arcade.ArcadeGame;
import vswe.stevescarts.arcade.sweeper.Tile;
import vswe.stevescarts.arcade.tracks.TrackStory;
import vswe.stevescarts.guis.GuiMinecart;
import vswe.stevescarts.handlers.SoundHandler;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.helpers.ResourceHelper;
import vswe.stevescarts.modules.realtimers.ModuleArcade;

public class ArcadeSweeper
extends ArcadeGame {
    private Tile[][] tiles;
    protected boolean isPlaying;
    protected boolean hasFinished;
    private int currentGameType;
    private int ticks;
    protected int creepersLeft;
    protected int emptyLeft;
    private boolean hasStarted;
    private int[] highscore = new int[]{999, 999, 999};
    private int highscoreTicks;
    private static String textureMenu = "/gui/sweeper.png";

    public ArcadeSweeper(ModuleArcade module) {
        super(module, Localization.ARCADE.CREEPER);
        this.newGame(this.currentGameType);
    }

    private void newGame(int size) {
        switch (size) {
            case 0: {
                this.newGame(9, 9, 10);
                break;
            }
            case 1: {
                this.newGame(16, 16, 40);
                break;
            }
            case 2: {
                this.newGame(30, 16, 99);
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void update() {
        super.update();
        if (this.hasStarted && this.isPlaying && !this.hasFinished && this.ticks < 19980) {
            ++this.ticks;
        }
        if (this.highscoreTicks > 0) {
            ++this.highscoreTicks;
            if (this.highscoreTicks == 78) {
                this.highscoreTicks = 0;
                ArcadeGame.playSound(SoundHandler.HIGH_SCORE, 1.0f, 1.0f);
            }
        }
    }

    private void newGame(int width, int height, int totalCreepers) {
        this.isPlaying = true;
        this.ticks = 0;
        this.creepersLeft = totalCreepers;
        this.emptyLeft = width * height - totalCreepers;
        this.hasStarted = false;
        this.hasFinished = false;
        this.highscoreTicks = 0;
        this.tiles = new Tile[width][height];
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                this.tiles[x][y] = new Tile(this);
            }
        }
        for (int creepers = 0; creepers < totalCreepers; ++creepers) {
            int y2;
            int x2 = this.getModule().getCart().random.nextInt(width);
            if (this.tiles[x2][y2 = this.getModule().getCart().random.nextInt(height)].isCreeper()) continue;
            this.tiles[x2][y2].setCreeper();
        }
        for (int x2 = 0; x2 < width; ++x2) {
            for (int y2 = 0; y2 < height; ++y2) {
                if (this.tiles[x2][y2].isCreeper()) continue;
                int count = 0;
                for (int i = -1; i <= 1; ++i) {
                    for (int j = -1; j <= 1; ++j) {
                        if (i == 0 && j == 0) continue;
                        int x3 = x2 + i;
                        int y3 = y2 + j;
                        if (x3 < 0 || y3 < 0 || x3 >= width || y3 >= height || !this.tiles[x3][y3].isCreeper()) continue;
                        ++count;
                    }
                }
                this.tiles[x2][y2].setNearbyCreepers(count);
            }
        }
    }

    private int getMarginLeft() {
        return (443 - this.tiles.length * 10) / 2;
    }

    private int getMarginTop() {
        return (168 - this.tiles[0].length * 10) / 2;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawBackground(GuiMinecart gui, int x, int y) {
        ResourceHelper.bindResource(textureMenu);
        for (int i = 0; i < this.tiles.length; ++i) {
            for (int j = 0; j < this.tiles[0].length; ++j) {
                this.tiles[i][j].draw(this, gui, this.getMarginLeft() + i * 10, this.getMarginTop() + j * 10, x, y);
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void mouseClicked(GuiMinecart gui, int x, int y, int button) {
        if (!this.isPlaying) {
            return;
        }
        int xc = (x -= this.getMarginLeft()) / 10;
        int yc = (y -= this.getMarginTop()) / 10;
        if (button == 0) {
            this.openTile(xc, yc, true);
        } else if (button == 1 && this.isValidCoordinate(xc, yc)) {
            this.hasStarted = true;
            ArcadeGame.playSound(SoundHandler.FLAG_CLICK, 1.0f, 1.0f);
            this.tiles[xc][yc].mark();
        } else if (button == 2 && this.isValidCoordinate(xc, yc) && this.tiles[xc][yc].getState() == Tile.TILE_STATE.OPENED) {
            ArcadeGame.playSound(SoundHandler.CLICK, 1.0f, 1.0f);
            int nearby = this.tiles[xc][yc].getNearbyCreepers();
            if (nearby != 0) {
                int j;
                int i;
                for (i = -1; i <= 1; ++i) {
                    for (j = -1; j <= 1; ++j) {
                        if (i == 0 && j == 0 || !this.isValidCoordinate(xc + i, yc + j) || this.tiles[xc + i][yc + j].getState() != Tile.TILE_STATE.FLAGGED) continue;
                        --nearby;
                    }
                }
                if (nearby == 0) {
                    for (i = -1; i <= 1; ++i) {
                        for (j = -1; j <= 1; ++j) {
                            if (i == 0 && j == 0) continue;
                            this.openTile(xc + i, yc + j, false);
                        }
                    }
                }
            }
        }
    }

    private boolean isValidCoordinate(int x, int y) {
        return x >= 0 && y >= 0 && x < this.tiles.length && y < this.tiles[0].length;
    }

    private void openTile(int x, int y, boolean first) {
        if (this.isValidCoordinate(x, y)) {
            this.hasStarted = true;
            Tile.TILE_OPEN_RESULT result = this.tiles[x][y].open();
            if (this.emptyLeft == 0) {
                this.hasFinished = true;
                this.isPlaying = false;
                ArcadeGame.playSound(SoundHandler.GOOD_JOB, 1.0f, 1.0f);
                if (this.highscore[this.currentGameType] > this.ticks / 20) {
                    this.highscoreTicks = 1;
                    int val = this.ticks / 20;
                    byte byte1 = (byte)(val & 0xFF);
                    byte byte2 = (byte)((val & 0xFF00) >> 8);
                    this.getModule().sendPacket(3, new byte[]{(byte)this.currentGameType, byte1, byte2});
                }
            } else if (result == Tile.TILE_OPEN_RESULT.BLOB) {
                if (first) {
                    ArcadeGame.playSound(SoundHandler.BLOB_CLICK, 1.0f, 1.0f);
                }
                for (int i = -1; i <= 1; ++i) {
                    for (int j = -1; j <= 1; ++j) {
                        this.openTile(x + i, y + j, false);
                    }
                }
            } else if (result == Tile.TILE_OPEN_RESULT.DEAD) {
                this.isPlaying = false;
                ArcadeGame.playSound(SoundEvents.field_187539_bB, 1.0f, (1.0f + (this.getModule().getCart().random.nextFloat() - this.getModule().getCart().random.nextFloat()) * 0.2f) * 0.7f);
            } else if (result == Tile.TILE_OPEN_RESULT.OK && first) {
                ArcadeGame.playSound(SoundHandler.CLICK, 1.0f, 1.0f);
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void keyPress(GuiMinecart gui, char character, int extraInformation) {
        if (Character.toLowerCase(character) == 'r') {
            this.newGame(this.currentGameType);
        } else if (Character.toLowerCase(character) == 't') {
            this.currentGameType = (this.currentGameType + 1) % 3;
            this.newGame(this.currentGameType);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawForeground(GuiMinecart gui) {
        String[] mapnames = new String[]{Localization.ARCADE.MAP_1.translate(new String[0]), Localization.ARCADE.MAP_2.translate(new String[0]), Localization.ARCADE.MAP_3.translate(new String[0])};
        this.getModule().drawString(gui, Localization.ARCADE.LEFT.translate(String.valueOf(this.creepersLeft)), 10, 180, 0x404040);
        this.getModule().drawString(gui, Localization.ARCADE.TIME.translate(String.valueOf(this.ticks / 20)), 10, 190, 0x404040);
        this.getModule().drawString(gui, "R - " + Localization.ARCADE.INSTRUCTION_RESTART.translate(new String[0]), 10, 210, 0x404040);
        this.getModule().drawString(gui, "T - " + Localization.ARCADE.INSTRUCTION_CHANGE_MAP.translate(new String[0]), 10, 230, 0x404040);
        this.getModule().drawString(gui, Localization.ARCADE.MAP.translate(mapnames[this.currentGameType]), 10, 240, 0x404040);
        this.getModule().drawString(gui, Localization.ARCADE.HIGH_SCORES.translate(new String[0]), 330, 180, 0x404040);
        for (int i = 0; i < 3; ++i) {
            this.getModule().drawString(gui, Localization.ARCADE.HIGH_SCORE_ENTRY.translate(mapnames[i], String.valueOf(this.highscore[i])), 330, 190 + i * 10, 0x404040);
        }
    }

    @Override
    public void receivePacket(int id, byte[] data, EntityPlayer player) {
        if (id == 3) {
            short data2 = data[1];
            short data3 = data[2];
            if (data2 < 0) {
                data2 = (short)(data2 + 256);
            }
            if (data3 < 0) {
                data3 = (short)(data3 + 256);
            }
            this.highscore[data[0]] = data2 | data3 << 8;
        }
    }

    @Override
    public void checkGuiData(Object[] info) {
        for (int i = 0; i < 3; ++i) {
            this.getModule().updateGuiData(info, TrackStory.stories.size() + 2 + i, (short)this.highscore[i]);
        }
    }

    @Override
    public void receiveGuiData(int id, short data) {
        if (id >= TrackStory.stories.size() + 2 && id < TrackStory.stories.size() + 5) {
            this.highscore[id - (TrackStory.stories.size() + 2)] = data;
        }
    }

    @Override
    public void Save(NBTTagCompound tagCompound, int id) {
        for (int i = 0; i < 3; ++i) {
            tagCompound.func_74777_a(this.getModule().generateNBTName("HighscoreSweeper" + i, id), (short)this.highscore[i]);
        }
    }

    @Override
    public void Load(NBTTagCompound tagCompound, int id) {
        for (int i = 0; i < 3; ++i) {
            this.highscore[i] = tagCompound.func_74765_d(this.getModule().generateNBTName("HighscoreSweeper" + i, id));
        }
    }
}

