/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.blocks;

import net.minecraft.block.Block;
import net.minecraft.block.BlockRail;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import vswe.stevescarts.StevesCarts;
import vswe.stevescarts.blocks.ModBlocks;
import vswe.stevescarts.blocks.tileentities.TileEntityActivator;
import vswe.stevescarts.blocks.tileentities.TileEntityDetector;
import vswe.stevescarts.blocks.tileentities.TileEntityManager;
import vswe.stevescarts.blocks.tileentities.TileEntityUpgrade;
import vswe.stevescarts.entitys.EntityMinecartModular;
import vswe.stevescarts.helpers.DetectorType;
import vswe.stevescarts.modules.data.ModuleData;
import vswe.stevescarts.upgrades.BaseEffect;
import vswe.stevescarts.upgrades.Disassemble;
import vswe.stevescarts.upgrades.Transposer;

public class BlockRailAdvDetector
extends BlockRail {
    public BlockRailAdvDetector() {
        this.func_149647_a(StevesCarts.tabsSC2Blocks);
    }

    public boolean canMakeSlopes(IBlockAccess world, BlockPos pos) {
        return false;
    }

    public void onMinecartPass(World world, EntityMinecart entityMinecart, BlockPos pos) {
        if (world.field_72995_K || !(entityMinecart instanceof EntityMinecartModular)) {
            return;
        }
        EntityMinecartModular cart = (EntityMinecartModular)entityMinecart;
        if (world.func_180495_p(pos.func_177977_b()).func_177230_c() == ModBlocks.DETECTOR_UNIT.getBlock() && DetectorType.getTypeFromSate(world.func_180495_p(pos.func_177977_b())).canInteractWithCart()) {
            TileEntity tileentity = world.func_175625_s(pos.func_177977_b());
            if (tileentity instanceof TileEntityDetector) {
                TileEntityDetector detector = (TileEntityDetector)tileentity;
                detector.handleCart(cart);
            }
            return;
        }
        if (!this.isCartReadyForAction(cart, pos)) {
            return;
        }
        int side = 0;
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                TileEntityUpgrade upgrade;
                TileEntity tileentity;
                if (Math.abs(i) == Math.abs(j)) continue;
                BlockPos offset = pos.func_177982_a(i, 0, j);
                Block block = world.func_180495_p(offset).func_177230_c();
                if (block == ModBlocks.CARGO_MANAGER.getBlock() || block == ModBlocks.LIQUID_MANAGER.getBlock()) {
                    TileEntityManager manager;
                    tileentity = world.func_175625_s(offset);
                    if (tileentity instanceof TileEntityManager && (manager = (TileEntityManager)tileentity).getCart() == null) {
                        manager.setCart(cart);
                        manager.setSide(side);
                    }
                    return;
                }
                if (block == ModBlocks.MODULE_TOGGLER.getBlock()) {
                    tileentity = world.func_175625_s(offset);
                    if (tileentity instanceof TileEntityActivator) {
                        TileEntityActivator activator = (TileEntityActivator)tileentity;
                        boolean isOrange = false;
                        if (cart.temppushX == 0.0 == (cart.temppushZ == 0.0)) continue;
                        if (i == 0) {
                            isOrange = j == -1 ? cart.temppushX < 0.0 : cart.temppushX > 0.0;
                        } else if (j == 0) {
                            isOrange = i == -1 ? cart.temppushZ > 0.0 : cart.temppushZ < 0.0;
                        }
                        boolean isBlueBerry = false;
                        activator.handleCart(cart, isOrange);
                        cart.releaseCart();
                    }
                    return;
                }
                if (block == ModBlocks.UPGRADE.getBlock() && (upgrade = (TileEntityUpgrade)(tileentity = world.func_175625_s(offset))) != null && upgrade.getUpgrade() != null) {
                    for (BaseEffect effect : upgrade.getUpgrade().getEffects()) {
                        if (!(effect instanceof Transposer)) continue;
                        Transposer transposer = (Transposer)effect;
                        if (upgrade.getMaster() == null) continue;
                        for (TileEntityUpgrade tile : upgrade.getMaster().getUpgradeTiles()) {
                            if (tile.getUpgrade() == null) continue;
                            for (BaseEffect effect2 : tile.getUpgrade().getEffects()) {
                                if (!(effect2 instanceof Disassemble)) continue;
                                Disassemble disassembler = (Disassemble)effect2;
                                if (!tile.func_70301_a(0).func_190926_b()) continue;
                                tile.func_70299_a(0, ModuleData.createModularCart(cart));
                                upgrade.getMaster().managerInteract(cart, false);
                                for (int p = 0; p < cart.func_70302_i_(); ++p) {
                                    ItemStack item = cart.func_70304_b(p);
                                    if (item.func_190926_b()) continue;
                                    upgrade.getMaster().puke(item);
                                }
                                cart.func_70106_y();
                                return;
                            }
                        }
                    }
                }
                ++side;
            }
        }
        int power = world.func_175687_A(pos);
        if (power > 0) {
            cart.releaseCart();
        }
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        IBlockState blockState = world.func_180495_p(pos.func_177977_b());
        if (world.func_180495_p(pos.func_177977_b()) == ModBlocks.DETECTOR_UNIT.getBlock() && DetectorType.getTypeFromSate(blockState).canInteractWithCart()) {
            return false;
        }
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            TileEntity tileentity;
            TileEntityUpgrade upgrade;
            BlockPos posOther = pos.func_177972_a(facing);
            Block block = world.func_180495_p(posOther).func_177230_c();
            if (block == ModBlocks.CARGO_MANAGER.getBlock() || block == ModBlocks.LIQUID_MANAGER.getBlock() || block == ModBlocks.MODULE_TOGGLER.getBlock()) {
                return false;
            }
            if (block != ModBlocks.UPGRADE.getBlock() || (upgrade = (TileEntityUpgrade)(tileentity = world.func_175625_s(posOther))) == null || upgrade.getUpgrade() == null) continue;
            for (BaseEffect effect : upgrade.getUpgrade().getEffects()) {
                if (!(effect instanceof Transposer) || upgrade.getMaster() == null) continue;
                for (TileEntityUpgrade tile : upgrade.getMaster().getUpgradeTiles()) {
                    if (tile.getUpgrade() == null) continue;
                    for (BaseEffect effect2 : tile.getUpgrade().getEffects()) {
                        if (!(effect2 instanceof Disassemble)) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    private boolean isCartReadyForAction(EntityMinecartModular cart, BlockPos pos) {
        return cart.disabledPos != null && cart.disabledPos.equals((Object)pos) && cart.isDisabled();
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        IBlockState blockState = world.func_180495_p(pos = pos.func_177977_b());
        return blockState.func_177230_c() == ModBlocks.DETECTOR_UNIT.getBlock() && ModBlocks.DETECTOR_UNIT.getBlock().func_180639_a(world, pos, blockState, player, hand, side, hitX, hitY, hitZ);
    }

    public void refreshState(World world, BlockPos pos, IBlockState state, boolean flag) {
        new BlockRailBase.Rail((BlockRailBase)this, world, pos, state).func_180364_a(flag, false);
    }
}

