/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.integration.buildcraft;

import buildcraft.api.core.render.ISprite;
import buildcraft.api.statements.IStatement;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.ITriggerExternal;
import java.util.Locale;
import net.minecraft.client.resources.I18n;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.text.WordUtils;
import vazkii.botania.api.mana.IManaBlock;
import vazkii.botania.api.mana.IManaReceiver;
import vazkii.botania.client.core.handler.MiscellaneousIcons;
import vazkii.botania.common.integration.buildcraft.StatementAPIPlugin;
import vazkii.botania.common.integration.buildcraft.StatementBase;
import vazkii.botania.common.integration.buildcraft.TASprite;

public class TriggerManaLevel
extends StatementBase
implements ITriggerExternal {
    private final State state;

    public TriggerManaLevel(State state) {
        this.state = state;
    }

    public String getUniqueTag() {
        return "botania:mana_" + this.state.name().toLowerCase(Locale.ROOT);
    }

    @SideOnly(value=Side.CLIENT)
    public ISprite getSprite() {
        return new TASprite(MiscellaneousIcons.INSTANCE.manaLevelTriggerIcons.get((Object)this.state));
    }

    @SideOnly(value=Side.CLIENT)
    public String getDescription() {
        return I18n.func_135052_a((String)("botania.triggers.mana" + WordUtils.capitalizeFully((String)this.state.name())), (Object[])new Object[0]);
    }

    public boolean isTriggerActive(TileEntity target, EnumFacing side, IStatementContainer source, IStatementParameter[] parameters) {
        if (target instanceof IManaBlock) {
            if (this.state == State.EMPTY) {
                return ((IManaBlock)target).getCurrentMana() == 0;
            }
            if (this.state == State.CONTAINS) {
                return ((IManaBlock)target).getCurrentMana() > 0;
            }
            if (target instanceof IManaReceiver) {
                if (this.state == State.SPACE) {
                    return !((IManaReceiver)target).isFull();
                }
                if (this.state == State.FULL) {
                    return ((IManaReceiver)target).isFull();
                }
            }
        }
        return false;
    }

    @Override
    public IStatement[] getPossible() {
        return new IStatement[]{StatementAPIPlugin.triggerManaEmpty, StatementAPIPlugin.triggerManaContains, StatementAPIPlugin.triggerManaSpace, StatementAPIPlugin.triggerManaFull};
    }

    public static enum State {
        EMPTY,
        CONTAINS,
        SPACE,
        FULL;

    }
}

