/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.numina.heat;

import javax.annotation.Nonnull;
import net.machinemuse.numina.capabilities.heat.CapabilityHeat;
import net.machinemuse.numina.capabilities.heat.IHeatStorage;
import net.machinemuse.numina.item.MuseItemUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.NonNullList;

public class MuseHeatUtils {
    public static final DamageSource overheatDamage = new OverheatDamage();

    public static double getPlayerHeat(EntityPlayer player) {
        double heat = 0.0;
        for (ItemStack stack : MuseItemUtils.getModularItemsEquipped(player)) {
            heat += MuseHeatUtils.getItemHeat(stack);
        }
        return heat;
    }

    public static double getPlayerMaxHeat(EntityPlayer player) {
        double maxHeat = 0.0;
        for (ItemStack stack : MuseItemUtils.getModularItemsEquipped(player)) {
            maxHeat += MuseHeatUtils.getItemMaxHeat(stack);
        }
        return maxHeat;
    }

    public static double coolPlayer(EntityPlayer player, double coolJoules) {
        NonNullList<ItemStack> items = MuseItemUtils.getModularItemsInInventory(player);
        if (player.func_184587_cr()) {
            items.remove((Object)player.field_71071_by.func_70448_g());
        }
        double coolingLeft = coolJoules;
        for (ItemStack stack : items) {
            double currHeat = MuseHeatUtils.getItemHeat(stack);
            if (!(coolingLeft > 0.0)) break;
            if (currHeat > coolingLeft) {
                coolingLeft -= MuseHeatUtils.coolItem(stack, coolingLeft);
                return coolJoules - coolingLeft;
            }
            coolingLeft -= MuseHeatUtils.coolItem(stack, coolingLeft);
        }
        return coolJoules - coolingLeft;
    }

    public static double heatPlayer(EntityPlayer player, double heatJoules) {
        NonNullList<ItemStack> items = MuseItemUtils.getModularItemsEquippedWithoutActive(player);
        if (player.func_184587_cr()) {
            items.remove((Object)player.field_71071_by.func_70448_g());
        }
        double heatLeftToGive = heatJoules;
        for (ItemStack stack : items) {
            double maxHeat;
            double currHeat = MuseHeatUtils.getItemHeat(stack);
            if (currHeat + heatLeftToGive < (maxHeat = MuseHeatUtils.getItemMaxHeat(stack))) {
                MuseHeatUtils.heatItem(stack, heatLeftToGive);
                return heatJoules;
            }
            heatLeftToGive -= MuseHeatUtils.heatItem(stack, maxHeat - currHeat);
        }
        double heatPerStack = heatLeftToGive / (double)items.size();
        for (ItemStack stack : items) {
            heatLeftToGive -= MuseHeatUtils.heatItem(stack, heatPerStack);
        }
        return heatJoules - heatLeftToGive;
    }

    public static double getItemMaxHeat(@Nonnull ItemStack stack) {
        IHeatStorage heatStorage = (IHeatStorage)stack.getCapability(CapabilityHeat.HEAT, null);
        if (heatStorage != null) {
            return heatStorage.getMaxHeatStored();
        }
        return 0.0;
    }

    public static double getItemHeat(@Nonnull ItemStack stack) {
        IHeatStorage heatStorage = (IHeatStorage)stack.getCapability(CapabilityHeat.HEAT, null);
        if (heatStorage != null) {
            return heatStorage.getHeatStored();
        }
        return 0.0;
    }

    public static double heatItem(@Nonnull ItemStack stack, double value) {
        IHeatStorage heatStorage = (IHeatStorage)stack.getCapability(CapabilityHeat.HEAT, null);
        if (heatStorage != null) {
            return heatStorage.receiveHeat(value, false);
        }
        return 0.0;
    }

    public static double coolItem(@Nonnull ItemStack stack, double value) {
        IHeatStorage heatStorage = (IHeatStorage)stack.getCapability(CapabilityHeat.HEAT, null);
        if (heatStorage != null) {
            return heatStorage.extractHeat(value, false);
        }
        return 0.0;
    }

    protected static final class OverheatDamage
    extends DamageSource {
        public OverheatDamage() {
            super("Overheat");
            this.func_76361_j();
            this.func_76348_h();
        }

        public boolean equals(DamageSource other) {
            return other.field_76373_n.equals(this.field_76373_n);
        }
    }
}

