/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.common.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.common.base.PatchouliSounds;
import vazkii.patchouli.common.book.Book;
import vazkii.patchouli.common.book.BookRegistry;
import vazkii.patchouli.common.item.PatchouliItems;
import vazkii.patchouli.common.network.NetworkHandler;
import vazkii.patchouli.common.network.message.MessageOpenBookGui;

public class ItemModBook
extends Item {
    private static final String TAG_BOOK = "patchouli:book";

    public ItemModBook() {
        this.func_77625_d(1);
        this.func_77637_a(CreativeTabs.field_78026_f);
        this.setRegistryName(new ResourceLocation("patchouli", "guide_book"));
        this.func_77655_b(this.getRegistryName().toString());
        this.func_185043_a(new ResourceLocation("completion"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                Book book = ItemModBook.getBook(stack);
                float progression = 0.0f;
                if (book != null) {
                    int totalEntries = 0;
                    int unlockedEntries = 0;
                    for (BookEntry entry : book.contents.entries.values()) {
                        if (entry.isSecret()) continue;
                        ++totalEntries;
                        if (entry.isLocked()) continue;
                        ++unlockedEntries;
                    }
                    progression = (float)unlockedEntries / Math.max(1.0f, (float)totalEntries);
                }
                return progression;
            }
        });
    }

    public static ItemStack forBook(Book book) {
        return ItemModBook.forBook(book.resourceLoc.toString());
    }

    public static ItemStack forBook(String book) {
        ItemStack stack = new ItemStack(PatchouliItems.book);
        NBTTagCompound cmp = new NBTTagCompound();
        cmp.func_74778_a(TAG_BOOK, book);
        stack.func_77982_d(cmp);
        return stack;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        String tabName = tab.func_78013_b();
        BookRegistry.INSTANCE.books.values().forEach(b -> {
            if (!(b.noBook || b.isExtension || tab != CreativeTabs.field_78027_g && !b.creativeTab.equals(tabName))) {
                items.add((Object)ItemModBook.forBook(b));
            }
        });
    }

    public static Book getBook(ItemStack stack) {
        if (!stack.func_77942_o() || !stack.func_77978_p().func_74764_b(TAG_BOOK)) {
            return null;
        }
        String bookStr = stack.func_77978_p().func_74779_i(TAG_BOOK);
        ResourceLocation res = new ResourceLocation(bookStr);
        return BookRegistry.INSTANCE.books.get(res);
    }

    public String getCreatorModId(ItemStack itemStack) {
        Book book = ItemModBook.getBook(itemStack);
        if (book != null) {
            return book.owner.getModId();
        }
        return super.getCreatorModId(itemStack);
    }

    public String func_77653_i(ItemStack stack) {
        Book book = ItemModBook.getBook(stack);
        if (book != null) {
            return I18n.func_74838_a((String)book.name).trim();
        }
        return super.func_77653_i(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        Book book = ItemModBook.getBook(stack);
        if (book != null && book.contents != null) {
            tooltip.add(book.contents.getSubtitle());
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        Book book = ItemModBook.getBook(stack);
        if (book == null) {
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        if (playerIn instanceof EntityPlayerMP) {
            NetworkHandler.INSTANCE.sendTo((IMessage)new MessageOpenBookGui(book.resourceLoc.toString()), (EntityPlayerMP)playerIn);
            SoundEvent sfx = PatchouliSounds.getSound(book.openSound, PatchouliSounds.book_open);
            worldIn.func_184148_a(null, playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, sfx, SoundCategory.PLAYERS, 1.0f, (float)(0.7 + Math.random() * 0.4));
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }
}

