/*
 * Decompiled with CFR 0.152.
 */
package info.openmods.calc.utils.config;

import com.google.common.collect.ImmutableMap;
import info.openmods.calc.utils.config.IStringReader;
import info.openmods.calc.utils.config.StringConversionException;
import java.util.Map;

public abstract class StringReader {
    public static final IStringReader<Integer> INTEGER = new IStringReader<Integer>(){

        @Override
        public Integer readFromString(String s) {
            try {
                return Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                throw new StringConversionException("integer", s, e);
            }
        }
    };
    public static final IStringReader<Float> FLOAT = new IStringReader<Float>(){

        @Override
        public Float readFromString(String s) {
            try {
                return Float.valueOf(Float.parseFloat(s));
            }
            catch (NumberFormatException e) {
                throw new StringConversionException("float", s, e);
            }
        }
    };
    public static final IStringReader<Double> DOUBLE = new IStringReader<Double>(){

        @Override
        public Double readFromString(String s) {
            try {
                return Double.parseDouble(s);
            }
            catch (NumberFormatException e) {
                throw new StringConversionException("double", s, e);
            }
        }
    };
    public static final IStringReader<String> STRING = new IStringReader<String>(){

        @Override
        public String readFromString(String s) {
            return s;
        }
    };
    public static final IStringReader<Short> SHORT = new IStringReader<Short>(){

        @Override
        public Short readFromString(String s) {
            try {
                return Short.parseShort(s);
            }
            catch (NumberFormatException e) {
                throw new StringConversionException("short", s, e);
            }
        }
    };
    public static final IStringReader<Byte> BYTE = new IStringReader<Byte>(){

        @Override
        public Byte readFromString(String s) {
            try {
                return Byte.parseByte(s);
            }
            catch (NumberFormatException e) {
                throw new StringConversionException("byte", s, e);
            }
        }
    };
    public static final IStringReader<Boolean> BOOL = new IStringReader<Boolean>(){

        @Override
        public Boolean readFromString(String s) {
            if (s.equalsIgnoreCase("true")) {
                return Boolean.TRUE;
            }
            if (s.equalsIgnoreCase("false")) {
                return Boolean.FALSE;
            }
            throw new StringConversionException("bool", s, "true", "false");
        }
    };
    public static final IStringReader<Long> LONG = new IStringReader<Long>(){

        @Override
        public Long readFromString(String s) {
            try {
                return Long.parseLong(s);
            }
            catch (NumberFormatException e) {
                throw new StringConversionException("long", s, e);
            }
        }
    };
    public static final Map<Class<?>, IStringReader<?>> STRING_SERIALIZERS = ImmutableMap.builder().put(Integer.class, INTEGER).put(Integer.TYPE, INTEGER).put(Boolean.class, BOOL).put(Boolean.TYPE, BOOL).put(Byte.class, BYTE).put(Byte.TYPE, BYTE).put(Double.class, DOUBLE).put(Double.TYPE, DOUBLE).put(Float.class, FLOAT).put(Float.TYPE, FLOAT).put(Long.class, LONG).put(Long.TYPE, LONG).put(Short.class, SHORT).put(Short.TYPE, SHORT).put(String.class, STRING).build();

    public static <T> IStringReader<T> get(Class<? extends T> cls) {
        return STRING_SERIALIZERS.get(cls);
    }
}

