/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.generator;

import ic2.api.classic.reactor.ISteamReactor;
import ic2.api.classic.reactor.ISteamReactorChamber;
import ic2.api.reactor.IReactor;
import ic2.core.IC2;
import ic2.core.block.base.BlockCommonContainer;
import ic2.core.block.base.tile.TileEntityReactorChamberBase;
import ic2.core.block.generator.tile.TileEntityReactorChamberElectric;
import ic2.core.block.generator.tile.TileEntitySteamReactorChamber;
import ic2.core.inventory.base.IHasGui;
import ic2.core.platform.lang.storage.Ic2BlockLang;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.platform.registry.Ic2States;
import ic2.core.platform.textures.Ic2Icons;
import ic2.core.platform.textures.obj.ITexturedBlock;
import ic2.core.util.misc.StackUtil;
import ic2.core.util.obj.IBootable;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockReactorChamber
extends BlockCommonContainer
implements ITexturedBlock,
IBootable {
    public static PropertyBool steam = PropertyBool.func_177716_a((String)"steam");

    public BlockReactorChamber() {
        super(Material.field_151573_f);
        this.func_149711_c(5.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.setUnlocalizedName(Ic2BlockLang.reactorChambers);
        this.setHarvestLevel("pickaxe", 1);
    }

    @Override
    public void onLoad() {
        Ic2Items.reactorChamber = new ItemStack((Block)this, 1, 0);
        Ic2Items.steamReactorChamber = new ItemStack((Block)this, 1, 1);
        Ic2States.reactorChamber = this.func_176203_a(0);
        Ic2States.steamReactorChamber = this.func_176203_a(1);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{steam});
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)steam) != false ? 1 : 0;
    }

    @Deprecated
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)steam, (Comparable)Boolean.valueOf(meta == 1));
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        switch (meta) {
            case 0: {
                return new TileEntityReactorChamberElectric();
            }
            case 1: {
                return new TileEntitySteamReactorChamber();
            }
        }
        return null;
    }

    @Override
    public IBlockState getDefaultBlockState() {
        return this.func_176223_P().func_177226_a((IProperty)steam, (Comparable)Boolean.valueOf(false));
    }

    @Override
    public AxisAlignedBB getRenderBoundingBox(IBlockState state) {
        return field_185505_j;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTextureFromState(IBlockState state, EnumFacing side) {
        boolean isSteam = (Boolean)state.func_177229_b((IProperty)steam);
        if (side == EnumFacing.DOWN) {
            return Ic2Icons.getTextures("b0")[isSteam ? 18 : 16];
        }
        if (side == EnumFacing.UP) {
            return Ic2Icons.getTextures("b0")[isSteam ? 19 : 17];
        }
        return Ic2Icons.getTextures("b0")[isSteam ? 68 : 67];
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getParticleTexture(IBlockState state) {
        return Ic2Icons.getTextures("b0")[(Boolean)state.func_177229_b((IProperty)steam) != false ? 68 : 67];
    }

    @Override
    public List<IBlockState> getValidStates() {
        return this.func_176194_O().func_177619_a();
    }

    @Override
    public IBlockState getStateFromStack(ItemStack stack) {
        return this.func_176203_a(stack.func_77960_j());
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return true;
    }

    @Override
    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        boolean isSteam = (Boolean)state.func_177229_b((IProperty)steam);
        if (this.isReactorNearby(worldIn, pos, isSteam)) {
            return;
        }
        if (IC2.platform.isRendering()) {
            return;
        }
        StackUtil.dropAsEntity(worldIn, pos, (isSteam ? Ic2Items.steamReactorChamber : Ic2Items.reactorChamber).func_77946_l());
        worldIn.func_175698_g(pos);
    }

    public boolean isReactorNearby(World world, BlockPos pos, boolean steam) {
        int count = 0;
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            if (!this.isReactorAt(world, pos.func_177972_a(facing), steam)) continue;
            ++count;
        }
        return count == 1;
    }

    public boolean isReactorAt(World world, BlockPos pos, boolean steam) {
        TileEntity tile = world.func_175625_s(pos);
        if (steam) {
            return tile instanceof ISteamReactor;
        }
        return tile instanceof IReactor && !(tile instanceof ISteamReactor);
    }

    public IReactor getReactor(World world, BlockPos pos, boolean steam) {
        TileEntity tile = world.func_175625_s(pos);
        if (!(tile instanceof TileEntityReactorChamberBase)) {
            this.func_189540_a(world.func_180495_p(pos), world, pos, (Block)this, pos);
            return null;
        }
        TileEntityReactorChamberBase base = (TileEntityReactorChamberBase)tile;
        if (steam) {
            if (base instanceof ISteamReactorChamber) {
                return base.getReactorInstance();
            }
            this.func_189540_a(world.func_180495_p(pos), world, pos, (Block)this, pos);
            return null;
        }
        if (base instanceof ISteamReactorChamber) {
            this.func_189540_a(world.func_180495_p(pos), world, pos, (Block)this, pos);
            return null;
        }
        return base.getReactorInstance();
    }

    @Override
    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (super.func_180639_a(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ)) {
            return true;
        }
        if (playerIn.func_70093_af()) {
            return false;
        }
        IReactor reactor = this.getReactor(worldIn, pos, (Boolean)state.func_177229_b((IProperty)steam));
        if (reactor == null) {
            return false;
        }
        return reactor instanceof IHasGui && (IC2.platform.isRendering() || IC2.platform.launchGui(playerIn, (IHasGui)((Object)reactor), hand));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        int n;
        IReactor reactor = this.getReactor(worldIn, pos, (Boolean)stateIn.func_177229_b((IProperty)steam));
        if (reactor == null) {
            return;
        }
        int puffs = reactor.getHeat() / 1000;
        if (puffs <= 0) {
            return;
        }
        puffs = worldIn.field_73012_v.nextInt(puffs);
        for (n = 0; n < puffs; ++n) {
            worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)((float)pos.func_177958_n() + rand.nextFloat()), (double)((float)pos.func_177956_o() + 0.95f), (double)((float)pos.func_177952_p() + rand.nextFloat()), 0.0, 0.0, 0.0, new int[0]);
        }
        puffs -= rand.nextInt(4) + 3;
        for (n = 0; n < puffs; ++n) {
            worldIn.func_175688_a(EnumParticleTypes.FLAME, (double)((float)pos.func_177958_n() + rand.nextFloat()), (double)((float)pos.func_177956_o() + 1.0f), (double)((float)pos.func_177952_p() + rand.nextFloat()), 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        items.add((Object)new ItemStack((Block)this, 1, 0));
        items.add((Object)new ItemStack((Block)this, 1, 1));
    }

    @Deprecated
    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    @Override
    public boolean needsRedstoneUpdates(int meta) {
        return false;
    }
}

