/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.high;

import com.google.common.math.DoubleMath;
import ic2.api.classic.audio.PositionSpec;
import ic2.api.classic.network.adv.NetworkField;
import ic2.api.classic.recipe.ClassicRecipes;
import ic2.api.classic.recipe.machine.IMachineRecipeList;
import ic2.api.classic.recipe.machine.MachineOutput;
import ic2.api.classic.tile.machine.IProgressMachine;
import ic2.api.recipe.IRecipeInput;
import ic2.core.IC2;
import ic2.core.RotationList;
import ic2.core.audio.AudioSource;
import ic2.core.block.base.tile.TileEntityElecMachine;
import ic2.core.block.base.util.comparator.ComparatorManager;
import ic2.core.block.base.util.comparator.comparators.ComparatorAmplifier;
import ic2.core.block.base.util.comparator.comparators.ComparatorProgress;
import ic2.core.block.base.util.info.AmplifierInfo;
import ic2.core.block.base.util.info.ProgressInfo;
import ic2.core.block.machine.high.container.ContainerMassFabricator;
import ic2.core.inventory.base.IHasGui;
import ic2.core.inventory.container.ContainerIC2;
import ic2.core.inventory.filters.CommonFilters;
import ic2.core.inventory.gui.GuiComponentContainer;
import ic2.core.inventory.management.AccessRule;
import ic2.core.inventory.management.InventoryHandler;
import ic2.core.inventory.management.SlotType;
import ic2.core.item.recipe.entry.RecipeInputItemStack;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2BlockLang;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.platform.registry.Ic2Sounds;
import ic2.core.util.misc.StackUtil;
import java.math.RoundingMode;
import java.util.Arrays;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;

public class TileEntityMassFabricator
extends TileEntityElecMachine
implements ITickable,
IProgressMachine,
IHasGui {
    @NetworkField(index=7)
    public int scrap = 0;
    @NetworkField(index=8, compression=NetworkField.BitLevel.Bit8)
    public int state = 0;
    private int prevState = 0;
    public int lastScrap = 0;
    private AudioSource audioSource;
    private AudioSource audioSourceScrap;
    private float multiplier = IC2.config.getFloat("uuEU");
    private boolean requireAmplifier = IC2.config.getFlag("UUScrap");

    public TileEntityMassFabricator() {
        super(2, 512);
        this.maxEnergy = DoubleMath.roundToInt((double)(7100000.0 * (double)this.multiplier), (RoundingMode)RoundingMode.UP);
        this.addNetworkFields("state");
        this.addGuiFields("scrap");
        this.addInfos(new ProgressInfo(this), new AmplifierInfo(this));
    }

    @Override
    protected void addSlots(InventoryHandler handler) {
        handler.registerDefaultSideAccess(AccessRule.Both, RotationList.ALL);
        handler.registerDefaultSlotAccess(AccessRule.Import, 0);
        handler.registerDefaultSlotAccess(AccessRule.Export, 1);
        handler.registerDefaultSlotsForSide(RotationList.HORIZONTAL, 0);
        handler.registerDefaultSlotsForSide(RotationList.VERTICAL, 1);
        handler.registerInputFilter(CommonFilters.MassFab, 0);
        handler.registerSlotType(SlotType.Input, 0);
        handler.registerSlotType(SlotType.Output, 1);
    }

    @Override
    protected void addComparators(ComparatorManager manager) {
        super.addComparators(manager);
        manager.removeComparator("EnergyStorage");
        manager.addComparatorMode(new ComparatorProgress(this));
        manager.addComparatorMode(new ComparatorAmplifier(this));
    }

    @Override
    public float getProgress() {
        return this.energy;
    }

    @Override
    public float getMaxProgress() {
        return 7000000.0f * this.multiplier;
    }

    @Override
    public LocaleComp getBlockName() {
        return Ic2BlockLang.massFabricator;
    }

    @Override
    public double injectEnergy(EnumFacing directionFrom, double amount, double voltage) {
        if (amount > 512.0 || amount <= 0.0) {
            return 0.0;
        }
        if (this.requireAmplifier && this.scrap <= 0) {
            return 0.0;
        }
        int bonus = (int)amount;
        if (bonus > this.scrap) {
            bonus = this.scrap;
        }
        this.scrap -= bonus;
        this.energy = (int)((double)this.energy + (amount + (double)(5 * bonus)));
        this.getNetwork().updateTileGuiField(this, "energy");
        this.getNetwork().updateTileGuiField(this, "scrap");
        if (this.scrap < 1000 && !((ItemStack)this.inventory.get(0)).func_190926_b()) {
            this.refillAmplifier();
        }
        return 0.0;
    }

    @Override
    public double getDemandedEnergy() {
        if (this.isRedstonePowered() || this.requireAmplifier && this.scrap <= 0) {
            return 0.0;
        }
        return super.getDemandedEnergy();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.scrap = nbt.func_74762_e("Scrap");
        this.lastScrap = nbt.func_74762_e("LastScrap");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("Scrap", this.scrap);
        nbt.func_74768_a("LastScrap", this.lastScrap);
        return nbt;
    }

    @Override
    public void onUnloaded() {
        if (this.isRendering() && this.audioSource != null) {
            IC2.audioManager.removeSources(this);
            this.audioSource = null;
            this.audioSourceScrap = null;
        }
        super.onUnloaded();
    }

    @Override
    public void onNetworkUpdate(String field) {
        if (field.equals("state") && this.prevState != this.state) {
            if (this.audioSource != null && this.audioSource.isRemoved()) {
                this.audioSource = null;
            }
            if (this.audioSourceScrap != null && this.audioSourceScrap.isRemoved()) {
                this.audioSourceScrap = null;
            }
            if (this.state == 0) {
                if (this.audioSource != null) {
                    this.audioSource.stop();
                }
                if (this.audioSourceScrap != null) {
                    this.audioSourceScrap.stop();
                }
            } else if (this.state == 1) {
                if (this.audioSource == null) {
                    this.audioSource = IC2.audioManager.createSource(this, PositionSpec.Center, Ic2Sounds.massFabLoop, true, false, IC2.audioManager.defaultVolume);
                }
                if (this.audioSource != null) {
                    this.audioSource.play();
                }
                if (this.audioSourceScrap != null) {
                    this.audioSourceScrap.stop();
                }
            } else if (this.state == 2) {
                if (this.audioSource == null) {
                    this.audioSource = IC2.audioManager.createSource(this, PositionSpec.Center, Ic2Sounds.massFabLoop, true, false, IC2.audioManager.defaultVolume);
                }
                if (this.audioSourceScrap == null) {
                    this.audioSourceScrap = IC2.audioManager.createSource(this, PositionSpec.Center, Ic2Sounds.massFabScrapLoop, true, false, IC2.audioManager.defaultVolume);
                }
                if (this.audioSource != null) {
                    this.audioSource.play();
                }
                if (this.audioSourceScrap != null) {
                    this.audioSourceScrap.play();
                }
            }
            this.prevState = this.state;
        }
        super.onNetworkUpdate(field);
    }

    private void setState(int state) {
        this.state = state;
        if (this.prevState != state) {
            this.getNetwork().updateTileEntityField(this, "state");
        }
        this.prevState = state;
    }

    @Override
    public boolean supportsNotify() {
        return true;
    }

    @Override
    public boolean needsInitialRedstoneUpdate() {
        return true;
    }

    public void func_73660_a() {
        this.handleRedstone();
        this.updateNeighbors();
        if (this.isRedstonePowered() || this.energy <= 0) {
            this.setState(0);
            this.setActive(false);
            if (this.requireAmplifier && this.scrap < 1000 && !((ItemStack)this.inventory.get(0)).func_190926_b()) {
                this.refillAmplifier();
            }
        } else {
            this.setState(this.scrap > 0 ? 2 : 1);
            this.setActive(true);
            if (this.scrap < 1000 && !((ItemStack)this.inventory.get(0)).func_190926_b()) {
                this.refillAmplifier();
            }
            if ((float)this.energy >= this.getMaxProgress()) {
                this.attemptGeneration();
                this.notifyNeighbors();
            }
        }
        this.updateComparators();
    }

    public void refillAmplifier() {
        IMachineRecipeList.RecipeEntry entry = ClassicRecipes.massfabAmplifier.getRecipeInAndOutput((ItemStack)this.inventory.get(0), false);
        if (entry != null) {
            if (((ItemStack)this.inventory.get(0)).func_77973_b().hasContainerItem((ItemStack)this.inventory.get(0))) {
                this.inventory.set(0, (Object)((ItemStack)this.inventory.get(0)).func_77973_b().getContainerItem((ItemStack)this.inventory.get(0)));
            } else {
                ((ItemStack)this.inventory.get(0)).func_190918_g(entry.getInput().getAmount());
            }
            int value = entry.getOutput().getMetadata().func_74762_e("amplification");
            this.scrap += value;
            this.lastScrap = value;
            this.getNetwork().updateTileGuiField(this, "scrap");
        }
    }

    public void attemptGeneration() {
        if (((ItemStack)this.inventory.get(1)).func_190926_b()) {
            this.inventory.set(1, (Object)Ic2Items.uuMatter.func_77946_l());
            this.energy = (int)((float)this.energy - this.getMaxProgress());
            this.getNetwork().updateTileGuiField(this, "energy");
            return;
        }
        if (!StackUtil.isStackEqual((ItemStack)this.inventory.get(1), Ic2Items.uuMatter) || ((ItemStack)this.inventory.get(1)).func_190916_E() >= ((ItemStack)this.inventory.get(1)).func_77976_d()) {
            return;
        }
        this.energy = (int)((float)this.energy - this.getMaxProgress());
        this.getNetwork().updateTileGuiField(this, "energy");
        ((ItemStack)this.inventory.get(1)).func_190917_f(1);
    }

    @Override
    public double getWrenchDropRate() {
        return 0.75;
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer player) {
        return new ContainerMassFabricator(player.field_71071_by, this);
    }

    @Override
    public Class<? extends GuiScreen> getGuiClass(EntityPlayer player) {
        return GuiComponentContainer.class;
    }

    @Override
    public void onGuiClosed(EntityPlayer player) {
    }

    @Override
    public boolean canInteractWith(EntityPlayer player) {
        return !this.func_145837_r();
    }

    @Override
    public boolean hasGui(EntityPlayer player) {
        return true;
    }

    public static void init() {
        TileEntityMassFabricator.addAmplifier(Ic2Items.scrap.func_77946_l(), 5000, "ScrapAmplifier");
        TileEntityMassFabricator.addAmplifier(Ic2Items.scrapBox.func_77946_l(), 45000, "ScrapboxAmplifier");
        TileEntityMassFabricator.addAmplifier(Ic2Items.scrapMetal.func_77946_l(), 100000, "ScrapMetalAmplifier");
    }

    public static void addAmplifier(ItemStack input, int amplifier, String id) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("amplification", amplifier);
        ClassicRecipes.massfabAmplifier.addRecipe((IRecipeInput)new RecipeInputItemStack(input), new MachineOutput(nbt, Arrays.asList(Ic2Items.uuMatter)), id);
    }
}

